/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.misc.MIDIConst;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SMFOverlapRemover
extends CMXCommand<MIDIXMLWrapper, MIDIXMLWrapper> {
    private static final double ON_ON = 0.1;
    private static final double ON_OFF = 0.5;
    private static final int OFF_ON = -1;
    String outSMFFileName;
    String outSCCFileName;
    MIDIEventWithTime[][] last1 = new MIDIEventWithTime[128][16];
    MIDIEventWithTime[][] last2 = new MIDIEventWithTime[128][16];
    int div;
    int nTracks = 1;

    SMFOverlapRemover() {
    }

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-smf")) {
            this.outSMFFileName = string2;
            return true;
        }
        if (string.equals("-scc")) {
            this.outSCCFileName = string2;
            return true;
        }
        return false;
    }

    @Override
    protected MIDIXMLWrapper readInputData(String string) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        return MIDIXMLWrapper.readSMF(string);
    }

    @Override
    protected MIDIXMLWrapper run(MIDIXMLWrapper mIDIXMLWrapper) throws ParserConfigurationException, SAXException, TransformerException, IOException {
        MIDIXMLWrapper mIDIXMLWrapper2 = (MIDIXMLWrapper)CMXFileWrapper.createDocument("MIDIFile");
        if (mIDIXMLWrapper.format() == 0) {
            this.div = mIDIXMLWrapper.ticksPerBeat();
            mIDIXMLWrapper2.addElementsFirstForFormat0(this.div);
        } else if (mIDIXMLWrapper.format() == 1) {
            this.nTracks = mIDIXMLWrapper.trackCount();
            this.div = mIDIXMLWrapper.ticksPerBeat();
            mIDIXMLWrapper2.addElementsFirstForFormat1(this.nTracks, this.div);
        } else {
            throw new IllegalStateException("unsupported SMF");
        }
        MIDIXMLWrapper.Track[] trackArray = mIDIXMLWrapper.getTrackList();
        for (int i = 0; i < trackArray.length; ++i) {
            int n = 0;
            MIDIXMLWrapper.MIDIEvent[] mIDIEventArray = trackArray[i].getMIDIEventList();
            ArrayList<MIDIEventWithTime> arrayList = new ArrayList<MIDIEventWithTime>();
            for (MIDIXMLWrapper.MIDIEvent mIDIEvent : mIDIEventArray) {
                MIDIEventWithTime mIDIEventWithTime = new MIDIEventWithTime(mIDIEvent, n += mIDIEvent.deltaTime());
                this.addMIDIEventWithTime(mIDIEventWithTime, arrayList);
            }
            System.err.println();
            Collections.sort(arrayList);
            mIDIXMLWrapper2.newTrack(i);
            this.addMIDIEventsToMIDIXML(arrayList, mIDIXMLWrapper2);
            mIDIXMLWrapper2.endTrack(false);
            System.err.println();
        }
        if (this.outSMFFileName != null) {
            mIDIXMLWrapper2.finalizeDocument();
            mIDIXMLWrapper2.writefileAsSMF(this.outSMFFileName);
        } else if (this.outSCCFileName != null) {
            mIDIXMLWrapper2.finalizeDocument();
            mIDIXMLWrapper2.toSCCXML().writefile(this.outSCCFileName);
        }
        return mIDIXMLWrapper2;
    }

    private void addMIDIEventWithTime(MIDIEventWithTime mIDIEventWithTime, List<MIDIEventWithTime> list) {
        if (this.isNoteOn(mIDIEventWithTime)) {
            int n = mIDIEventWithTime.evt.value(0);
            byte by = mIDIEventWithTime.evt.channel();
            this.last2[n][by] = this.last1[n][by];
            this.last1[n][by] = mIDIEventWithTime;
        } else if (this.isNoteOff(mIDIEventWithTime)) {
            byte by;
            int n = mIDIEventWithTime.evt.value(0);
            if (this.last2[n][by = mIDIEventWithTime.evt.channel()] != null && this.last1[n][by] != null && this.isNoteOn(this.last2[n][by]) && this.isNoteOn(this.last1[n][by])) {
                if ((double)(this.last1[n][by].time - this.last2[n][by].time) > (double)this.div * 0.1 && (double)(mIDIEventWithTime.time - this.last1[n][by].time) < (double)this.div * 0.5) {
                    mIDIEventWithTime.time = this.last1[n][by].time + -1;
                    this.last2[n][by] = mIDIEventWithTime;
                } else {
                    this.last2[n][by] = this.last1[n][by];
                    this.last1[n][by] = mIDIEventWithTime;
                }
            } else {
                this.last2[n][by] = this.last1[n][by];
                this.last1[n][by] = mIDIEventWithTime;
            }
        }
        list.add(mIDIEventWithTime);
    }

    private boolean isNoteOn(MIDIEventWithTime mIDIEventWithTime) {
        return mIDIEventWithTime.evt.messageType().equals("NoteOn") && mIDIEventWithTime.evt.value(1) > 0;
    }

    private boolean isNoteOff(MIDIEventWithTime mIDIEventWithTime) {
        return mIDIEventWithTime.evt.messageType().equals("NoteOff") || mIDIEventWithTime.evt.messageType().equals("NoteOn") && mIDIEventWithTime.evt.value(1) == 0;
    }

    private void addMIDIEventsToMIDIXML(List<MIDIEventWithTime> list, MIDIXMLWrapper mIDIXMLWrapper) {
        MIDIEventWithTime mIDIEventWithTime = null;
        for (MIDIEventWithTime mIDIEventWithTime2 : list) {
            int n = mIDIEventWithTime == null ? mIDIEventWithTime2.time : mIDIEventWithTime2.time - mIDIEventWithTime.time;
            if (MIDIConst.isSupportedMessage(mIDIEventWithTime2.evt.messageType())) {
                mIDIXMLWrapper.addMIDIChannelMessage(mIDIEventWithTime2.evt.messageType(), n, mIDIEventWithTime2.evt.channel(), mIDIEventWithTime2.evt.values());
            } else {
                mIDIXMLWrapper.addMetaEvent(mIDIEventWithTime2.evt.messageType(), n, mIDIEventWithTime2.evt.values());
            }
            mIDIEventWithTime = mIDIEventWithTime2;
        }
    }

    public static void main(String[] stringArray) {
        SMFOverlapRemover sMFOverlapRemover = new SMFOverlapRemover();
        try {
            sMFOverlapRemover.start(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    class MIDIEventWithTime
    implements Comparable {
        MIDIXMLWrapper.MIDIEvent evt;
        int time;

        MIDIEventWithTime(MIDIXMLWrapper.MIDIEvent mIDIEvent, int n) {
            this.evt = mIDIEvent;
            this.time = n;
        }

        public int compareTo(Object object) {
            return this.time - ((MIDIEventWithTime)object).time;
        }
    }
}

