/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import jp.crestmuse.cmx.math.DoubleArrayFactory;

public class SPUtils {
    private static DoubleArrayFactory factory = DoubleArrayFactory.getFactory();

    SPUtils() {
    }

    public static final double[] rectangle(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 1.0;
        }
        return dArray;
    }

    public static final double[] hamming(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i / (double)n);
        }
        return dArray;
    }

    public static final double[] hanning(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)n);
        }
        return dArray;
    }

    public static final double[] gaussian(int n, double d) {
        double[] dArray = new double[n];
        double d2 = (double)n * 0.5;
        double d3 = 1.0 / d;
        for (int i = 0; i < n; ++i) {
            double d4 = ((double)i - d2) * d3;
            dArray[i] = Math.exp(-0.5 * d4 * d4);
        }
        return dArray;
    }

    public static final double[] gaussian(int n) {
        return SPUtils.gaussian(n, (double)n / 6.0);
    }
}

