/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import jp.crestmuse.cmx.amusaj.sp.MidiEventWithTicktime;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.TimeSeriesCompatible;
import jp.crestmuse.cmx.sound.TickTimer;

public class MidiEventSender
extends SPModule {
    private TickTimer tt = null;
    private BlockingQueue src_queue = new SynchronousQueue();

    public void setTickTimer(TickTimer tickTimer) {
        this.tt = tickTimer;
    }

    public void sendNoteOn(long l, int n, int n2, int n3) {
        try {
            this.src_queue.put(MidiEventWithTicktime.createNoteOnEvent(l, n, n2, n3));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendNoteOnDelayed(final long l, final int n, final int n2, final int n3, final long l2) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    1.sleep(l2);
                    MidiEventSender.this.sendNoteOn(l, n, n2, n3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public void sendNoteOff(long l, int n, int n2, int n3) {
        try {
            this.src_queue.put(MidiEventWithTicktime.createNoteOffEvent(l, n, n2, n3));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendNoteOffDelayed(final long l, final int n, final int n2, final int n3, final long l2) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    2.sleep(l2);
                    MidiEventSender.this.sendNoteOff(l, n, n2, n3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public void sendControlChange(long l, int n, int n2, int n3) {
        try {
            this.src_queue.put(MidiEventWithTicktime.createControlChangeEvent(l, n, n2, n3));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendControlChangeDelayed(final long l, final int n, final int n2, final int n3, final long l2) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    3.sleep(l2);
                    MidiEventSender.this.sendControlChange(l, n, n2, n3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public void sendProgramChange(long l, int n, int n2) {
        try {
            this.src_queue.put(MidiEventWithTicktime.createProgramChangeEvent(l, n, n2));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void sendProgramChangeDelayed(final long l, final int n, final int n2, final long l2) {
        Thread thread = new Thread(){

            public void run() {
                try {
                    4.sleep(l2);
                    MidiEventSender.this.sendProgramChange(l, n, n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        while (true) {
            timeSeriesCompatibleArray[0].add(this.src_queue.take());
        }
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{MidiEventWithTicktime.class};
    }
}

