/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.LinkedList;
import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.HarmonicsTimeSeries;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.amusaj.sp.TimeSeriesCompatible;

public class HarmonicsTimeSeriesGenerator
extends SPModule {
    private int nFrames;
    private int nHarmonics;
    private boolean setParams = false;
    private LinkedList<HTS> hlist = new LinkedList();

    private void setParams() {
        AmusaParameterSet amusaParameterSet = AmusaParameterSet.getInstance();
        this.nHarmonics = amusaParameterSet.getParamInt("harmonics", "NUM_OF_HARMONICS");
        this.nFrames = amusaParameterSet.getParamInt("harmonics", "NUM_OF_FRAMES");
        this.setParams = true;
    }

    public Class[] getInputClasses() {
        return new Class[]{PeakSet.class};
    }

    public Class[] getOutputClasses() {
        return new Class[]{HarmonicsTimeSeries.class};
    }

    public void execute(Object[] objectArray, TimeSeriesCompatible[] timeSeriesCompatibleArray) throws InterruptedException {
        if (!this.setParams) {
            this.setParams();
        }
        PeakSet peakSet = (PeakSet)objectArray[0];
        this.hlist.add(new HTS());
        for (HTS hTS : this.hlist) {
            hTS.h.set(hTS.next, peakSet);
            ++hTS.next;
        }
        if (this.hlist.getFirst().next >= this.nFrames) {
            timeSeriesCompatibleArray[0].add(this.hlist.removeFirst().h);
        }
    }

    private class HTS {
        HarmonicsTimeSeries h;
        int next;

        HTS() {
            this.h = new HarmonicsTimeSeries(HarmonicsTimeSeriesGenerator.this.nFrames, HarmonicsTimeSeriesGenerator.this.nHarmonics);
            this.next = 0;
        }
    }
}

