/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.IOException;
import javax.sound.sampled.LineUnavailableException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.commands.ModuleConnection;
import jp.crestmuse.cmx.amusaj.commands.OptionUtils;
import jp.crestmuse.cmx.amusaj.commands.OutputData;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSet;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSetCompatible;
import jp.crestmuse.cmx.amusaj.sp.AmusaParameterSet;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import jp.crestmuse.cmx.filewrappers.WAVWrapper;
import jp.crestmuse.cmx.sound.AudioInputStreamWrapper;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWAVAnalyzer
extends CMXCommand<WAVWrapper, FileWrapperCompatible> {
    private AmusaDataSet dataset = null;
    WindowSlider winslider = null;
    private boolean fromMic = false;
    private int fs = 16000;

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        if (OptionUtils.setFFTOptions(string, string2)) {
            return true;
        }
        if (string.equals("-fs")) {
            this.fs = Integer.valueOf(string2);
            return true;
        }
        return false;
    }

    @Override
    protected boolean setBoolOptionsLocal(String string) {
        if (super.setBoolOptionsLocal(string)) {
            return true;
        }
        if (string.equals("-mic")) {
            this.fromMic = true;
            return true;
        }
        return false;
    }

    protected String getParam(String string, String string2) {
        return AmusaParameterSet.getInstance().getParam(string, string2);
    }

    protected int getParamInt(String string, String string2) {
        return AmusaParameterSet.getInstance().getParamInt(string, string2);
    }

    protected double getParamDouble(String string, String string2) {
        return AmusaParameterSet.getInstance().getParamDouble(string, string2);
    }

    protected void setParam(String string, String string2, String string3) {
        AmusaParameterSet.getInstance().setParam(string, string2, string3);
    }

    protected void setParam(String string, String string2, int n) {
        AmusaParameterSet.getInstance().setParam(string, string2, n);
    }

    protected void setParam(String string, String string2, double d) {
        AmusaParameterSet.getInstance().setParam(string, string2, d);
    }

    @Override
    protected int requiredFiles() {
        return this.fromMic ? 0 : 1;
    }

    protected boolean usesStereo() {
        return false;
    }

    @Override
    protected FileWrapperCompatible readInputData(String string) throws IOException {
        return WAVWrapper.readfile(string);
    }

    @Override
    protected void preproc() throws IOException, ParserConfigurationException, TransformerException, SAXException {
        AmusaParameterSet.getInstance().setAnotherParameterSet(CMXCommand.getConfigXMLWrapper());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected AmusaDataSetCompatible run(WAVWrapper wAVWrapper) throws IOException, ParserConfigurationException, TransformerException, SAXException {
        void var7_13;
        AudioInputStreamWrapper audioInputStreamWrapper;
        SPExecutor sPExecutor = new SPExecutor();
        this.winslider = new WindowSlider(this.usesStereo());
        if (wAVWrapper != null) {
            this.winslider.setInputData(wAVWrapper);
            audioInputStreamWrapper = null;
        } else {
            try {
                audioInputStreamWrapper = AudioInputStreamWrapper.createWrapper16(this.fs, null);
                this.winslider.setInputData(audioInputStreamWrapper);
                audioInputStreamWrapper.getLine().start();
            }
            catch (LineUnavailableException lineUnavailableException) {
                throw new IOException();
            }
        }
        sPExecutor.addSPModule(this.winslider);
        for (ProducerConsumerCompatible object : this.getUsedModules()) {
            sPExecutor.addSPModule(object);
        }
        for (ModuleConnection moduleConnection : this.getModuleConnections()) {
            sPExecutor.connect(moduleConnection.inModule, moduleConnection.inCh, moduleConnection.outModule, moduleConnection.outCh);
        }
        AmusaDataSet amusaDataSet = new AmusaDataSet(this.getAmusaXMLFormat());
        Object targetDataLine = this.getOutputData();
        int n = ((OutputData[])targetDataLine).length;
        boolean bl = false;
        while (var7_13 < n) {
            OutputData outputData = targetDataLine[var7_13];
            TimeSeriesCompatible timeSeriesCompatible = sPExecutor.getResult(outputData.module).get(outputData.ch);
            amusaDataSet.add(timeSeriesCompatible);
            ++var7_13;
        }
        this.customSetting(sPExecutor, amusaDataSet);
        sPExecutor.start();
        if (audioInputStreamWrapper != null) {
            System.in.read();
            targetDataLine = audioInputStreamWrapper.getLine();
            targetDataLine.stop();
            targetDataLine.drain();
            targetDataLine.close();
        }
        return amusaDataSet;
    }

    protected abstract ProducerConsumerCompatible[] getUsedModules();

    protected abstract ModuleConnection[] getModuleConnections();

    protected abstract String getAmusaXMLFormat();

    protected abstract OutputData[] getOutputData();

    protected void customSetting(SPExecutor sPExecutor, AmusaDataSetCompatible amusaDataSetCompatible) {
    }

    protected WindowSlider getWindowSlider() {
        return this.winslider;
    }

    static {
        AbstractWAVAnalyzer.addOptionHelpMessage("-winsize <winsize>", "window size in STFT");
        AbstractWAVAnalyzer.addOptionHelpMessage("-wintype {hamming|hanning|gaussian}", "window type in STFT");
        AbstractWAVAnalyzer.addOptionHelpMessage("-shift <value>", "shift size in STFT");
    }
}

