/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.sound;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import jp.crestmuse.cmx.gui.CMXMusicDataFrame;
import jp.crestmuse.cmx.gui.sound.MIDIEventListener;
import jp.crestmuse.cmx.gui.sound.MIDIExpressionDataSet;
import jp.crestmuse.cmx.gui.sound.NoteEvent;
import jp.crestmuse.cmx.gui.sound.TimeEventMap;
import jp.crestmuse.cmx.sound.SMFPlayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIDIController
implements MIDIEventListener {
    public static final String THREAD_PLAYER = "Thread Player";
    public static final String SMF_PLAYER = "SMF Player";
    private static final int MIDI_TIMESTAMP = -1;
    private static final int DEFAULT_INSTRUMENT = 0;
    private static final String DEFAULT_DEVICENAME = "Microsoft GS Wavetable SW Synth";
    private static final boolean DEBUG = false;
    private static String FUNCTION_MODE = "SMF Player";
    private SMFPlayer smfplayer;
    private ThreadPlayer threadPlayer = null;
    private MidiDevice device;
    private Receiver receiver;
    private Map<Integer, Boolean> soundNotesStatus = new TreeMap<Integer, Boolean>();

    public static MIDIController createMIDIController(String string) {
        MIDIController mIDIController = new MIDIController(string);
        return mIDIController;
    }

    public static void setupPlayerFunc(String string) {
        FUNCTION_MODE = string;
    }

    public MIDIController(String string) {
        for (int i = 0; i < 127; ++i) {
            this.soundNotesStatus.put(i, false);
        }
        this.openMidiDevice(string);
    }

    public void close() {
        if (this.receiver != null) {
            this.receiver.close();
        }
        if (this.device != null) {
            this.device.close();
        }
    }

    public final MidiMessage getMidiMessage(LinkedList<NoteEvent> linkedList, double d) {
        if (linkedList.size() > 0 && (double)linkedList.peek().getOnset() < d) {
            return linkedList.poll().getMidiMessage();
        }
        return null;
    }

    public void noteOff(int n) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(128, n, 127);
            this.sendMessage(shortMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public void noteOn(int n, int n2) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(144, n, n2);
            this.sendMessage(shortMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
    }

    public void startPlaying(String string) {
        try {
            if (this.smfplayer != null) {
                this.smfplayer.close();
            }
            this.smfplayer = new SMFPlayer();
            this.smfplayer.readSMF(new File(string));
            this.smfplayer.play();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startPlaying(InputStream inputStream) {
        try {
            if (this.smfplayer != null) {
                this.smfplayer.close();
            }
            this.smfplayer = new SMFPlayer();
            this.smfplayer.readSMF(inputStream);
            this.smfplayer.play();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startPlaying(MIDIExpressionDataSet mIDIExpressionDataSet, TimeEventMap timeEventMap) {
        mIDIExpressionDataSet.setMIDIEventList(timeEventMap);
        try {
            if (this.threadPlayer != null && this.threadPlayer.isAlive()) {
                this.resetReceiver();
            }
            this.threadPlayer = new ThreadPlayer((LinkedList)mIDIExpressionDataSet.getMidiEventList());
            this.threadPlayer.start();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public void stopPlaying() {
        if (FUNCTION_MODE.equals(SMF_PLAYER)) {
            this.smfplayer.stop();
        } else if (FUNCTION_MODE.equals(THREAD_PLAYER)) {
            this.threadPlayer.isRunning = false;
            this.sendAllSoundOff();
        }
    }

    private void checkAllMidiDevices() {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        System.out.println("There are " + infoArray.length + " devices.");
        for (int i = 0; i < infoArray.length; ++i) {
            System.out.println("Midi device " + i);
            System.out.println("  Description:" + infoArray[i].getDescription());
            System.out.println("  Name:" + infoArray[i].getName());
            System.out.println("  Vendor:" + infoArray[i].getVendor());
            try {
                MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[i]);
                if (midiDevice instanceof Sequencer) {
                    System.out.println("  *** This is Sequencer.");
                }
                if (!(midiDevice instanceof Synthesizer)) continue;
                System.out.println("  *** This is Synthesizer.");
                continue;
            }
            catch (MidiUnavailableException midiUnavailableException) {
                midiUnavailableException.printStackTrace();
            }
        }
    }

    private MidiDevice getInternalSoftwareSynthesizer(String string) throws MidiUnavailableException {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        int n = 0;
        for (int i = 0; i < infoArray.length; ++i) {
            if (infoArray[i].getName().equals(string)) {
                return MidiSystem.getMidiDevice(infoArray[i]);
            }
            if (!infoArray[i].getName().equals(DEFAULT_DEVICENAME)) continue;
            n = i;
        }
        return MidiSystem.getMidiDevice(infoArray[n]);
    }

    private void openMidiDevice(String string) {
        this.checkAllMidiDevices();
        if (this.device != null) {
            this.close();
        }
        try {
            this.device = this.getInternalSoftwareSynthesizer(string);
            if (!this.device.isOpen()) {
                this.device.open();
                System.out.println(this.device.getDeviceInfo().getName() + " is opened.");
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
            this.device.close();
            return;
        }
        try {
            this.receiver = this.device.getReceiver();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            try {
                this.receiver = MidiSystem.getReceiver();
            }
            catch (MidiUnavailableException midiUnavailableException2) {
                midiUnavailableException2.printStackTrace();
                return;
            }
        }
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(192, 0, 0, 0);
            this.sendMessage(shortMessage);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return;
        }
    }

    private void resetReceiver() throws InterruptedException {
        if (this.threadPlayer != null) {
            System.out.println("synthesizer reset...");
            this.threadPlayer.join(1000L);
        }
    }

    private void sendAllSoundOff() {
        System.out.println("all sound off");
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(176, 120, 0);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
        }
        for (int i = 0; i < 127; ++i) {
            try {
                shortMessage.setMessage(128, i, 127);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                invalidMidiDataException.printStackTrace();
            }
            this.sendMessage(shortMessage);
        }
    }

    private synchronized void sendMessage(MidiMessage midiMessage) {
        this.receiver.send(midiMessage, -1L);
        if (midiMessage instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)midiMessage;
        } else if (midiMessage instanceof MetaMessage) {
            MetaMessage metaMessage = (MetaMessage)midiMessage;
        }
    }

    @Override
    public void startPlaying(String string, MIDIExpressionDataSet mIDIExpressionDataSet, TimeEventMap timeEventMap) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ThreadPlayer
    extends Thread {
        private static final int RUNNING_TIME_INTERVAL = 3;
        private boolean isRunning = false;
        private LinkedList<NoteEvent> midiEventList;

        public ThreadPlayer(LinkedList<NoteEvent> linkedList) {
            this.midiEventList = linkedList;
        }

        @Override
        public void run() {
            this.isRunning = true;
            double d = System.currentTimeMillis();
            if (this.midiEventList.size() > 0) {
                d -= (double)this.midiEventList.getFirst().getOnset();
            }
            System.out.println("===== start playing =====");
            while (true) {
                try {
                    Thread.sleep(3L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    break;
                }
                double d2 = (double)System.currentTimeMillis() - d;
                if (!this.isRunning) break;
                if (this.midiEventList.size() <= 0) {
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    System.out.println("midimessage finished.");
                    CMXMusicDataFrame.notifyStopPlaying();
                    break;
                }
                ShortMessage shortMessage = (ShortMessage)MIDIController.this.getMidiMessage(this.midiEventList, d2);
                if (shortMessage == null) continue;
                if (shortMessage.getStatus() == 144) {
                    MIDIController.this.soundNotesStatus.put(shortMessage.getData1(), true);
                } else if (shortMessage.getStatus() == 128) {
                    if (!((Boolean)MIDIController.this.soundNotesStatus.get(shortMessage.getData1())).booleanValue()) continue;
                    MIDIController.this.soundNotesStatus.put(shortMessage.getData1(), false);
                }
                MIDIController.this.sendMessage(shortMessage);
                shortMessage = null;
            }
        }
    }
}

