/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.misc.TreeView;

public class NoteViewPanel
extends JPanel
implements MouseMotionListener {
    String filename;
    MusicXMLWrapper musicxml;
    TreeView<MusicXMLWrapper.Note> noteview;
    TreeLabel label;

    public NoteViewPanel(String string) throws Exception {
        this.filename = string;
        this.musicxml = (MusicXMLWrapper)CMXFileWrapper.readfile(string);
        this.noteview = this.musicxml.getPartwiseNoteView().get(0);
        this.setLayout(null);
        this.label = this.addLabels(this.noteview.getRoot(), 10, 10);
    }

    private TreeLabel addLabels(MusicXMLWrapper.Note note, int n, int n2) {
        TreeLabel treeLabel = new TreeLabel(note != null ? note.toString() : "null");
        treeLabel.setOpaque(true);
        treeLabel.setBackground(Color.CYAN);
        treeLabel.addMouseMotionListener(this);
        Dimension dimension = treeLabel.getPreferredSize();
        treeLabel.setBounds(n, n2, dimension.width, dimension.height);
        this.add(treeLabel);
        if (this.noteview.hasNextL()) {
            treeLabel.childL = this.addLabels(this.noteview.nextL(), n, n2 + 20);
            this.noteview.parent();
        }
        if (this.noteview.hasNextR()) {
            treeLabel.childR = this.addLabels(this.noteview.nextR(), n + 150, n2);
            this.noteview.parent();
        }
        return treeLabel;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        TreeLabel treeLabel = (TreeLabel)mouseEvent.getSource();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.updateLocations(treeLabel, n, n2);
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private void updateLocations(TreeLabel treeLabel, int n, int n2) {
        Point point = treeLabel.getLocation();
        treeLabel.setLocation(point.x + n, point.y + n2);
        if (treeLabel.childL != null) {
            this.updateLocations(treeLabel.childL, n, n2);
        }
        if (treeLabel.childR != null) {
            this.updateLocations(treeLabel.childR, n, n2);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawLines(this.label, graphics);
    }

    private void drawLines(TreeLabel treeLabel, Graphics graphics) {
        Point point;
        Point point2;
        if (treeLabel.childL != null) {
            point2 = treeLabel.getLocation();
            point = treeLabel.childL.getLocation();
            graphics.drawLine(point2.x, point2.y, point.x, point.y);
            this.drawLines(treeLabel.childL, graphics);
        }
        if (treeLabel.childR != null) {
            point2 = treeLabel.getLocation();
            point = treeLabel.childR.getLocation();
            graphics.drawLine(point2.x, point2.y, point.x, point.y);
            this.drawLines(treeLabel.childR, graphics);
        }
    }

    public static void main(String[] stringArray) {
        try {
            JFrame jFrame = new JFrame();
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(640, 480);
            jFrame.getContentPane().add(new NoteViewPanel(stringArray[0]));
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class TreeLabel
    extends JLabel {
        private TreeLabel childL;
        private TreeLabel childR;

        TreeLabel(String string) {
            super(string);
        }
    }
}

