/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.filewrappers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jp.crestmuse.cmx.filewrappers.CMXInitializer;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import jp.crestmuse.cmx.filewrappers.InvalidFileTypeException;
import jp.crestmuse.cmx.misc.ExternalLibraryException;
import jp.crestmuse.cmx.misc.NodeLinkManager;
import jp.crestmuse.cmx.misc.ProgramBugException;
import jp.crestmuse.cmx.misc.XMLException;
import jp.crestmuse.cmx.xml.processors.SimplifiedXPointerProcessor;
import org.apache.xerces.util.XMLCatalogResolver;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public abstract class CMXFileWrapper
implements FileWrapperCompatible {
    private static DocumentBuilderFactory builderFactory;
    private static DocumentBuilder builder;
    private static DOMImplementation domImpl;
    private static XPathFactory xpathFactory;
    private static XPath xpath;
    public static String catalogFileName;
    private static final String PACKAGE_BASE = "jp.crestmuse.cmx.filewrappers";
    private static final String AMUSA_PACKAGE_BASE = "jp.crestmuse.cmx.amusaj.filewrappers";
    private static final Map<String, Class> CLASS_TABLE;
    private static final Map<String, String> DTD_PUBLIC_ID_TABLE;
    private static final Map<String, String> DTD_SYSTEM_ID_TABLE;
    private Document doc;
    private Node currentNode = null;
    private Node parentNode = null;
    private String filename = null;
    private Node prevCurrentNode = null;
    private Node prevParentNode = null;
    private boolean finalized = false;
    public static final NodeLinkManager linkmanager;

    static String getDefaultPackageName() {
        return PACKAGE_BASE;
    }

    public static void addClassTable(String string, String string2) throws ClassNotFoundException {
        CLASS_TABLE.put(string, Class.forName(string2));
    }

    public static void addDocumentTypeTable(String string, String string2, String string3) {
        DTD_PUBLIC_ID_TABLE.put(string, string2);
        DTD_SYSTEM_ID_TABLE.put(string, string3);
    }

    private static void initXMLProcessors() throws ParserConfigurationException, SAXException {
        if (builderFactory == null) {
            builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setIgnoringComments(true);
            builderFactory.setIgnoringElementContentWhitespace(true);
        }
        if (builder == null) {
            builder = builderFactory.newDocumentBuilder();
            if (catalogFileName != null) {
                XMLCatalogResolver xMLCatalogResolver = new XMLCatalogResolver(new String[]{catalogFileName});
                builder.setEntityResolver((EntityResolver)xMLCatalogResolver);
            }
        }
        if (domImpl == null) {
            domImpl = builder.getDOMImplementation();
        }
        if (xpathFactory == null) {
            xpathFactory = XPathFactory.newInstance();
        }
        if (xpath == null) {
            xpath = xpathFactory.newXPath();
        }
    }

    private static CMXFileWrapper createInstance(String string) throws InvalidFileTypeException {
        try {
            CMXFileWrapper.initXMLProcessors();
            CMXFileWrapper cMXFileWrapper = (CMXFileWrapper)CLASS_TABLE.get(string).newInstance();
            return cMXFileWrapper;
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidFileTypeException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ProgramBugException(illegalAccessException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidFileTypeException();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new XMLException(sAXException);
        }
    }

    protected final Document getDocument() {
        return this.doc;
    }

    public static CMXFileWrapper createDocument(String string) throws InvalidFileTypeException {
        try {
            CMXFileWrapper.initXMLProcessors();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new XMLException(sAXException);
        }
        DocumentType documentType = DTD_PUBLIC_ID_TABLE.containsKey(string) ? domImpl.createDocumentType(string, DTD_PUBLIC_ID_TABLE.get(string), DTD_SYSTEM_ID_TABLE.get(string)) : null;
        Document document = domImpl.createDocument(null, string, documentType);
        CMXFileWrapper cMXFileWrapper = CMXFileWrapper.createInstance(string);
        cMXFileWrapper.doc = document;
        cMXFileWrapper.currentNode = document.getDocumentElement();
        cMXFileWrapper.init();
        return cMXFileWrapper;
    }

    public final void finalizeDocument() throws IOException {
        this.finalized = true;
        this.analyze();
    }

    public static CMXFileWrapper read(InputStream inputStream) throws IOException {
        try {
            CMXFileWrapper.initXMLProcessors();
            return CMXFileWrapper.wrap(builder.parse(inputStream), null, null);
        }
        catch (SAXException sAXException) {
            throw new XMLException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException(parserConfigurationException);
        }
    }

    public static CMXFileWrapper readfile(String string) throws IOException {
        return CMXFileWrapper.readfile(string, null);
    }

    public static CMXFileWrapper readfile(String string, CMXInitializer cMXInitializer) throws IOException {
        return CMXFileWrapper.readfile(new File(string), cMXInitializer);
    }

    public static CMXFileWrapper readfile(File file, CMXInitializer cMXInitializer) throws IOException {
        try {
            Document document;
            CMXFileWrapper.initXMLProcessors();
            String string = file.getName();
            if (string.endsWith("z") || string.endsWith("Z")) {
                GZIPInputStream gZIPInputStream = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
                document = builder.parse(gZIPInputStream);
                ((InputStream)gZIPInputStream).close();
            } else {
                document = builder.parse(file);
            }
            return CMXFileWrapper.wrap(document, file.getPath(), cMXInitializer);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new XMLException(sAXException);
        }
    }

    private static CMXFileWrapper wrap(Document document, String string, CMXInitializer cMXInitializer) throws IOException {
        String string2 = document.getDocumentElement().getTagName();
        CMXFileWrapper cMXFileWrapper = CMXFileWrapper.createInstance(string2);
        cMXFileWrapper.filename = string;
        cMXFileWrapper.doc = document;
        cMXFileWrapper.currentNode = document.getDocumentElement();
        cMXFileWrapper.removeBlankTextNodes();
        cMXFileWrapper.finalized = true;
        if (cMXInitializer != null) {
            cMXInitializer.init(cMXFileWrapper);
        }
        cMXFileWrapper.analyze();
        return cMXFileWrapper;
    }

    public static CMXFileWrapper wrap(Document document) throws IOException {
        return CMXFileWrapper.wrap(document, null, null);
    }

    protected void init() {
    }

    public final String getFileName() {
        return this.filename;
    }

    public final String getURI() {
        return this.doc.getDocumentURI();
    }

    public final void write(OutputStream outputStream) throws IOException, SAXException {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndent(2);
        XMLSerializer xMLSerializer = new XMLSerializer(outputStream, outputFormat);
        xMLSerializer.serialize(this.doc);
        outputStream.close();
    }

    public final void write(Writer writer) throws IOException, SAXException {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndent(2);
        XMLSerializer xMLSerializer = new XMLSerializer(writer, outputFormat);
        xMLSerializer.serialize(this.doc);
        writer.close();
    }

    public final void writefile(String string) throws IOException, SAXException {
        this.write(new FileWriter(new File(string)));
    }

    public final void writefile(File file) throws IOException, SAXException {
        this.write(new FileWriter(file));
    }

    public final void writeGZippedFile(String string) throws IOException, SAXException {
        this.writeGZippedFile(new File(string));
    }

    public final void writeGZippedFile(File file) throws IOException, SAXException {
        this.write(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
    }

    protected final NodeList selectNodeList(String string) {
        return this.selectNodeList(this.doc, string);
    }

    protected final NodeList selectNodeList(Node node, String string) {
        try {
            this.checkFinalized();
            return (NodeList)xpath.evaluate(string, node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new XMLException(xPathExpressionException);
        }
    }

    protected final void resetXPath() {
        xpath.reset();
    }

    protected final void setNamespaceContext() {
        xpath.setNamespaceContext(new NamespaceContext(){

            public String getNamespaceURI(String string) {
                Element element = CMXFileWrapper.this.doc.getDocumentElement();
                if (string == null) {
                    throw new NullPointerException("Null prefix");
                }
                if ("xml".equals(string)) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                if ("xmlns".equals(string)) {
                    return "http://www.w3.org/2000/xmlns/";
                }
                if ("".equals(string) && element.hasAttribute("xmlns")) {
                    return element.getAttribute("xmlns");
                }
                if (element.hasAttribute("xmlns:" + string)) {
                    return element.getAttribute("xmlns:" + string);
                }
                return "";
            }

            public String getPrefix(String string) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String string) {
                throw new UnsupportedOperationException();
            }
        });
    }

    protected final Node selectSingleNode(String string) {
        return this.selectSingleNode(this.doc, string);
    }

    protected final Node selectSingleNode(Node node, String string) {
        try {
            this.checkFinalized();
            return (Node)xpath.evaluate(string, node, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new XMLException(xPathExpressionException);
        }
    }

    private final void removeBlankTextNodes() {
        this.removeBlankTextNodes(this.doc, null);
    }

    private final boolean removeBlankTextNodes(Node node, Node node2) {
        if (node.getNodeType() == 3) {
            if (node.getNodeValue().trim().length() == 0) {
                node2.removeChild(node);
                return true;
            }
            return false;
        }
        if (node.getNodeType() == 1) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!this.removeBlankTextNodes(nodeList.item(i), node)) continue;
                --i;
            }
            return false;
        }
        if (node.getNodeType() == 9) {
            this.removeBlankTextNodes(((Document)node).getDocumentElement(), null);
            return false;
        }
        return false;
    }

    protected final void addLinks(String string, CMXFileWrapper cMXFileWrapper) throws TransformerException {
        this.addLinks(string, cMXFileWrapper.getDocument());
    }

    protected final void addLinks(String string, Document document) throws TransformerException {
        NodeList nodeList = this.selectNodeList(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = SimplifiedXPointerProcessor.getRemoteResource(node, document);
            linkmanager.addLink(node, nodeList2);
        }
    }

    public final void addChild(String string) {
        this.addChild2(this.doc.createElement(string));
    }

    public final void addChild(Node node) {
        this.addChild2(this.doc.importNode(node, true));
    }

    private void addChild2(Node node) {
        if (this.finalized) {
            throw new IllegalStateException("Document is read only.");
        }
        this.currentNode.appendChild(node);
        this.parentNode = this.currentNode;
        this.currentNode = node;
    }

    public final void addText(String string) {
        if (this.finalized) {
            throw new IllegalStateException("Document is read only");
        }
        Text text = this.doc.createTextNode(string);
        this.currentNode.appendChild(text);
    }

    public final void addText(int n) {
        this.addText(String.valueOf(n));
    }

    public final void addText(double d) {
        this.addText(String.valueOf(d));
    }

    public final void addChildAndText(String string, String string2) {
        this.addChild(string);
        this.addText(string2);
        this.returnToParent();
    }

    public final void addChildAndText(String string, int n) {
        this.addChild(string);
        this.addText(n);
        this.returnToParent();
    }

    public final void addChildAndText(String string, double d) {
        this.addChild(string);
        this.addText(d);
        this.returnToParent();
    }

    public final void setAttribute(String string, String string2) {
        if (this.finalized) {
            throw new IllegalStateException("Document is read only.");
        }
        ((Element)this.currentNode).setAttribute(string, string2);
    }

    public final void setAttribute(String string, int n) {
        this.setAttribute(string, String.valueOf(n));
    }

    public final void setAttribute(String string, double d) {
        this.setAttribute(string, String.valueOf(d));
    }

    public final void setAttributeNS(String string, String string2, String string3) {
        if (this.finalized) {
            throw new IllegalStateException("Document is read only.");
        }
        ((Element)this.currentNode).setAttributeNS(string, string2, string3);
    }

    public final void setAttributeNS(String string, String string2, int n) {
        this.setAttributeNS(string, string2, String.valueOf(n));
    }

    public final void setAttributeNS(String string, String string2, double d) {
        this.setAttributeNS(string, string2, String.valueOf(d));
    }

    public final void addSibling(String string) {
        this.addSibling2(this.doc.createElement(string));
    }

    public final void addSibling(Node node) {
        this.addSibling2(this.doc.importNode(node, true));
    }

    private void addSibling2(Node node) {
        if (this.finalized) {
            throw new IllegalStateException("Document is read only.");
        }
        this.parentNode.appendChild(node);
        this.currentNode = node;
    }

    public final void returnToParent() {
        this.currentNode = this.parentNode;
        this.parentNode = this.currentNode.getParentNode();
    }

    public final void changeCurrentNode(String string) {
        this.prevCurrentNode = this.currentNode;
        this.prevParentNode = this.parentNode;
        this.currentNode = this.selectSingleNode(string);
        this.parentNode = null;
    }

    public final void returnToPrevCurrentNode() {
        this.currentNode = this.prevCurrentNode;
        this.parentNode = this.prevParentNode;
        this.prevCurrentNode = null;
        this.prevParentNode = null;
    }

    public final void addChildOf(String string, String string2) {
        this.changeCurrentNode(string);
        this.addChild(string2);
    }

    protected final boolean isFinalized() {
        return this.finalized;
    }

    public void setTopTagAttribute(String string, String string2) {
        if (this.finalized) {
            throw new IllegalStateException("read only");
        }
        this.doc.getDocumentElement().setAttribute(string, string2);
    }

    public void setTopTagAttributeNS(String string, String string2, String string3) {
        if (this.finalized) {
            throw new IllegalStateException("read only");
        }
        this.doc.getDocumentElement().setAttributeNS(string, string2, string3);
    }

    public String getTopTagAttribute(String string) {
        return this.doc.getDocumentElement().getAttribute(string);
    }

    public String getTopTagAttributeNS(String string, String string2) {
        return this.doc.getDocumentElement().getAttributeNS(string, string2);
    }

    protected void checkFinalized() {
        if (!this.isFinalized()) {
            throw new IllegalStateException("Document has not been finalized.");
        }
    }

    final void checkElementAddition(boolean bl, String string) {
        if (!bl) {
            throw new IllegalStateException(string);
        }
    }

    final void checkElementAddition(boolean bl) {
        this.checkElementAddition(bl, "Tried to add an invalid element.");
    }

    protected void analyze() throws IOException {
    }

    static {
        catalogFileName = null;
        linkmanager = new NodeLinkManager();
        try {
            CLASS_TABLE = new HashMap<String, Class>();
            DTD_PUBLIC_ID_TABLE = new HashMap<String, String>();
            DTD_SYSTEM_ID_TABLE = new HashMap<String, String>();
            CMXFileWrapper.addClassTable("config", "jp.crestmuse.cmx.filewrappers.ConfigXMLWrapper");
            CMXFileWrapper.addDocumentTypeTable("config", "-//CrestMuse//DTD CrestMuseXML 0.40 ConfigXML//EN", "http://www.crestmuse.jp/cmx/dtds/config.dtd");
            CMXFileWrapper.addClassTable("score-partwise", "jp.crestmuse.cmx.filewrappers.MusicXMLWrapper");
            CMXFileWrapper.addDocumentTypeTable("score-partwise", "-//Recordare//DTD MusicXML 1.1 Partwise//EN", "http://www.musicxml.org/dtds/partwise.dtd");
            CMXFileWrapper.addClassTable("MIDIFile", "jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper");
            CMXFileWrapper.addDocumentTypeTable("MIDIFile", "-//Recordare//DTD MusicXML 1.1 MIDI//EN", "http://www.musicxml.org/dtds/midixml.dtd");
            CMXFileWrapper.addClassTable("scc", "jp.crestmuse.cmx.filewrappers.SCCXMLWrapper");
            CMXFileWrapper.addDocumentTypeTable("scc", "-//CrestMuse//DTD CrestMuseXML 0.30 SCCXML//EN", "http://www.crestmuse.jp/cmx/dtds/sccxml.dtd");
            CMXFileWrapper.addClassTable("deviation", "jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper");
            CMXFileWrapper.addDocumentTypeTable("deviation", "-//CrestMuse//DTD CrestMuseXML 0.30 DeviationInstanceXML//EN", "http://www.crestmuse.jp/cmx/dtds/deviation.dtd");
            CMXFileWrapper.addClassTable("riff-wave", "jp.crestmuse.cmx.amusaj.filewrappers.WAVXMLWrapper");
            CMXFileWrapper.addDocumentTypeTable("riff-wave", "-//CrestMuse//DTD CrestMuseXML 0.30 WAVXML//EN", "http://www.crestmuse.jp/cmx/dtds/wavxml.dtd");
            CMXFileWrapper.addClassTable("spd", "jp.crestmuse.cmx.amusaj.filewrappers.SPDXMLWrapper");
            CMXFileWrapper.addDocumentTypeTable("spd", "-//CrestMuse//DTD CrestMuseXML 0.40 SPDXML//EN", "http://www.crestmuse.jp/cmx/dtds/spdxml.dtd");
            CMXFileWrapper.addClassTable("fpd", "jp.crestmuse.cmx.amusaj.filewrappers.FPDXMLWrapper");
            CMXFileWrapper.addDocumentTypeTable("fpd", "-//CrestMuse//DTD CrestMuseXML 0.40 FPDXML//EN", "http://www.crestmuse.jp/cmx/dtds/fpdxml.dtd");
            CMXFileWrapper.addClassTable("tbd", "jp.crestmuse.cmx.amusaj.filewrappers.TBDXMLWrapper");
            CMXFileWrapper.addDocumentTypeTable("tbd", "-//CrestMuse//DTD CrestMuseXML 0.40 TBDXML//EN", "http://www.crestmuse.jp/cmx/dtds/tbdxml.dtd");
            CMXFileWrapper.addClassTable("igram", "jp.crestmuse.cmx.amusaj.filewrappers.IGRAMXMLWrapper");
            CMXFileWrapper.addDocumentTypeTable("igram", "-//CrestMuse//DTD CrestMuseXML 0.40 IGRAMXML//EN", "http://www.crestmuse.jp/cmx/dtds/igramxml.dtd");
            CMXFileWrapper.addClassTable("Mpeg7", "jp.crestmuse.cmx.amusaj.filewrappers.MPEG7Wrapper");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExternalLibraryException(classNotFoundException.toString());
        }
    }
}

