/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.List;
import java.util.Map;
import jp.crestmuse.cmx.amusaj.filewrappers.AudioDataCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.MutableDoubleArrayTimeSeries;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.ProducerConsumerCompatible;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.ConfigXMLWrapper;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowSlider
implements ProducerConsumerCompatible<Object, DoubleArray> {
    private Map<String, Object> params = null;
    private int winsize = 0;
    private double shift = Double.NaN;
    private int shift_;
    private int chTarget = 0;
    private boolean paramSet = false;
    private double[] buff;
    private int channels;
    private int fs;
    private DoubleArray wavM = null;
    private DoubleArray wavL = null;
    private DoubleArray wavR = null;
    private boolean isStereo;
    private static final DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private int t = 0;

    @Override
    public void setParams(Map<String, Object> map) {
        this.params = map;
        this.setParams();
    }

    private void setParams() {
        ConfigXMLWrapper configXMLWrapper = CMXCommand.getConfigXMLWrapper();
        if (this.params != null && this.params.containsKey("WINDOW_SIZE")) {
            this.winsize = (Integer)this.params.get("WINDOW_SIZE");
        } else {
            this.winsize = configXMLWrapper.getParamInt("param", "fft", "WINDOW_SIZE");
            this.params.put("WINDOW_SIZE", this.winsize);
        }
        if (this.params != null && this.params.containsKey("SHIFT")) {
            this.shift = (Double)this.params.get("SHIFT");
        } else {
            this.shift = configXMLWrapper.getParamDouble("param", "fft", "SHIFT");
            if (this.params != null) {
                this.params.put("SHIFT", this.shift);
            }
        }
        if (this.params != null && this.params.containsKey("TARGET_CHANNEL")) {
            this.chTarget = (Integer)this.params.get("TARGET_CHANNEL");
        } else {
            this.chTarget = 0;
            if (this.params != null) {
                this.params.put("TARGET_CHANNEL", 0);
            }
        }
        this.paramSet = true;
    }

    public void setInputData(AudioDataCompatible audioDataCompatible) {
        if (!this.paramSet) {
            this.setParams();
        }
        this.channels = audioDataCompatible.channels();
        if (this.params != null) {
            this.params.put("CHANNELS", this.channels);
        }
        this.fs = audioDataCompatible.sampleRate();
        if (this.params != null) {
            this.params.put("SAMPLE_RATE", this.fs);
        }
        if (this.shift < 1.0) {
            this.shift *= (double)this.fs;
        }
        this.shift_ = (int)this.shift;
        DoubleArray[] doubleArrayArray = audioDataCompatible.getDoubleArrayWaveform();
        if (this.chTarget == 0 && this.channels == 2) {
            this.wavM = Operations.add(doubleArrayArray[0], doubleArrayArray[1]);
            Operations.divX(this.wavM, 2.0);
            this.wavL = doubleArrayArray[0];
            this.wavR = doubleArrayArray[1];
            this.isStereo = true;
        } else if (this.chTarget == -1 && this.channels == 2) {
            this.wavM = Operations.add(doubleArrayArray[0], doubleArrayArray[1]);
            Operations.divX(this.wavM, 2.0);
            this.wavL = null;
            this.wavR = null;
            this.isStereo = false;
        } else {
            this.wavM = doubleArrayArray[this.chTarget];
            this.wavL = null;
            this.wavR = null;
            this.isStereo = false;
        }
        this.t = 0;
    }

    public boolean isStereo() {
        return this.isStereo;
    }

    @Override
    public int getInputChannels() {
        return 0;
    }

    @Override
    public int getOutputChannels() {
        return this.isStereo ? 3 : 1;
    }

    @Override
    public TimeSeriesCompatible createOutputInstance(int n, int n2) {
        return new MutableDoubleArrayTimeSeries(n, n2);
    }

    public int getAvailableFrames() {
        return Math.max(0, 1 + (int)Math.floor((double)(this.wavM.length() - this.winsize) / (double)this.shift_));
    }

    public int getTimeUnit() {
        return 1000 * this.shift_ / this.fs;
    }

    @Override
    public void execute(List<QueueReader<Object>> list, List<TimeSeriesCompatible<DoubleArray>> list2) throws InterruptedException {
        list2.get(0).add(this.wavM.subarrayX(this.t, this.t + this.winsize));
        if (this.isStereo) {
            list2.get(1).add(this.wavL.subarrayX(this.t, this.t + this.winsize));
            list2.get(2).add(this.wavR.subarrayX(this.t, this.t + this.winsize));
        }
        this.t += this.shift_;
    }
}

