/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.commands.AbstractWAVAnalyzer;
import jp.crestmuse.cmx.amusaj.filewrappers.AudioDataCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.F0PDFCalculatorModule;
import jp.crestmuse.cmx.amusaj.sp.PeakExtractor;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.STFT;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import org.xml.sax.SAXException;

public class WAV2FPD
extends AbstractWAVAnalyzer {
    private double nnFrom = Double.NaN;
    private double nnThru = Double.NaN;
    private double step = Double.NaN;
    private boolean paramSet = false;

    protected boolean setOptionsLocal(String string, String string2) {
        if (super.setOptionsLocal(string, string2)) {
            return true;
        }
        if (string.equals("-from") || string.equals("-f")) {
            this.params.put("NOTENUMBER_FROM", Double.valueOf(string2));
            return true;
        }
        if (string.equals("-thru") || string.equals("-t")) {
            this.params.put("NOTENUMBER_THRU", Double.valueOf(string2));
            return true;
        }
        if (string.equals("-step")) {
            this.params.put("STEP", Double.valueOf(string2));
            return true;
        }
        return false;
    }

    protected void analyzeWaveform(AudioDataCompatible audioDataCompatible, WindowSlider windowSlider, SPExecutor sPExecutor) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        sPExecutor.addSPModule(windowSlider);
        STFT sTFT = new STFT();
        sTFT.setStereo(windowSlider.isStereo());
        sPExecutor.addSPModule(sTFT);
        PeakExtractor peakExtractor = new PeakExtractor();
        sPExecutor.addSPModule(peakExtractor);
        int n = windowSlider.getOutputChannels();
        for (int i = 0; i < n; ++i) {
            sPExecutor.connect(windowSlider, i, sTFT, i);
            sPExecutor.connect(sTFT, i, peakExtractor, i);
        }
        F0PDFCalculatorModule f0PDFCalculatorModule = new F0PDFCalculatorModule();
        sPExecutor.addSPModule(f0PDFCalculatorModule);
        sPExecutor.connect(peakExtractor, 0, f0PDFCalculatorModule, 0);
        try {
            sPExecutor.start();
            this.prepareOutputData("fpd");
            TimeSeriesCompatible timeSeriesCompatible = sPExecutor.getResult(f0PDFCalculatorModule).get(0);
            this.addOutputData(timeSeriesCompatible);
        }
        catch (InterruptedException interruptedException) {
            this.showErrorMessage(interruptedException);
        }
    }

    public static void main(String[] stringArray) {
        WAV2FPD wAV2FPD = new WAV2FPD();
        try {
            wAV2FPD.start(stringArray);
        }
        catch (Exception exception) {
            wAV2FPD.showErrorMessage(exception);
            System.exit(1);
        }
    }
}

