/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.commands;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSet;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaXMLWrapper;
import jp.crestmuse.cmx.amusaj.filewrappers.AudioDataCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.WAVWrapper;
import jp.crestmuse.cmx.amusaj.sp.SPExecutor;
import jp.crestmuse.cmx.amusaj.sp.WindowSlider;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.FileWrapperCompatible;
import org.xml.sax.SAXException;

public abstract class AbstractWAVAnalyzer
extends CMXCommand {
    protected Map<String, Object> params = new HashMap<String, Object>();
    private AmusaDataSet dataset = null;

    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-winsize")) {
            this.params.put("WINDOW_SIZE", Integer.valueOf(string2));
            return true;
        }
        if (string.equals("-wintype")) {
            this.params.put("WINDOW_TYPE", Integer.valueOf(string2));
            return true;
        }
        if (string.equals("-shift")) {
            this.params.put("SHIFT", Double.valueOf(string2));
            return true;
        }
        if (string.equals("-ch")) {
            if (string2.equals("mix")) {
                this.params.put("TARGET_CHANNEL", -1);
            } else {
                this.params.put("TARGET_CHANNEL", Integer.valueOf(string2));
            }
            return true;
        }
        return false;
    }

    protected FileWrapperCompatible readInputData(String string) throws IOException {
        return WAVWrapper.readfile(string);
    }

    protected void run() throws IOException, ParserConfigurationException, TransformerException, SAXException {
        WAVWrapper wAVWrapper = (WAVWrapper)this.indata();
        WindowSlider windowSlider = new WindowSlider();
        windowSlider.setParams(this.params);
        windowSlider.setInputData(wAVWrapper);
        int n = windowSlider.getAvailableFrames();
        int n2 = windowSlider.getTimeUnit();
        SPExecutor sPExecutor = new SPExecutor(this.params, n, n2);
        this.analyzeWaveform(wAVWrapper, windowSlider, sPExecutor);
        if (this.dataset != null) {
            this.dataset.setHeaders(this.params);
            this.dataset.addElementsToWrapper();
        }
    }

    protected void prepareOutputData(String string) throws IOException, ParserConfigurationException, TransformerException, SAXException {
        this.newOutputData(string);
        this.dataset = ((AmusaXMLWrapper)this.outdata()).createDataSet();
    }

    protected void addOutputData(AmusaDataCompatible amusaDataCompatible) {
        this.dataset.add(amusaDataCompatible);
    }

    protected abstract void analyzeWaveform(AudioDataCompatible var1, WindowSlider var2, SPExecutor var3) throws IOException, ParserConfigurationException, TransformerException, SAXException;
}

