/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.sound;

import javax.sound.midi.MidiMessage;
import jp.crestmuse.cmx.gui.sound.SoundUtility;

public class NoteEvent {
    private String messageType;
    private int noteNum;
    private double beatOnset;
    private int velocity;
    private MidiMessage msg;
    private double beat;
    private double length;
    private long onset;
    private int measure;

    double getBeat() {
        return this.beat;
    }

    int getMeasure() {
        return this.measure;
    }

    NoteEvent(String string, int n, double d, int n2, int n3, double d2, int n4) {
        this.measure = n;
        this.beat = SoundUtility.castDouble(d);
        this.setNoteNum(n2);
        this.beatOnset = SoundUtility.castDouble((double)(n * n4) + d);
        this.setLength(d2);
        this.setVelocity(n3);
        this.setOnset(-1000L);
        this.setMessageType(string);
        System.out.println(this);
    }

    public final double getBeatOnset() {
        return this.beatOnset;
    }

    public final String getMessageType() {
        return this.messageType;
    }

    public final MidiMessage getMidiMessage() {
        return this.msg;
    }

    final int getNoteNum() {
        return this.noteNum;
    }

    public final int getVelocity() {
        return this.velocity;
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    public void setMidiMessge(MidiMessage midiMessage) {
        this.msg = midiMessage;
    }

    public void setNoteNum(int n) {
        this.noteNum = n;
    }

    public void setVelocity(int n) {
        this.velocity = n;
    }

    public String toString() {
        String string = this.getOnset() + " note " + this.getNoteNum() + ": " + this.getMessageType() + " v" + this.velocity + ", beatOnset " + this.getBeatOnset() + ", measure " + this.measure + ", beat " + this.beat + ", length " + this.getLength();
        return string;
    }

    double getLength() {
        return this.length;
    }

    private void setLength(double d) {
        this.length = d;
    }

    void setOnset(long l) {
        this.onset = l;
    }

    long getOnset() {
        return this.onset;
    }
}

