/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import jp.crestmuse.cmx.gui.PianoRollPanel;
import jp.crestmuse.cmx.misc.NoteCompatible;
import jp.crestmuse.cmx.misc.SimpleNoteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GraphicExpressionDataSet {
    private HashMap<NoteExpressionRectangle, NoteCompatible> axisToNoteMap = new HashMap();
    private HashMap<NoteCompatible, NoteExpressionRectangle> noteToAxisMap = new HashMap();
    private int musicLength;

    GraphicExpressionDataSet() {
    }

    final HashMap<NoteExpressionRectangle, NoteCompatible> getAxisToNoteMap() {
        return this.axisToNoteMap;
    }

    int getMusicLength() {
        return this.musicLength;
    }

    final HashMap<NoteCompatible, NoteExpressionRectangle> getNoteToAxisMap() {
        return this.noteToAxisMap;
    }

    NoteExpressionRectangle getNoteToAxisMap(NoteCompatible noteCompatible) {
        return this.noteToAxisMap.get(noteCompatible);
    }

    void setNotePositions(List<SimpleNoteList> list, int n) {
        this.noteToAxisMap.clear();
        this.axisToNoteMap.clear();
        this.musicLength = 0;
        for (SimpleNoteList simpleNoteList : list) {
            for (NoteCompatible noteCompatible : simpleNoteList) {
                int n2 = 7 * PianoRollPanel.getPitch(noteCompatible.notenum());
                int n3 = PianoRollPanel.getWidthOfNote((double)noteCompatible.onset(n) / (double)n);
                NoteExpressionRectangle noteExpressionRectangle = new NoteExpressionRectangle(n3, n2);
                noteExpressionRectangle.setScoreRectangle(new Rectangle(n3, n2, PianoRollPanel.getWidthOfNote((double)noteCompatible.duration(n) / (double)n), 7));
                int n4 = PianoRollPanel.getWidthOfNote((double)simpleNoteList.lastOffset() / (double)n);
                if (n4 > this.musicLength) {
                    this.musicLength = n4;
                }
                this.noteToAxisMap.put(noteCompatible, noteExpressionRectangle);
                this.axisToNoteMap.put(noteExpressionRectangle, noteCompatible);
            }
        }
    }

    class NoteExpressionRectangle {
        private int onset;
        private int yposition;
        private Rectangle score;
        private Rectangle perform;
        private Rectangle ioi;

        NoteExpressionRectangle(int n, int n2) {
            this.setOnset(n);
            this.setYposition(n2);
        }

        Rectangle getIOIRectangle() {
            return this.ioi;
        }

        int getOnset() {
            return this.onset;
        }

        Rectangle getPerformanceRectangle() {
            return this.perform;
        }

        Rectangle getScoreRectangle() {
            return this.score;
        }

        int getYposition() {
            return this.yposition;
        }

        void setIOIRectangle(Rectangle rectangle) {
            this.ioi = rectangle;
        }

        void setOnset(int n) {
            this.onset = n;
        }

        void setPerformanceRectangle(Rectangle rectangle) {
            this.perform = rectangle;
        }

        void setScoreRectangle(Rectangle rectangle) {
            this.score = rectangle;
        }

        void setYposition(int n) {
            this.yposition = n;
        }
    }
}

