<?php
/**
*
* cache driver for memcache
*
* PHP version 5
*
* @package    config_providers
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/
class Charcoal_MemcacheCacheDriver extends Charcoal_CharcoalObject implements Charcoal_ICacheDriver
{
	private $_memcache;
	private $_host;
	private $_port;
	private $_weight;
	private $_default_duration;

	/*
	 *	Construct object
	 */
	public function __construct()
	{
		parent::__construct();

		$this->_memcache = new Memcache();
	}

	/*
	 * Configure component
	 *
	 * @param Charcoal_Config $config   configuration data
	 */
	public function configure( Charcoal_Config $config )
	{
		parent::configure( $config );

		$this->_host              = $config->getString( s('host'), s('localhost') );
		$this->_port              = $config->getInteger( s('port'), i(11211) );
		$this->_weight            = $config->getInteger( s('weight'), i(100) );
		$this->_default_duration  = $config->getInteger( s('default_duration'), i(0) );

		log_debug( "system, debug, cache", "cache", "host=[{$this->_host}]" );
		log_debug( "system, debug, cache", "cache", "port=[{$this->_port}]" );
		log_debug( "system, debug, cache", "cache", "weight=[{$this->_weight}]" );
		log_debug( "system, debug, cache", "cache", "default_duration=[{$this->_default_duration}]" );

		$this->_memcache->addServer( us($this->_host), ui($this->_port), TRUE, ui($this->_weight) );

		log_info( "system, debug, cache", "cache", "server added." );
	}

	/**
	 * Get non-typed data which is associated with a string key
	 */
	public function get( Charcoal_String $key )
	{
		$key = us($key);

		$value = $this->_memcache->get( $key );

		$value = unserialize($value);
		return $value;
	}

	/**
	 * Save a value to cache
	 */
	public function set( Charcoal_String $key, Charcoal_Object $value, Charcoal_Integer $duration = NULL )
	{
		$key = us($key);
		$duration = $duration ? ui($duration) : ui($this->_default_duration);

		$value = serialize($value);

		$res = $this->_memcache->set( $key, $value );
	}

	/**
	 * Delete a cache data
	 */
	public function delete( Charcoal_String $key )
	{
		$file = new Charcoal_File( $key, $this->_cache_root_dir );

		$this->_memcache->delete( us($key) );
	}
}
return __FILE__;
