<?php
/**
* 設定に関するユーティリティクラス
*
* PHP version 5
*
* @package    core
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_ConfigUtil
{
	static $macro_defs;

	/*
	 * マクロ展開
	 */
	public static function processMacro( Charcoal_String $value )
	{
		// 展開キーワード
		if ( self::$macro_defs === NULL ){
			self::$macro_defs = array(

					'%CONFIG_DIR%'       => Charcoal_ResourceLocator::getApplicationPath( s('config') ),
					'%COMPONENTS_DIR%'   => Charcoal_ResourceLocator::getApplicationPath( s('components') ),
					'%LOGS_DIR%'         => Charcoal_ResourceLocator::getApplicationPath( s('logs') ),
					'%TEMPLATES_DIR%'    => Charcoal_ResourceLocator::getApplicationPath( s('templates') ),
					'%APPLICATION_DIR%'  => CHARCOAL_WEBAPP_DIR . '/' . CHARCOAL_PROJECT . '/apps/' . CHARCOAL_APPLICATION,
					'%PROJECT_DIR%'      => CHARCOAL_WEBAPP_DIR . '/' . CHARCOAL_PROJECT,
					'%WEBAPP_DIR%'       => CHARCOAL_WEBAPP_DIR,
					'%CHARCOAL_HOME%'    => CHARCOAL_HOME,
					'%BASE_DIR%'         => CHARCOAL_BASE_DIR,
					'%APPLICATION%'      => CHARCOAL_APPLICATION,

				);
		}

		// 展開
		$value = $value->getValue();
		if ( strpos($value,'%') !== FALSE ){
			foreach( self::$macro_defs as $macro_key => $macro_value ){
				if ( strpos($value,$macro_key) !== FALSE ){
					$value = str_replace( $macro_key, $macro_value, $value );
				}
			}
		}

		return s($value);
	}
}

return __FILE__;