<?php
/**
* 日付値クラス
*
* PHP version 5
*
* @package    base
* @author     CharcoalPHP Development Team
* @copyright  2008 - 2013 CharcoalPHP Development Team
*/

class Charcoal_DateWithTime extends Charcoal_Object
{
	private $_year;
	private $_month;
	private $_day;
	private $_hour;
	private $_minute;
	private $_second;

	/*
	 *	コンストラクタ
	 */
	public function __construct( Charcoal_Integer $year, Charcoal_Integer $month, Charcoal_Integer $day, Charcoal_Integer $hour, Charcoal_Integer $minute, Charcoal_Integer $second )
	{
		parent::__construct();

		$this->_year   = ui($year);
		$this->_month  = ui($month);
		$this->_day    = ui($day);
		$this->_hour   = ui($hour);
		$this->_minute = ui($minute);
		$this->_second = ui($second);
	}

	/*
	 *	文字列から生成
	 */
	public static function parse( Charcoal_String $datetime_string )
	{
		$datetime_string = us($datetime_string);

		$timestamp = strtotime( $datetime_string );

		if ( $timestamp === FALSE || $timestamp === -1 ){
			_throw ( new DateWithTimeFormatException( $datetime_string ) );
		}

		return self::fromTimestamp( i($timestamp) );
	}

	/*
	 *	UNIXタイムスタンプから生成
	 */
	public static function fromTimestamp( Charcoal_Integer $timestamp )
	{
		$timestamp = ui($timestamp);

		$y = i(date( 'Y', $timestamp ));
		$m = i(date( 'n', $timestamp ));
		$d = i(date( 'j', $timestamp ));
		$h = i(date( 'H', $timestamp ));
		$i = i(date( 'i', $timestamp ));
		$s = i(date( 's', $timestamp ));

		return new DateWithTime( $y, $m, $d, $h, $i, $s );
	}

	/*
	 *	年を取得
	 */
	public function getYear()
	{
		return $this->_year;
	}

	/*
	 *	月を取得
	 */
	public function getMonth()
	{
		return $this->_month;
	}

	/*
	 *	日を取得
	 */
	public function getDay()
	{
		return $this->_day;
	}

	/*
	 *	時を取得
	 */
	public function getHour()
	{
		return $this->_hour;
	}

	/*
	 *	分を取得
	 */
	public function getMinute()
	{
		return $this->_minute;
	}

	/*
	 *	秒を取得
	 */
	public function getSecond()
	{
		return $this->_second;
	}

	/*
	 *	書式化
	 */
	public function format( Charcoal_String $format_pattern )
	{
		$format_pattern = $format_pattern->getValue();

		$date = System::makeTime( $this->_year, $this->_month, $this->_day, $this->_hour, $this->_minute, $this->_second );

		return date( $format_pattern, $date );
	}

	/*
	 *  String expression of this object
	 *
	 * @return string
	 */
	public function toString()
	{
		return $this->_year . '/' . $this->_month . '/' . $this->_day;
	}
}
return __FILE__;
