/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.format;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.IllegalFieldValueException;
import java.util.Arrays;
import java.util.Locale;

public class DateTimeParserBucket {
    private final Chronology iChrono;
    private final long iMillis;
    private DateTimeZone iZone;
    private Integer iOffset;
    private Locale iLocale;
    private Integer iPivotYear;
    private int iDefaultYear;
    private SavedField[] iSavedFields = new SavedField[8];
    private int iSavedFieldsCount;
    private boolean iSavedFieldsShared;
    private Object iSavedState;

    @Deprecated
    public DateTimeParserBucket(long instantLocal, Chronology chrono, Locale locale) {
        this(instantLocal, chrono, locale, null, 2000);
    }

    @Deprecated
    public DateTimeParserBucket(long instantLocal, Chronology chrono, Locale locale, Integer pivotYear) {
        this(instantLocal, chrono, locale, pivotYear, 2000);
    }

    public DateTimeParserBucket(long instantLocal, Chronology chrono, Locale locale, Integer pivotYear, int defaultYear) {
        chrono = DateTimeUtils.getChronology(chrono);
        this.iMillis = instantLocal;
        this.iZone = chrono.getZone();
        this.iChrono = chrono.withUTC();
        this.iLocale = locale == null ? Locale.getDefault() : locale;
        this.iPivotYear = pivotYear;
        this.iDefaultYear = defaultYear;
    }

    public Chronology getChronology() {
        return this.iChrono;
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public DateTimeZone getZone() {
        return this.iZone;
    }

    public void setZone(DateTimeZone zone) {
        this.iSavedState = null;
        this.iZone = zone;
    }

    @Deprecated
    public int getOffset() {
        return this.iOffset != null ? this.iOffset : 0;
    }

    public Integer getOffsetInteger() {
        return this.iOffset;
    }

    @Deprecated
    public void setOffset(int offset) {
        this.iSavedState = null;
        this.iOffset = offset;
    }

    public void setOffset(Integer offset) {
        this.iSavedState = null;
        this.iOffset = offset;
    }

    public Integer getPivotYear() {
        return this.iPivotYear;
    }

    public void setPivotYear(Integer pivotYear) {
        this.iPivotYear = pivotYear;
    }

    public void saveField(DateTimeField field, int value) {
        this.saveField(new SavedField(field, value));
    }

    public void saveField(DateTimeFieldType fieldType, int value) {
        this.saveField(new SavedField(fieldType.getField(this.iChrono), value));
    }

    public void saveField(DateTimeFieldType fieldType, String text, Locale locale) {
        this.saveField(new SavedField(fieldType.getField(this.iChrono), text, locale));
    }

    private void saveField(SavedField field) {
        int savedFieldsCount = this.iSavedFieldsCount;
        SavedField[] savedFields = this.iSavedFields;
        if (savedFieldsCount == savedFields.length || this.iSavedFieldsShared) {
            SavedField[] newArray = new SavedField[savedFieldsCount == savedFields.length ? savedFieldsCount * 2 : savedFields.length];
            System.arraycopy(savedFields, 0, newArray, 0, savedFieldsCount);
            savedFields = newArray;
            this.iSavedFields = newArray;
            this.iSavedFieldsShared = false;
        }
        this.iSavedState = null;
        savedFields[savedFieldsCount] = field;
        this.iSavedFieldsCount = savedFieldsCount + 1;
    }

    public Object saveState() {
        if (this.iSavedState == null) {
            this.iSavedState = new SavedState();
        }
        return this.iSavedState;
    }

    public boolean restoreState(Object savedState) {
        if (savedState instanceof SavedState && ((SavedState)savedState).restoreState(this)) {
            this.iSavedState = savedState;
            return true;
        }
        return false;
    }

    public long computeMillis() {
        return this.computeMillis(false, null);
    }

    public long computeMillis(boolean resetFields) {
        return this.computeMillis(resetFields, null);
    }

    public long computeMillis(boolean resetFields, String text) {
        int offset;
        SavedField[] savedFields = this.iSavedFields;
        int count = this.iSavedFieldsCount;
        if (this.iSavedFieldsShared) {
            savedFields = (SavedField[])this.iSavedFields.clone();
            this.iSavedFields = savedFields;
            this.iSavedFieldsShared = false;
        }
        DateTimeParserBucket.sort(savedFields, count);
        if (count > 0) {
            DurationField months = DurationFieldType.months().getField(this.iChrono);
            DurationField days = DurationFieldType.days().getField(this.iChrono);
            DurationField first = savedFields[0].iField.getDurationField();
            if (DateTimeParserBucket.compareReverse(first, months) >= 0 && DateTimeParserBucket.compareReverse(first, days) <= 0) {
                this.saveField(DateTimeFieldType.year(), this.iDefaultYear);
                return this.computeMillis(resetFields, text);
            }
        }
        long millis = this.iMillis;
        try {
            int i;
            for (i = 0; i < count; ++i) {
                millis = savedFields[i].set(millis, resetFields);
            }
            if (resetFields) {
                for (i = 0; i < count; ++i) {
                    millis = savedFields[i].set(millis, i == count - 1);
                }
            }
        }
        catch (IllegalFieldValueException e) {
            if (text != null) {
                e.prependMessage("Cannot parse \"" + text + '\"');
            }
            throw e;
        }
        if (this.iOffset != null) {
            millis -= (long)this.iOffset.intValue();
        } else if (this.iZone != null && (offset = this.iZone.getOffsetFromLocal(millis)) != this.iZone.getOffset(millis -= (long)offset)) {
            String message = "Illegal instant due to time zone offset transition (" + this.iZone + ')';
            if (text != null) {
                message = "Cannot parse \"" + text + "\": " + message;
            }
            throw new IllegalArgumentException(message);
        }
        return millis;
    }

    private static void sort(SavedField[] array, int high) {
        if (high > 10) {
            Arrays.sort(array, 0, high);
        } else {
            for (int i = 0; i < high; ++i) {
                for (int j = i; j > 0 && array[j - 1].compareTo(array[j]) > 0; --j) {
                    SavedField t = array[j];
                    array[j] = array[j - 1];
                    array[j - 1] = t;
                }
            }
        }
    }

    static int compareReverse(DurationField a, DurationField b) {
        if (a == null || !a.isSupported()) {
            if (b == null || !b.isSupported()) {
                return 0;
            }
            return -1;
        }
        if (b == null || !b.isSupported()) {
            return 1;
        }
        return -a.compareTo(b);
    }

    static /* synthetic */ SavedField[] access$202(DateTimeParserBucket x0, SavedField[] x1) {
        x0.iSavedFields = x1;
        return x1;
    }

    static class SavedField
    implements Comparable<SavedField> {
        final DateTimeField iField;
        final int iValue;
        final String iText;
        final Locale iLocale;

        SavedField(DateTimeField field, int value) {
            this.iField = field;
            this.iValue = value;
            this.iText = null;
            this.iLocale = null;
        }

        SavedField(DateTimeField field, String text, Locale locale) {
            this.iField = field;
            this.iValue = 0;
            this.iText = text;
            this.iLocale = locale;
        }

        long set(long millis, boolean reset) {
            millis = this.iText == null ? this.iField.set(millis, this.iValue) : this.iField.set(millis, this.iText, this.iLocale);
            if (reset) {
                millis = this.iField.roundFloor(millis);
            }
            return millis;
        }

        @Override
        public int compareTo(SavedField obj) {
            DateTimeField other = obj.iField;
            int result = DateTimeParserBucket.compareReverse(this.iField.getRangeDurationField(), other.getRangeDurationField());
            if (result != 0) {
                return result;
            }
            return DateTimeParserBucket.compareReverse(this.iField.getDurationField(), other.getDurationField());
        }
    }

    class SavedState {
        final DateTimeZone iZone;
        final Integer iOffset;
        final SavedField[] iSavedFields;
        final int iSavedFieldsCount;

        SavedState() {
            this.iZone = DateTimeParserBucket.this.iZone;
            this.iOffset = DateTimeParserBucket.this.iOffset;
            this.iSavedFields = DateTimeParserBucket.this.iSavedFields;
            this.iSavedFieldsCount = DateTimeParserBucket.this.iSavedFieldsCount;
        }

        boolean restoreState(DateTimeParserBucket enclosing) {
            if (enclosing != DateTimeParserBucket.this) {
                return false;
            }
            enclosing.iZone = this.iZone;
            enclosing.iOffset = this.iOffset;
            DateTimeParserBucket.access$202(enclosing, this.iSavedFields);
            if (this.iSavedFieldsCount < enclosing.iSavedFieldsCount) {
                enclosing.iSavedFieldsShared = true;
            }
            enclosing.iSavedFieldsCount = this.iSavedFieldsCount;
            return true;
        }
    }
}

