/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.chrono.AssembledChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.BasicGJChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.ZonedChronology;
import java.util.HashMap;
import java.util.Map;

public final class GregorianChronology
extends BasicGJChronology {
    private static final long serialVersionUID = -861407383323710522L;
    private static final long MILLIS_PER_YEAR = 31556952000L;
    private static final long MILLIS_PER_MONTH = 2629746000L;
    private static final int DAYS_0000_TO_1970 = 719527;
    private static final int MIN_YEAR = -292275054;
    private static final int MAX_YEAR = 292278993;
    private static final GregorianChronology INSTANCE_UTC;
    private static final Map<DateTimeZone, GregorianChronology[]> cCache;

    public static GregorianChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static GregorianChronology getInstance() {
        return GregorianChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static GregorianChronology getInstance(DateTimeZone zone) {
        return GregorianChronology.getInstance(zone, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GregorianChronology getInstance(DateTimeZone zone, int minDaysInFirstWeek) {
        GregorianChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        Map<DateTimeZone, GregorianChronology[]> map = cCache;
        synchronized (map) {
            GregorianChronology[] chronos = cCache.get(zone);
            if (chronos == null) {
                chronos = new GregorianChronology[7];
                cCache.put(zone, chronos);
            }
            try {
                chrono = chronos[minDaysInFirstWeek - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid min days in first week: " + minDaysInFirstWeek);
            }
            if (chrono == null) {
                if (zone == DateTimeZone.UTC) {
                    chrono = new GregorianChronology(null, null, minDaysInFirstWeek);
                } else {
                    chrono = GregorianChronology.getInstance(DateTimeZone.UTC, minDaysInFirstWeek);
                    chrono = new GregorianChronology(ZonedChronology.getInstance(chrono, zone), null, minDaysInFirstWeek);
                }
                chronos[minDaysInFirstWeek - 1] = chrono;
            }
        }
        return chrono;
    }

    private GregorianChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        int minDays = this.getMinimumDaysInFirstWeek();
        minDays = minDays == 0 ? 4 : minDays;
        return base == null ? GregorianChronology.getInstance(DateTimeZone.UTC, minDays) : GregorianChronology.getInstance(base.getZone(), minDays);
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return GregorianChronology.getInstance(zone);
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
        }
    }

    @Override
    boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    @Override
    long calculateFirstDayOfYearMillis(int year) {
        int leapYears = year / 100;
        if (year < 0) {
            leapYears = (year + 3 >> 2) - leapYears + (leapYears + 3 >> 2) - 1;
        } else {
            leapYears = (year >> 2) - leapYears + (leapYears >> 2);
            if (this.isLeapYear(year)) {
                --leapYears;
            }
        }
        return ((long)year * 365L + (long)(leapYears - 719527)) * 86400000L;
    }

    @Override
    int getMinYear() {
        return -292275054;
    }

    @Override
    int getMaxYear() {
        return 292278993;
    }

    @Override
    long getAverageMillisPerYear() {
        return 31556952000L;
    }

    @Override
    long getAverageMillisPerYearDividedByTwo() {
        return 15778476000L;
    }

    @Override
    long getAverageMillisPerMonth() {
        return 2629746000L;
    }

    @Override
    long getApproxMillisAtEpochDividedByTwo() {
        return 31083597720000L;
    }

    static {
        cCache = new HashMap<DateTimeZone, GregorianChronology[]>();
        INSTANCE_UTC = GregorianChronology.getInstance(DateTimeZone.UTC);
    }
}

