/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import java.io.Serializable;

public final class GeoPt
implements Serializable,
Comparable<GeoPt> {
    public static final long serialVersionUID = 349808987517153697L;
    private float latitude;
    private float longitude;

    public GeoPt(float latitude, float longitude) {
        if (Math.abs(latitude) > 90.0f) {
            throw new IllegalArgumentException("Latitude must be between -90 and 90 (inclusive).");
        }
        if (Math.abs(longitude) > 180.0f) {
            throw new IllegalArgumentException("Longitude must be between -180 and 180.");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    private GeoPt() {
        this(0.0f, 0.0f);
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    @Override
    public int compareTo(GeoPt o) {
        int latResult = Float.valueOf(this.latitude).compareTo(Float.valueOf(o.latitude));
        if (latResult != 0) {
            return latResult;
        }
        return Float.valueOf(this.longitude).compareTo(Float.valueOf(o.longitude));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoPt geoPt = (GeoPt)o;
        if (Float.compare(geoPt.latitude, this.latitude) != 0) {
            return false;
        }
        return Float.compare(geoPt.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        int result = this.latitude != 0.0f ? Float.floatToIntBits(this.latitude) : 0;
        result = 31 * result + (this.longitude != 0.0f ? Float.floatToIntBits(this.longitude) : 0);
        return result;
    }

    public String toString() {
        return String.format("%f,%f", Float.valueOf(this.latitude), Float.valueOf(this.longitude));
    }
}

