/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.http;

import com.google.appengine.repackaged.com.google.api.client.http.BackOffPolicy;
import com.google.appengine.repackaged.com.google.api.client.http.ByteArrayContent;
import com.google.appengine.repackaged.com.google.api.client.http.GZipContent;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpContent;
import com.google.appengine.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.appengine.repackaged.com.google.api.client.http.HttpHeaders;
import com.google.appengine.repackaged.com.google.api.client.http.HttpMethod;
import com.google.appengine.repackaged.com.google.api.client.http.HttpParser;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponseException;
import com.google.appengine.repackaged.com.google.api.client.http.HttpStatusCodes;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.appengine.repackaged.com.google.api.client.http.LogContent;
import com.google.appengine.repackaged.com.google.api.client.http.LowLevelHttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.LowLevelHttpResponse;
import com.google.appengine.repackaged.com.google.api.client.util.ObjectParser;
import com.google.appengine.repackaged.com.google.api.client.util.StringUtils;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpRequest {
    public static final String VERSION = "1.12.0-beta-SNAPSHOT";
    public static final String USER_AGENT_SUFFIX = "Google-HTTP-Java-Client/1.12.0-beta-SNAPSHOT (gzip)";
    private static volatile boolean warnedDeprecatedSetAllowEmptyContent;
    private static volatile boolean warnedDeprecatedIsAllowEmptyContent;
    private HttpExecuteInterceptor interceptor;
    private HttpHeaders headers = new HttpHeaders();
    private HttpHeaders responseHeaders = new HttpHeaders();
    @Deprecated
    private boolean allowEmptyContent = true;
    private int numRetries = 10;
    private int contentLoggingLimit = 16384;
    private boolean loggingEnabled = true;
    private boolean curlLoggingEnabled = true;
    private HttpContent content;
    private final HttpTransport transport;
    private HttpMethod method;
    private GenericUrl url;
    private int connectTimeout = 20000;
    private int readTimeout = 20000;
    private HttpUnsuccessfulResponseHandler unsuccessfulResponseHandler;
    @Deprecated
    private final Map<String, HttpParser> contentTypeToParserMap = new HashMap<String, HttpParser>();
    private ObjectParser objectParser;
    private boolean enableGZipContent;
    private BackOffPolicy backOffPolicy;
    private boolean followRedirects = true;
    private boolean throwExceptionOnExecuteError = true;
    private boolean retryOnExecuteIOException = false;
    private boolean suppressUserAgentSuffix;

    HttpRequest(HttpTransport transport, HttpMethod method) {
        this.transport = transport;
        this.method = method;
    }

    public HttpTransport getTransport() {
        return this.transport;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpRequest setMethod(HttpMethod method) {
        this.method = Preconditions.checkNotNull(method);
        return this;
    }

    public GenericUrl getUrl() {
        return this.url;
    }

    public HttpRequest setUrl(GenericUrl url) {
        this.url = Preconditions.checkNotNull(url);
        return this;
    }

    public HttpContent getContent() {
        return this.content;
    }

    public HttpRequest setContent(HttpContent content) {
        this.content = content;
        return this;
    }

    public boolean getEnableGZipContent() {
        return this.enableGZipContent;
    }

    public HttpRequest setEnableGZipContent(boolean enableGZipContent) {
        this.enableGZipContent = enableGZipContent;
        return this;
    }

    public BackOffPolicy getBackOffPolicy() {
        return this.backOffPolicy;
    }

    public HttpRequest setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.backOffPolicy = backOffPolicy;
        return this;
    }

    public int getContentLoggingLimit() {
        return this.contentLoggingLimit;
    }

    public HttpRequest setContentLoggingLimit(int contentLoggingLimit) {
        Preconditions.checkArgument(contentLoggingLimit >= 0, "The content logging limit must be non-negative.");
        this.contentLoggingLimit = contentLoggingLimit;
        return this;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public HttpRequest setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
        return this;
    }

    public boolean isCurlLoggingEnabled() {
        return this.curlLoggingEnabled;
    }

    public HttpRequest setCurlLoggingEnabled(boolean curlLoggingEnabled) {
        this.curlLoggingEnabled = curlLoggingEnabled;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpRequest setConnectTimeout(int connectTimeout) {
        Preconditions.checkArgument(connectTimeout >= 0);
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpRequest setReadTimeout(int readTimeout) {
        Preconditions.checkArgument(readTimeout >= 0);
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpRequest setHeaders(HttpHeaders headers) {
        this.headers = Preconditions.checkNotNull(headers);
        return this;
    }

    public HttpHeaders getResponseHeaders() {
        return this.responseHeaders;
    }

    public HttpRequest setResponseHeaders(HttpHeaders responseHeaders) {
        this.responseHeaders = Preconditions.checkNotNull(responseHeaders);
        return this;
    }

    public HttpExecuteInterceptor getInterceptor() {
        return this.interceptor;
    }

    public HttpRequest setInterceptor(HttpExecuteInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public HttpUnsuccessfulResponseHandler getUnsuccessfulResponseHandler() {
        return this.unsuccessfulResponseHandler;
    }

    public HttpRequest setUnsuccessfulResponseHandler(HttpUnsuccessfulResponseHandler unsuccessfulResponseHandler) {
        this.unsuccessfulResponseHandler = unsuccessfulResponseHandler;
        return this;
    }

    @Deprecated
    public HttpRequest setAllowEmptyContent(boolean allowEmptyContent) {
        this.allowEmptyContent = allowEmptyContent;
        if (!warnedDeprecatedSetAllowEmptyContent) {
            HttpTransport.LOGGER.warning("setAllowEmptyContent is deprecated and will be removed in 1.12; use setEmptyContent instead (if needed)");
            warnedDeprecatedSetAllowEmptyContent = true;
        }
        return this;
    }

    @Deprecated
    public boolean isAllowEmptyContent() {
        if (!warnedDeprecatedIsAllowEmptyContent) {
            HttpTransport.LOGGER.warning("isAllowEmptyContent is deprecated and will be removed in 1.12");
            warnedDeprecatedIsAllowEmptyContent = true;
        }
        return this.allowEmptyContent;
    }

    public int getNumberOfRetries() {
        return this.numRetries;
    }

    public HttpRequest setNumberOfRetries(int numRetries) {
        Preconditions.checkArgument(numRetries >= 0);
        this.numRetries = numRetries;
        return this;
    }

    @Deprecated
    public void addParser(HttpParser parser) {
        String contentType = HttpRequest.normalizeMediaType(parser.getContentType());
        this.contentTypeToParserMap.put(contentType, parser);
    }

    public HttpRequest setParser(ObjectParser parser) {
        this.objectParser = parser;
        return this;
    }

    @Deprecated
    public final HttpParser getParser(String contentType) {
        contentType = HttpRequest.normalizeMediaType(contentType);
        return this.contentTypeToParserMap.get(contentType);
    }

    public final ObjectParser getParser() {
        return this.objectParser;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public HttpRequest setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public boolean getThrowExceptionOnExecuteError() {
        return this.throwExceptionOnExecuteError;
    }

    public HttpRequest setThrowExceptionOnExecuteError(boolean throwExceptionOnExecuteError) {
        this.throwExceptionOnExecuteError = throwExceptionOnExecuteError;
        return this;
    }

    public boolean getRetryOnExecuteIOException() {
        return this.retryOnExecuteIOException;
    }

    public HttpRequest setRetryOnExecuteIOException(boolean retryOnExecuteIOException) {
        this.retryOnExecuteIOException = retryOnExecuteIOException;
        return this;
    }

    public boolean getSuppressUserAgentSuffix() {
        return this.suppressUserAgentSuffix;
    }

    public HttpRequest setSuppressUserAgentSuffix(boolean suppressUserAgentSuffix) {
        this.suppressUserAgentSuffix = suppressUserAgentSuffix;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute() throws IOException {
        IOException executeException;
        boolean retrySupported = false;
        Preconditions.checkArgument(this.numRetries >= 0);
        int retriesRemaining = this.numRetries;
        if (this.backOffPolicy != null) {
            this.backOffPolicy.reset();
        }
        HttpResponse response = null;
        Preconditions.checkNotNull(this.method);
        Preconditions.checkNotNull(this.url);
        do {
            LowLevelHttpRequest lowLevelHttpRequest;
            if (response != null) {
                response.ignore();
            }
            response = null;
            executeException = null;
            if (this.interceptor != null) {
                this.interceptor.intercept(this);
            }
            String urlString = this.url.build();
            switch (this.method) {
                case DELETE: {
                    lowLevelHttpRequest = this.transport.buildDeleteRequest(urlString);
                    break;
                }
                default: {
                    lowLevelHttpRequest = this.transport.buildGetRequest(urlString);
                    break;
                }
                case HEAD: {
                    Preconditions.checkArgument(this.transport.supportsHead(), "HTTP transport doesn't support HEAD");
                    lowLevelHttpRequest = this.transport.buildHeadRequest(urlString);
                    break;
                }
                case PATCH: {
                    Preconditions.checkArgument(this.transport.supportsPatch(), "HTTP transport doesn't support PATCH");
                    lowLevelHttpRequest = this.transport.buildPatchRequest(urlString);
                    break;
                }
                case POST: {
                    lowLevelHttpRequest = this.transport.buildPostRequest(urlString);
                    break;
                }
                case PUT: {
                    lowLevelHttpRequest = this.transport.buildPutRequest(urlString);
                }
            }
            Logger logger = HttpTransport.LOGGER;
            boolean loggable = this.loggingEnabled && logger.isLoggable(Level.CONFIG);
            StringBuilder logbuf = null;
            StringBuilder curlbuf = null;
            if (loggable) {
                logbuf = new StringBuilder();
                logbuf.append("-------------- REQUEST  --------------").append(StringUtils.LINE_SEPARATOR);
                logbuf.append((Object)this.method).append(' ').append(urlString).append(StringUtils.LINE_SEPARATOR);
                if (this.curlLoggingEnabled) {
                    curlbuf = new StringBuilder("curl -v --compressed");
                    if (!this.method.equals((Object)HttpMethod.GET)) {
                        curlbuf.append(" -X ").append((Object)this.method);
                    }
                }
            }
            String originalUserAgent = this.headers.getUserAgent();
            if (!this.suppressUserAgentSuffix) {
                if (originalUserAgent == null) {
                    this.headers.setUserAgent(USER_AGENT_SUFFIX);
                } else {
                    this.headers.setUserAgent(originalUserAgent + " " + USER_AGENT_SUFFIX);
                }
            }
            HttpHeaders.serializeHeaders(this.headers, logbuf, curlbuf, logger, lowLevelHttpRequest);
            if (!this.suppressUserAgentSuffix) {
                this.headers.setUserAgent(originalUserAgent);
            }
            HttpContent content = this.content;
            if (!(this.allowEmptyContent || this.method != HttpMethod.PUT && this.method != HttpMethod.POST && this.method != HttpMethod.PATCH || content != null && content.getLength() != 0L)) {
                content = ByteArrayContent.fromString(null, " ");
            }
            if (content != null) {
                String contentEncoding = content.getEncoding();
                long contentLength = content.getLength();
                String contentType = content.getType();
                if (loggable) {
                    content = new LogContent(content, contentType, contentEncoding, contentLength, this.contentLoggingLimit);
                }
                String underlyingEncoding = content.getEncoding();
                if (this.enableGZipContent) {
                    content = new GZipContent(content, contentType);
                    contentEncoding = content.getEncoding();
                    contentLength = content.getLength();
                }
                if (loggable) {
                    String header;
                    if (contentType != null) {
                        header = "Content-Type: " + contentType;
                        logbuf.append(header).append(StringUtils.LINE_SEPARATOR);
                        if (curlbuf != null) {
                            curlbuf.append(" -H '" + header + "'");
                        }
                    }
                    if (underlyingEncoding != null) {
                        header = "Content-Encoding: " + underlyingEncoding;
                        logbuf.append(header).append(StringUtils.LINE_SEPARATOR);
                        if (curlbuf != null) {
                            curlbuf.append(" -H '" + header + "'");
                        }
                    }
                    if (contentLength >= 0L) {
                        header = "Content-Length: " + contentLength;
                        logbuf.append(header).append(StringUtils.LINE_SEPARATOR);
                    }
                }
                if (curlbuf != null) {
                    curlbuf.append(" -d '@-'");
                }
                lowLevelHttpRequest.setContent(content);
            }
            if (loggable) {
                logger.config(logbuf.toString());
                if (curlbuf != null) {
                    curlbuf.append(" -- ");
                    curlbuf.append(urlString);
                    if (content != null) {
                        curlbuf.append(" << $$$");
                    }
                    logger.config(curlbuf.toString());
                }
            }
            retrySupported = retriesRemaining > 0 && (content == null || content.retrySupported());
            lowLevelHttpRequest.setTimeout(this.connectTimeout, this.readTimeout);
            try {
                LowLevelHttpResponse lowLevelHttpResponse = lowLevelHttpRequest.execute();
                boolean responseConstructed = false;
                try {
                    response = new HttpResponse(this, lowLevelHttpResponse);
                    responseConstructed = true;
                }
                finally {
                    if (!responseConstructed) {
                        lowLevelHttpResponse.getContent().close();
                    }
                }
            }
            catch (IOException e) {
                if (!this.retryOnExecuteIOException) {
                    throw e;
                }
                executeException = e;
                logger.log(Level.WARNING, "exception thrown while executing request", e);
            }
            boolean responseProcessed = false;
            try {
                if (response != null && !response.isSuccessStatusCode()) {
                    boolean errorHandled = false;
                    boolean redirectRequest = false;
                    boolean backOffRetry = false;
                    if (this.unsuccessfulResponseHandler != null) {
                        errorHandled = this.unsuccessfulResponseHandler.handleResponse(this, response, retrySupported);
                    }
                    if (!errorHandled) {
                        long backOffTime;
                        if (this.handleRedirect(response.getStatusCode(), response.getHeaders())) {
                            redirectRequest = true;
                        } else if (retrySupported && this.backOffPolicy != null && this.backOffPolicy.isBackOffRequired(response.getStatusCode()) && (backOffTime = this.backOffPolicy.getNextBackOffMillis()) != -1L) {
                            this.sleep(backOffTime);
                            backOffRetry = true;
                        }
                    }
                    if (retrySupported &= errorHandled || redirectRequest || backOffRetry) {
                        response.ignore();
                    }
                } else {
                    retrySupported &= response == null;
                }
                --retriesRemaining;
                responseProcessed = true;
            }
            finally {
                if (response != null && !responseProcessed) {
                    response.disconnect();
                }
            }
        } while (retrySupported);
        if (response == null) {
            throw executeException;
        }
        if (this.throwExceptionOnExecuteError && !response.isSuccessStatusCode()) {
            try {
                throw new HttpResponseException(response);
            }
            catch (Throwable throwable) {
                response.disconnect();
                throw throwable;
            }
        }
        return response;
    }

    public boolean handleRedirect(int statusCode, HttpHeaders headers) {
        String redirectLocation = headers.getLocation();
        if (this.getFollowRedirects() && HttpStatusCodes.isRedirect(statusCode) && redirectLocation != null) {
            this.setUrl(new GenericUrl(redirectLocation));
            if (statusCode == 303) {
                this.setMethod(HttpMethod.GET);
            }
            return true;
        }
        return false;
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Deprecated
    public static String normalizeMediaType(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        int semicolon = mediaType.indexOf(59);
        return semicolon == -1 ? mediaType : mediaType.substring(0, semicolon);
    }
}

