/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.IoUtil;
import com.google.api.server.spi.response.InternalServerErrorException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class BackendService {
    private static final Logger logger = Logger.getLogger(BackendService.class.getName());
    public static final FileFilter INCLUDE_DOT_API_FILES = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".api");
        }
    };

    public List<String> getApiConfigs(ServletContext context) throws InternalServerErrorException {
        ArrayList<String> apiConfigs = new ArrayList<String>();
        File apiConfigDir = this.getApiConfigDir(context);
        logger.log(Level.INFO, "apiConfigDir={0}", apiConfigDir);
        for (File apiConfigFile : apiConfigDir.listFiles(INCLUDE_DOT_API_FILES)) {
            logger.log(Level.INFO, "apiConfigFile={0}", apiConfigFile);
            try {
                apiConfigs.add(this.readFile(apiConfigFile));
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "file not found", e);
                throw new InternalServerErrorException(e);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "I/O failed", e);
                throw new InternalServerErrorException(e);
            }
        }
        return apiConfigs;
    }

    File getApiConfigDir(ServletContext context) {
        return new File(context.getRealPath("WEB-INF"));
    }

    String readFile(File apiConfigFile) throws FileNotFoundException, IOException {
        return IoUtil.readFile(apiConfigFile);
    }
}

