/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import java.sql.DriverPropertyInfo;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum ConnectionProperty {
    USER("user", Documented.DOCUMENTED, null, "Database Username", new String[0]),
    PASSWORD("password", Documented.DOCUMENTED, null, "Database Password", new String[0]),
    INSTANCE("instance", Documented.DOCUMENTED, null, "Google SQL Service Instance name", new String[0]),
    CONNECT_TIMEOUT_SECONDS("connectTimeoutSeconds", Documented.DOCUMENTED, -1, "Connection timeout in seconds.", new String[0]),
    QUERY_TIMEOUT_SECONDS("queryTimeoutSeconds", Documented.DOCUMENTED, -1, "Query Timeout in seconds.", new String[0]),
    DATABASE("database", Documented.DOCUMENTED, null, "Default database to use.", new String[0]),
    SERVER("server", Documented.UNDOCUMENTED, null, "", new String[0]),
    GOOGLEAPI_PARAMS("googleApiParams", Documented.UNDOCUMENTED, null, "Extra parameters used by GoogleAPI.", new String[0]),
    HEADER_PROVIDER_CLASS_NAME("headerProviderClassName", Documented.UNDOCUMENTED, null, "Class to use to inject headers into RpcGoogleApi requests.", new String[0]),
    JDBC_COMPLIANT_TRUNCATION("jdbcCompliantTruncation", Documented.DOCUMENTED, Boolean.TRUE, "", new String[0]),
    OAUTH2_REFRESH_TOKEN("oauth2RefreshToken", Documented.DOCUMENTED, null, "OAuth2 refresh token (Used by Google APIs).", new String[0]),
    OAUTH2_ACCESS_TOKEN("oauth2AccessToken", Documented.DOCUMENTED, null, "OAuth2 refresh token (Used by Google APIs).", new String[0]),
    OAUTH2_CLIENT_ID("oauth2ClientId", Documented.UNDOCUMENTED, null, "OAuth2 client id (Used by Google APIs).", new String[0]),
    OAUTH2_CLIENT_SECRET("oauth2ClientSecret", Documented.UNDOCUMENTED, null, "OAuth2 client secret (Used by Google APIs).", new String[0]),
    OAUTH2_AUTH_URL("oauth2AuthUrl", Documented.UNDOCUMENTED, "https://accounts.google.com/o/oauth2/auth", "OAuth2 Auth URL (Used by Google APIs).", new String[0]),
    OAUTH2_TOKEN_URL("oauth2TokenUrl", Documented.UNDOCUMENTED, "https://accounts.google.com/o/oauth2/token", "OAuth2 Token URL (Used by Google APIs).", new String[0]),
    GAIA_MINT("gaiaMint", Documented.UNDOCUMENTED, null, "Gaia mint (Used by Google APIs, sent from the Speckle console).", new String[0]),
    SERVICE_ACCOUNT("serviceAccount", Documented.UNDOCUMENTED, null, "Service account used to fetch Google Compute access tokens.", new String[0]);

    private static final Set<ConnectionProperty> defaults;
    private final DriverPropertyInfo info;
    private final boolean documented;

    private ConnectionProperty(String key, Documented documented, Object defaultValue, String description, String ... choices) {
        this.documented = documented == Documented.DOCUMENTED;
        this.info = ConnectionProperty.newDriverPropertyInfo(key, defaultValue != null ? String.valueOf(defaultValue) : null, description, choices);
    }

    public String key() {
        return this.info.name;
    }

    public DriverPropertyInfo info() {
        return this.newDriverPropertyInfo(this.info);
    }

    boolean isDocumented() {
        return this.documented;
    }

    String defaultValue() {
        return this.info.value;
    }

    private DriverPropertyInfo newDriverPropertyInfo(DriverPropertyInfo info) {
        return ConnectionProperty.newDriverPropertyInfo(info.name, info.value, info.description, info.choices);
    }

    static DriverPropertyInfo newDriverPropertyInfo(String key, String defaultValue, String description, String ... choices) {
        DriverPropertyInfo dpi = new DriverPropertyInfo(key, defaultValue);
        dpi.required = false;
        dpi.description = description;
        dpi.choices = choices != null && choices.length > 0 ? choices : null;
        return dpi;
    }

    static Set<ConnectionProperty> getDefaults() {
        return defaults;
    }

    static {
        EnumSet<ConnectionProperty> props = EnumSet.noneOf(ConnectionProperty.class);
        for (ConnectionProperty prop : ConnectionProperty.values()) {
            if (!prop.isDocumented()) continue;
            props.add(prop);
        }
        defaults = Collections.unmodifiableSet(props);
    }

    static enum Documented {
        DOCUMENTED,
        UNDOCUMENTED;

    }
}

