/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.tools.appstats.MemcacheWriter;
import com.google.appengine.tools.appstats.PayloadRenderer;
import com.google.appengine.tools.appstats.Recorder;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DeadlineExceededException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AppstatsFilter
implements Filter {
    static final String DEADLINE_MESSAGE = "Deadline exceeded; cannot log app stats";
    static Logger log = Logger.getLogger(AppstatsFilter.class.getName());
    static final String TRACE_HEADER_NAME = "X-TraceUrl";
    private static final String DEFAULT_BASE_PATH = "/appstats/";
    static Recorder.RecordWriter writer = null;
    static ApiProxy.Delegate<?> delegate;
    private String basePath;
    private String logMessage;
    private Recorder recorder;

    public AppstatsFilter() {
    }

    AppstatsFilter(String basePath, String logMessage) {
        this.basePath = basePath;
        this.logMessage = logMessage;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filters) throws IOException, ServletException {
        ApiProxy.Environment environment = this.getCurrentEvnvironment();
        Long id = writer.begin(delegate, environment, (HttpServletRequest)request);
        final HttpServletResponse innerResponse = (HttpServletResponse)response;
        final Integer[] responseCode = new Integer[]{null};
        innerResponse.addHeader(TRACE_HEADER_NAME, this.basePath + "details?time=" + id + "&type=json");
        HttpServletResponse outerResponse = (HttpServletResponse)Proxy.newProxyInstance(AppstatsFilter.class.getClassLoader(), new Class[]{HttpServletResponse.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("sendError") || method.getName().equals("setStatus")) {
                    responseCode[0] = ((Number)args[0]).intValue();
                } else if (method.getName().equals("sendRedirect")) {
                    responseCode[0] = 307;
                }
                return method.invoke((Object)innerResponse, args);
            }
        });
        try {
            filters.doFilter(request, (ServletResponse)outerResponse);
        }
        catch (DeadlineExceededException e) {
            id = null;
            log.warning(DEADLINE_MESSAGE);
            throw e;
        }
        finally {
            if (id != null) {
                if (this.recorder != null) {
                    this.recorder.processAsyncRpcs(environment);
                }
                boolean didCommit = writer.commit(delegate, environment, responseCode[0]);
                if (this.logMessage != null && didCommit) {
                    log.info(this.logMessage.replace("{ID}", "" + id));
                }
            }
        }
    }

    private static String getAppStatsPathFromConfig(FilterConfig config) {
        String path = config.getInitParameter("basePath");
        if (path == null) {
            return DEFAULT_BASE_PATH;
        }
        return path.endsWith("/") ? path : path + "/";
    }

    public synchronized void init(FilterConfig config) {
        if (writer == null) {
            MemcacheWriter newWriter = new MemcacheWriter(new Recorder.Clock(), MemcacheServiceFactory.getMemcacheService((String)"__appstats__"));
            delegate = ApiProxy.getDelegate();
            this.recorder = new Recorder(delegate, newWriter);
            AppstatsFilter.configureRecorder(config, this.recorder);
            ApiProxy.setDelegate(AppstatsFilter.wrapPartially(delegate, this.recorder));
            writer = newWriter;
        }
        this.basePath = AppstatsFilter.getAppStatsPathFromConfig(config);
        this.logMessage = config.getInitParameter("logMessage");
    }

    static <S, T extends S> S wrapPartially(final S original, final T wrapper) {
        if (!original.getClass().getName().contains("Local")) {
            return wrapper;
        }
        Class<?>[] interfaces = original.getClass().getInterfaces();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method wrapperMethod = null;
                try {
                    wrapperMethod = wrapper.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    return AppstatsFilter.call(method, original, args);
                }
                return AppstatsFilter.call(wrapperMethod, wrapper, args);
            }
        };
        return (S)Proxy.newProxyInstance(original.getClass().getClassLoader(), interfaces, handler);
    }

    private static Object call(Method m, Object o, Object[] args) throws Throwable {
        try {
            return m.invoke(o, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    ApiProxy.Environment getCurrentEvnvironment() {
        return ApiProxy.getCurrentEnvironment();
    }

    static void configureRecorder(FilterConfig config, Recorder recorder) {
        recorder.setMaxLinesOfStackTrace(AppstatsFilter.getPositiveInt(config, "maxLinesOfStackTrace", Integer.MAX_VALUE));
        if (config.getInitParameter("payloadRenderer") != null) {
            try {
                recorder.setPayloadRenderer((PayloadRenderer)Class.forName(config.getInitParameter("payloadRenderer")).newInstance());
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Cannot instantiate payloadRenderer", e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot instantiate payloadRenderer", e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot instantiate payloadRenderer", e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Cannot instantiate payloadRenderer", e);
            }
        }
        if (config.getInitParameter("onPendingAsyncCall") != null) {
            recorder.setUnprocessedFutureStrategy(Recorder.UnprocessedFutureStrategy.valueOf(config.getInitParameter("onPendingAsyncCall")));
        }
    }

    static int getPositiveInt(FilterConfig config, String key, int defaultValue) {
        int result = defaultValue;
        String stringValue = config.getInitParameter(key);
        if (stringValue != null && (result = Integer.parseInt(stringValue)) <= 0) {
            throw new IllegalArgumentException(key + " must be a positive value");
        }
        return result;
    }
}

