/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import twitter4j.ConnectionLifeCycleListener;
import twitter4j.FilterQuery;
import twitter4j.RateLimitStatusListener;
import twitter4j.SiteStreamsImpl;
import twitter4j.SiteStreamsListener;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamImplementation;
import twitter4j.StreamListener;
import twitter4j.StreamingReadTimeoutConfiguration;
import twitter4j.TwitterException;
import twitter4j.TwitterOAuthSupportBaseImpl;
import twitter4j.UserStream;
import twitter4j.UserStreamImpl;
import twitter4j.UserStreamListener;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.RequestToken;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.async.DispatcherFactory;
import twitter4j.internal.http.HttpClientWrapper;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpResponseEvent;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.util.StringUtil;

public final class TwitterStream
extends TwitterOAuthSupportBaseImpl {
    private static final long serialVersionUID = 5529611191443189901L;
    private final HttpClientWrapper http;
    private static final Logger logger = Logger.getLogger(TwitterStream.class);
    private StreamListener[] streamListeners = new StreamListener[0];
    private List<ConnectionLifeCycleListener> lifeCycleListeners = new ArrayList<ConnectionLifeCycleListener>(0);
    private TwitterStreamConsumer handler = null;
    private static transient Dispatcher dispatcher;
    private boolean shutdown = false;
    private static final int TCP_ERROR_INITIAL_WAIT = 250;
    private static final int TCP_ERROR_WAIT_CAP = 16000;
    private static final int HTTP_ERROR_INITIAL_WAIT = 10000;
    private static final int HTTP_ERROR_WAIT_CAP = 240000;
    private static final int NO_WAIT = 0;
    static int count;

    public TwitterStream() {
        super(ConfigurationContext.getInstance());
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
    }

    public TwitterStream(String screenName, String password) {
        super(ConfigurationContext.getInstance(), screenName, password);
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
    }

    public TwitterStream(String screenName, String password, StreamListener listener) {
        super(ConfigurationContext.getInstance(), screenName, password);
        if (null != listener) {
            this.addListener(listener);
        }
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(this.conf));
    }

    TwitterStream(Configuration conf, Authorization auth, StreamListener listener) {
        super(conf, auth);
        if (null != listener) {
            this.addListener(listener);
        }
        this.http = new HttpClientWrapper(new StreamingReadTimeoutConfiguration(conf));
    }

    public void firehose(final int count) {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFirehoseStream(count);
            }

            public /* synthetic */ StreamImplementation getStream() throws TwitterException {
                return this.getStream();
            }
        });
    }

    public StatusStream getFirehoseStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/firehose.json", count);
    }

    public void links(final int count) {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getLinksStream(count);
            }

            public /* synthetic */ StreamImplementation getStream() throws TwitterException {
                return this.getStream();
            }
        });
    }

    public StatusStream getLinksStream(int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getCountStream("statuses/links.json", count);
    }

    public void stream(final String relativeUrl, final int count, boolean handleUserStream) {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getCountStream(relativeUrl, count);
            }

            public /* synthetic */ StreamImplementation getStream() throws TwitterException {
                return this.getStream();
            }
        });
    }

    private StatusStream getCountStream(String relativeUrl, int count) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + relativeUrl, new HttpParameter[]{new HttpParameter("count", String.valueOf(count))}, this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void retweet() {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getRetweetStream();
            }

            public /* synthetic */ StreamImplementation getStream() throws TwitterException {
                return this.getStream();
            }
        });
    }

    public StatusStream getRetweetStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + "statuses/retweet.json", new HttpParameter[0], this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void sample() {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getSampleStream();
            }

            public /* synthetic */ StreamImplementation getStream() throws TwitterException {
                return this.getStream();
            }
        });
    }

    public StatusStream getSampleStream() throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.http.get(this.conf.getStreamBaseURL() + "statuses/sample.json", this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void user() {
        this.user(null);
    }

    public void user(final String[] track) {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        StreamListener[] arr$ = this.streamListeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            if (listener instanceof UserStreamListener) continue;
            throw new IllegalStateException("Only UserStreamListener is supported. found: " + listener.getClass());
        }
        this.startHandler(new TwitterStreamConsumer(){

            public UserStream getStream() throws TwitterException {
                return TwitterStream.this.getUserStream(track);
            }

            public /* synthetic */ StreamImplementation getStream() throws TwitterException {
                return this.getStream();
            }
        });
    }

    public UserStream getUserStream() throws TwitterException {
        return this.getUserStream(null);
    }

    public UserStream getUserStream(String[] track) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
            if (this.conf.isUserStreamRepliesAllEnabled()) {
                params.add(new HttpParameter("replies", "all"));
            }
            if (null != track) {
                params.add(new HttpParameter("track", StringUtil.join(track)));
            }
            return new UserStreamImpl(this.http.post(this.conf.getUserStreamBaseURL() + "user.json", params.toArray(new HttpParameter[params.size()]), this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void site(final boolean withFollowings, final int[] follow) {
        this.ensureOAuthEnabled();
        this.ensureListenerIsSet();
        StreamListener[] arr$ = this.streamListeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            if (listener instanceof SiteStreamsListener) continue;
            throw new IllegalStateException("Only SiteStreamListener is supported. found: " + listener.getClass());
        }
        this.startHandler(new TwitterStreamConsumer(){

            public StreamImplementation getStream() throws TwitterException {
                try {
                    return new SiteStreamsImpl(TwitterStream.this.getDispatcher(), TwitterStream.this.getSiteStream(withFollowings, follow));
                }
                catch (IOException e) {
                    throw new TwitterException(e);
                }
            }
        });
    }

    private Dispatcher getDispatcher() {
        if (this.shutdown) {
            throw new IllegalStateException("Already shut down");
        }
        if (null == dispatcher) {
            dispatcher = new DispatcherFactory(this.conf).getInstance();
        }
        return dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        super.shutdown();
        this.cleanUp();
        Class clazz = TwitterStream.class;
        synchronized (clazz) {
            if (this.shutdown) {
                throw new IllegalStateException("Already shut down");
            }
            if (dispatcher != null) {
                dispatcher.shutdown();
                dispatcher = null;
            }
            this.shutdown = true;
        }
    }

    InputStream getSiteStream(boolean withFollowings, int[] follow) throws TwitterException {
        this.ensureOAuthEnabled();
        return this.http.post(this.conf.getSiteStreamBaseURL() + "site.json", new HttpParameter[]{new HttpParameter("with", withFollowings ? "followings" : "user"), new HttpParameter("follow", StringUtil.join(follow))}, this.auth).asStream();
    }

    public void filter(final FilterQuery query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFilterStream(query);
            }

            public /* synthetic */ StreamImplementation getStream() throws TwitterException {
                return this.getStream();
            }
        });
    }

    public StatusStream getFilterStream(FilterQuery query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return new StatusStreamImpl(this.http.post(this.conf.getStreamBaseURL() + "statuses/filter.json", query.asHttpParameterArray(), this.auth));
        }
        catch (IOException e) {
            throw new TwitterException(e);
        }
    }

    public void filter(final int count, final int[] follow, final String[] track) {
        this.ensureAuthorizationEnabled();
        this.ensureListenerIsSet();
        this.ensureStatusStreamListenerIsSet();
        this.startHandler(new TwitterStreamConsumer(){

            public StatusStream getStream() throws TwitterException {
                return TwitterStream.this.getFilterStream(count, follow, track);
            }

            public /* synthetic */ StreamImplementation getStream() throws TwitterException {
                return this.getStream();
            }
        });
    }

    public StatusStream getFilterStream(int count, int[] follow, String[] track) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return this.getFilterStream(new FilterQuery(count, follow, track, null));
    }

    private void ensureListenerIsSet() {
        if (this.streamListeners.length == 0) {
            throw new IllegalStateException("No listener is set.");
        }
    }

    private void ensureStatusStreamListenerIsSet() {
        StreamListener[] arr$ = this.streamListeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            if (listener instanceof StatusListener) continue;
            throw new IllegalStateException("Only StatusListener is supported. found: " + listener.getClass());
        }
    }

    private synchronized void startHandler(TwitterStreamConsumer handler) {
        this.cleanUp();
        if (this.streamListeners.length == 0) {
            throw new IllegalStateException("StatusListener is not set.");
        }
        this.handler = handler;
        this.handler.start();
    }

    public synchronized void cleanUp() {
        if (null != this.handler) {
            try {
                this.handler.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void cleanup() {
        this.cleanUp();
    }

    public void addConnectionLifeCycleListener(ConnectionLifeCycleListener listener) {
        this.lifeCycleListeners.add(listener);
    }

    public void setStatusListener(StatusListener listener) {
        this.streamListeners = new StreamListener[1];
        this.streamListeners[0] = listener;
    }

    public void addStatusListener(StatusListener statusListener) {
        this.addListener((StreamListener)statusListener);
    }

    public void setUserStreamListener(UserStreamListener listener) {
        this.streamListeners = new StreamListener[1];
        this.streamListeners[0] = listener;
    }

    public void addUserStreamListener(UserStreamListener userStreamListener) {
        this.addListener((StreamListener)userStreamListener);
    }

    public void addListener(UserStreamListener listener) {
        this.addListener((StreamListener)listener);
    }

    public void addListener(StatusListener listener) {
        this.addListener((StreamListener)listener);
    }

    public void addListener(SiteStreamsListener listener) {
        this.addListener((StreamListener)listener);
    }

    private synchronized void addListener(StreamListener listener) {
        StreamListener[] newListeners = new StreamListener[this.streamListeners.length + 1];
        System.arraycopy(this.streamListeners, 0, newListeners, 0, this.streamListeners.length);
        newListeners[newListeners.length - 1] = listener;
        this.streamListeners = newListeners;
    }

    public /* synthetic */ void setOAuthConsumer(String x0, String x1) {
        super.setOAuthConsumer(x0, x1);
    }

    public /* synthetic */ boolean isOAuthEnabled() {
        return super.isOAuthEnabled();
    }

    public /* synthetic */ void setOAuthAccessToken(String x0, String x1) {
        super.setOAuthAccessToken(x0, x1);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(String x0, String x1, String x2) throws TwitterException {
        return super.getOAuthAccessToken(x0, x1, x2);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(String x0, String x1) throws TwitterException {
        return super.getOAuthAccessToken(x0, x1);
    }

    public /* synthetic */ void setOAuthAccessToken(AccessToken x0) {
        super.setOAuthAccessToken(x0);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(RequestToken x0, String x1) throws TwitterException {
        return super.getOAuthAccessToken(x0, x1);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(RequestToken x0) throws TwitterException {
        return super.getOAuthAccessToken(x0);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken(String x0) throws TwitterException {
        return super.getOAuthAccessToken(x0);
    }

    public /* synthetic */ AccessToken getOAuthAccessToken() throws TwitterException {
        return super.getOAuthAccessToken();
    }

    public /* synthetic */ RequestToken getOAuthRequestToken(String x0) throws TwitterException {
        return super.getOAuthRequestToken(x0);
    }

    public /* synthetic */ RequestToken getOAuthRequestToken() throws TwitterException {
        return super.getOAuthRequestToken();
    }

    public /* synthetic */ void httpResponseReceived(HttpResponseEvent x0) {
        super.httpResponseReceived(x0);
    }

    public /* synthetic */ int hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    public /* synthetic */ void setRateLimitStatusListener(RateLimitStatusListener x0) {
        super.setRateLimitStatusListener(x0);
    }

    public /* synthetic */ String toString() {
        return super.toString();
    }

    public /* synthetic */ Configuration getConfiguration() {
        return super.getConfiguration();
    }

    static {
        count = 0;
    }

    abstract class TwitterStreamConsumer
    extends Thread {
        private StreamImplementation stream = null;
        private final String NAME = "Twitter Stream consumer-" + ++count;
        private boolean closed = false;

        TwitterStreamConsumer() {
            this.setName(this.NAME + "[initializing]");
        }

        public void run() {
            ConnectionLifeCycleListener listener;
            Iterator i$;
            int timeToSleep = 0;
            boolean connected = false;
            while (!this.closed) {
                Iterator i$2;
                try {
                    if (this.closed || null != this.stream) continue;
                    this.setStatus("[Establishing connection]");
                    this.stream = this.getStream();
                    connected = true;
                    i$ = TwitterStream.this.lifeCycleListeners.iterator();
                    while (i$.hasNext()) {
                        listener = (ConnectionLifeCycleListener)i$.next();
                        try {
                            listener.onConnect();
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage());
                        }
                    }
                    timeToSleep = 0;
                    this.setStatus("[Receiving stream]");
                    while (!this.closed) {
                        try {
                            this.stream.next(TwitterStream.this.streamListeners);
                        }
                        catch (IllegalStateException ise) {
                            connected = false;
                            i$2 = TwitterStream.this.lifeCycleListeners.iterator();
                            while (i$2.hasNext()) {
                                ConnectionLifeCycleListener listener2 = (ConnectionLifeCycleListener)i$2.next();
                                try {
                                    listener2.onDisconnect();
                                }
                                catch (Exception e) {
                                    logger.warn(e.getMessage());
                                }
                            }
                        }
                        catch (Exception e) {
                            this.stream.onException(e);
                        }
                    }
                }
                catch (TwitterException te) {
                    if (this.closed) continue;
                    if (0 == timeToSleep) {
                        if (te.getStatusCode() == 403) {
                            logger.warn("This account is not in required role.");
                            this.closed = true;
                            break;
                        }
                        if (te.getStatusCode() > 200) {
                            timeToSleep = 10000;
                        } else if (0 == timeToSleep) {
                            timeToSleep = 250;
                        }
                    }
                    if (connected) {
                        i$2 = TwitterStream.this.lifeCycleListeners.iterator();
                        while (i$2.hasNext()) {
                            ConnectionLifeCycleListener listener3 = (ConnectionLifeCycleListener)i$2.next();
                            try {
                                listener3.onDisconnect();
                            }
                            catch (Exception e) {
                                logger.warn(e.getMessage());
                            }
                        }
                    }
                    if (!this.closed) {
                        this.setStatus("[Waiting for " + timeToSleep + " milliseconds]");
                        try {
                            Thread.sleep(timeToSleep);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        timeToSleep = Math.min(timeToSleep * 2, te.getStatusCode() > 200 ? 240000 : 16000);
                    }
                    this.stream = null;
                    logger.debug(te.getMessage());
                    StreamListener[] arr$ = TwitterStream.this.streamListeners;
                    int len$ = arr$.length;
                    for (int i$3 = 0; i$3 < len$; ++i$3) {
                        StreamListener statusListener = arr$[i$3];
                        statusListener.onException(te);
                    }
                    connected = false;
                }
            }
            try {
                if (null != this.stream && connected) {
                    this.stream.close();
                    i$ = TwitterStream.this.lifeCycleListeners.iterator();
                    while (i$.hasNext()) {
                        listener = (ConnectionLifeCycleListener)i$.next();
                        try {
                            listener.onDisconnect();
                        }
                        catch (Exception e) {
                            logger.warn(e.getMessage());
                        }
                    }
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
            i$ = TwitterStream.this.lifeCycleListeners.iterator();
            while (i$.hasNext()) {
                listener = (ConnectionLifeCycleListener)i$.next();
                try {
                    listener.onCleanUp();
                }
                catch (Exception e) {
                    logger.warn(e.getMessage());
                }
            }
        }

        public synchronized void close() throws IOException {
            this.setStatus("[Disposing thread]");
            if (null != this.stream) {
                this.stream.close();
            }
            this.closed = true;
        }

        private void setStatus(String message) {
            String actualMessage = this.NAME + message;
            this.setName(actualMessage);
            logger.debug(actualMessage);
        }

        abstract StreamImplementation getStream() throws TwitterException;
    }
}

