/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.UserList;
import twitter4j.UserListJSONImpl;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

abstract class AbstractStreamImplementation {
    protected static final Logger logger = Logger.getLogger(StatusStreamImpl.class);
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private HttpResponse response;

    AbstractStreamImplementation(InputStream stream) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
    }

    AbstractStreamImplementation(HttpResponse response) throws IOException {
        this(response.asStream());
        this.response = response;
    }

    protected String parseLine(String line) {
        return line;
    }

    abstract void next(StreamListener[] var1) throws TwitterException;

    protected void handleNextElement() throws TwitterException {
        block39: {
            if (!this.streamAlive) {
                throw new IllegalStateException("Stream already closed.");
            }
            try {
                String line = this.parseLine(this.br.readLine());
                if (null == line) {
                    throw new IOException("the end of the stream has been reached");
                }
                if (line.length() <= 0) break block39;
                logger.debug("received:", line);
                try {
                    JSONObject json = new JSONObject(line);
                    if (!json.isNull("sender")) {
                        this.onSender(json);
                        break block39;
                    }
                    if (!json.isNull("text")) {
                        this.onStatus(json);
                        break block39;
                    }
                    if (!json.isNull("direct_message")) {
                        this.onDirectMessage(json);
                        break block39;
                    }
                    if (!json.isNull("delete")) {
                        this.onDelete(json);
                        break block39;
                    }
                    if (!json.isNull("limit")) {
                        this.onLimit(json);
                        break block39;
                    }
                    if (!json.isNull("scrub_geo")) {
                        this.onScrubGeo(json);
                        break block39;
                    }
                    if (!json.isNull("friends")) {
                        this.onFriends(json);
                        break block39;
                    }
                    if (!json.isNull("event")) {
                        String event = json.getString("event");
                        JSONObject sourceJSON = json.getJSONObject("source");
                        JSONObject targetJSON = json.getJSONObject("target");
                        if ("favorite".equals(event)) {
                            this.onFavorite(sourceJSON, targetJSON, json.getJSONObject("target_object"));
                        } else if ("unfavorite".equals(event)) {
                            this.onUnfavorite(sourceJSON, targetJSON, json.getJSONObject("target_object"));
                        } else if ("retweet".equals(event)) {
                            this.onRetweet(sourceJSON, targetJSON, json.getJSONObject("target_object"));
                        } else if ("follow".equals(event)) {
                            this.onFollow(sourceJSON, targetJSON);
                        } else if (event.startsWith("list_")) {
                            if ("list_user_subscribed".equals(event)) {
                                JSONObject targetObjectJSON = json.getJSONObject("target_object");
                                this.onUserListSubscribed(sourceJSON, targetJSON, targetObjectJSON);
                            } else if ("list_created".equals(event)) {
                                this.onUserListCreated(sourceJSON, targetJSON);
                            } else if ("list_updated".equals(event)) {
                                this.onUserListUpdated(sourceJSON, targetJSON);
                            } else if ("list_destroyed".equals(event)) {
                                this.onUserListDestroyed(sourceJSON, targetJSON);
                            }
                        } else if ("user_update".equals(event)) {
                            this.onUserUpdate(sourceJSON, targetJSON);
                        } else if ("block".equals(event)) {
                            this.onBlock(sourceJSON, targetJSON);
                        } else if ("unblock".equals(event)) {
                            this.onUnblock(sourceJSON, targetJSON);
                        } else {
                            logger.info("Received unknown event type '" + event + "': " + line);
                        }
                        break block39;
                    }
                    logger.info("Received unknown event: " + line);
                }
                catch (JSONException jsone) {
                    this.onException(jsone);
                }
            }
            catch (IOException ioe) {
                try {
                    this.is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                boolean isUnexpectedException = this.streamAlive;
                this.streamAlive = false;
                if (!isUnexpectedException) break block39;
                throw new TwitterException("Stream closed.", ioe);
            }
        }
    }

    protected void onSender(JSONObject json) throws TwitterException {
    }

    protected void onStatus(JSONObject json) throws TwitterException {
    }

    protected void onDirectMessage(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onDelete(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onLimit(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onScrubGeo(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onFriends(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
    }

    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
    }

    protected void onRetweet(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
    }

    protected void onFollow(JSONObject source, JSONObject target) throws TwitterException {
    }

    protected void onUserListSubscribed(JSONObject source, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
    }

    protected void onUserListCreated(JSONObject source, JSONObject userList) throws TwitterException, JSONException {
    }

    protected void onUserListUpdated(JSONObject source, JSONObject userList) throws TwitterException, JSONException {
    }

    protected void onUserListDestroyed(JSONObject source, JSONObject userList) throws TwitterException {
    }

    protected void onUserUpdate(JSONObject source, JSONObject target) throws TwitterException {
    }

    protected void onBlock(JSONObject source, JSONObject target) throws TwitterException {
    }

    protected void onUnblock(JSONObject source, JSONObject target) throws TwitterException {
    }

    protected void onException(Exception e) {
    }

    public void close() throws IOException {
        this.streamAlive = false;
        this.is.close();
        this.br.close();
        if (null != this.response) {
            this.response.disconnect();
        }
    }

    protected Status asStatus(JSONObject json) throws TwitterException {
        StatusJSONImpl status = new StatusJSONImpl(json);
        DataObjectFactoryUtil.registerJSONObject(status, json);
        return status;
    }

    protected DirectMessage asDirectMessage(JSONObject json) throws TwitterException {
        DirectMessageJSONImpl directMessage = null;
        try {
            directMessage = new DirectMessageJSONImpl(json.getJSONObject("direct_message"));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
        DataObjectFactoryUtil.registerJSONObject(directMessage, json);
        return directMessage;
    }

    protected int[] asFriendList(JSONObject json) throws TwitterException {
        JSONArray friends = null;
        try {
            friends = json.getJSONArray("friends");
            int[] friendIds = new int[friends.length()];
            for (int i = 0; i < friendIds.length; ++i) {
                friendIds[i] = friends.getInt(i);
            }
            return friendIds;
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    protected User asUser(JSONObject json) throws TwitterException {
        UserJSONImpl user = new UserJSONImpl(json);
        DataObjectFactoryUtil.registerJSONObject(user, json);
        return user;
    }

    protected UserList asUserList(JSONObject json) throws TwitterException {
        UserListJSONImpl userList = new UserListJSONImpl(json);
        DataObjectFactoryUtil.registerJSONObject(userList, json);
        return userList;
    }
}

