/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.common.annotations.GoogleInternal;
import java.security.SecureRandom;
import java.util.Random;

@GoogleInternal
public final class Randoms {
    private static final Random RANDOM = new ReadOnlyRandom();
    private static final SecureRandom SECURE_RANDOM = Randoms.newDefaultSecureRandom();

    private Randoms() {
    }

    public static SecureRandom secureRandom() {
        return SECURE_RANDOM;
    }

    public static SecureRandom secureRandom(byte[] seed) {
        SecureRandom retval = new SecureRandom(seed);
        retval.nextLong();
        return retval;
    }

    public static Random insecureRandom() {
        return RANDOM;
    }

    public static Random insecureRandom(long seed) {
        return new Random(seed);
    }

    private static SecureRandom newDefaultSecureRandom() {
        SecureRandom retval = new SecureRandom();
        retval.nextLong();
        return retval;
    }

    private static class ReadOnlyRandom
    extends Random {
        private static final long serialVersionUID = 898001275432099254L;
        private boolean initializationComplete = true;

        private ReadOnlyRandom() {
        }

        public void setSeed(long seed) {
            if (this.initializationComplete) {
                throw new UnsupportedOperationException("Setting the seed on the shared Random object is not permitted");
            }
            super.setSeed(seed);
        }
    }
}

