/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.CommittedButStillApplyingException;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreNeedIndexException;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import java.util.ConcurrentModificationException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatastoreApiHelper {
    static final String PACKAGE = "datastore_v3";

    private DatastoreApiHelper() {
    }

    public static RuntimeException translateError(ApiProxy.ApplicationException exception) {
        DatastorePb.Error.ErrorCode errorCode = DatastorePb.Error.ErrorCode.valueOf(exception.getApplicationError());
        if (errorCode == null) {
            return new DatastoreFailureException(exception.getErrorDetail());
        }
        switch (errorCode) {
            case BAD_REQUEST: {
                return new IllegalArgumentException(exception.getErrorDetail());
            }
            case CONCURRENT_TRANSACTION: {
                return new ConcurrentModificationException(exception.getErrorDetail());
            }
            case NEED_INDEX: {
                return new DatastoreNeedIndexException(exception.getErrorDetail());
            }
            case TIMEOUT: 
            case BIGTABLE_ERROR: {
                return new DatastoreTimeoutException(exception.getErrorDetail());
            }
            case COMMITTED_BUT_STILL_APPLYING: {
                return new CommittedButStillApplyingException(exception.getErrorDetail());
            }
        }
        return new DatastoreFailureException(exception.getErrorDetail());
    }

    static void makeSyncCall(ApiProxy.ApiConfig apiConfig, String method, ProtocolMessage<?> request, ProtocolMessage<?> response) {
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, method, request.toByteArray(), apiConfig);
            if (responseBytes != null) {
                response.mergeFrom(responseBytes);
            }
        }
        catch (ApiProxy.ApplicationException exception) {
            throw DatastoreApiHelper.translateError(exception);
        }
    }

    static <T extends ProtocolMessage<T>> Future<T> makeAsyncCall(ApiProxy.ApiConfig apiConfig, String method, ProtocolMessage<?> request, final T responseProto) {
        Future<byte[]> response = ApiProxy.makeAsyncCall(PACKAGE, method, request.toByteArray(), apiConfig);
        return new FutureWrapper<byte[], T>(response){

            @Override
            protected T wrap(byte[] responseBytes) {
                if (responseBytes != null) {
                    responseProto.mergeFrom(responseBytes);
                }
                return responseProto;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    return DatastoreApiHelper.translateError((ApiProxy.ApplicationException)cause);
                }
                return cause;
            }
        };
    }

    static String getCurrentAppId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new NullPointerException("No API environment is registered for this thread.");
        }
        return environment.getAppId();
    }

    static AppIdNamespace getCurrentAppIdNamespace() {
        return DatastoreApiHelper.getCurrentAppIdNamespace(DatastoreApiHelper.getCurrentAppId());
    }

    static AppIdNamespace getCurrentAppIdNamespace(String appId) {
        String namespace = NamespaceManager.get();
        namespace = namespace == null ? "" : namespace;
        return new AppIdNamespace(appId, namespace);
    }
}

