/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.json;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataObjectFactory {
    private static final Constructor<Status> statusConstructor;
    private static ThreadLocal<Map> rawJsonMap;
    static /* synthetic */ Class class$twitter4j$internal$org$json$JSONObject;

    private DataObjectFactory() {
        throw new AssertionError((Object)"not intended to be instantiated.");
    }

    public static String getRawJSON(Object obj) {
        Object json = rawJsonMap.get().get(obj);
        if (json instanceof String) {
            return (String)json;
        }
        if (null == json) {
            throw new IllegalStateException("raw JSON not found in this context.");
        }
        return json.toString();
    }

    public static Status createStatus(String rawJSON) throws TwitterException {
        try {
            JSONObject json = new JSONObject(rawJSON);
            return statusConstructor.newInstance(json);
        }
        catch (InstantiationException e) {
            throw new TwitterException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    static void clearThreadLocalMap() {
        rawJsonMap.get().clear();
    }

    static <T> T registerJSONObject(T key, Object json) {
        rawJsonMap.get().put(key, json);
        return key;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        try {
            statusConstructor = Class.forName("twitter4j.StatusJSONImpl").getDeclaredConstructor(class$twitter4j$internal$org$json$JSONObject == null ? (class$twitter4j$internal$org$json$JSONObject = DataObjectFactory.class$("twitter4j.internal.org.json.JSONObject")) : class$twitter4j$internal$org$json$JSONObject);
            statusConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        rawJsonMap = new ThreadLocal<Map>(){

            @Override
            protected Map initialValue() {
                return new HashMap();
            }

            @Override
            protected /* synthetic */ Object initialValue() {
                return this.initialValue();
            }
        };
    }
}

