/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import twitter4j.TwitterException;
import twitter4j.conf.ConfigurationContext;
import twitter4j.internal.http.HttpClient;
import twitter4j.internal.http.HttpClientConfiguration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpRequest;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.HttpResponseCode;
import twitter4j.internal.http.HttpResponseImpl;
import twitter4j.internal.http.RequestMethod;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.util.StringUtil;

public class HttpClientImpl
implements HttpClient,
HttpResponseCode,
Serializable {
    private static final Logger logger = Logger.getLogger(HttpClientImpl.class);
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyAuthUser = null;
    private String proxyAuthPassword = null;
    private int connectionTimeout = 20000;
    private int readTimeout = 120000;
    private int retryCount = 0;
    private int retryIntervalSeconds = 5000;
    private static boolean isJDK14orEarlier = false;
    private static final long serialVersionUID = -8819171414069621503L;
    private static final Map<HttpClientConfiguration, HttpClient> instanceMap;

    public HttpClientImpl() {
    }

    public HttpClientImpl(HttpClientConfiguration conf) {
        this.setProxyHost(conf.getHttpProxyHost());
        this.setProxyPort(conf.getHttpProxyPort());
        this.setProxyAuthUser(conf.getHttpProxyUser());
        this.setProxyAuthPassword(conf.getHttpProxyPassword());
        this.setConnectionTimeout(conf.getHttpConnectionTimeout());
        this.setReadTimeout(conf.getHttpReadTimeout());
        this.setRetryCount(conf.getHttpRetryCount());
        this.setRetryIntervalSeconds(conf.getHttpRetryIntervalSeconds());
        if (this.isProxyConfigured() && isJDK14orEarlier) {
            logger.warn("HTTP Proxy is not supported on JDK1.4 or earlier. Try twitter4j-httpclient-supoprt artifact");
        }
    }

    public void shutdown() {
    }

    public static HttpClient getInstance(HttpClientConfiguration conf) {
        HttpClient client = instanceMap.get(conf);
        if (null == client) {
            client = new HttpClientImpl(conf);
            instanceMap.put(conf, client);
        }
        return client;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyAuthUser() {
        return this.proxyAuthUser;
    }

    public void setProxyAuthUser(String proxyAuthUser) {
        this.proxyAuthUser = proxyAuthUser;
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = proxyAuthPassword;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRetryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("RetryCount cannot be negative.");
        }
        this.retryCount = retryCount;
    }

    public void setRetryIntervalSeconds(int retryIntervalSeconds) {
        if (retryIntervalSeconds < 0) {
            throw new IllegalArgumentException("RetryInterval cannot be negative.");
        }
        this.retryIntervalSeconds = retryIntervalSeconds;
    }

    public HttpResponse get(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, null, null));
    }

    public HttpResponse post(String url, HttpParameter[] params) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, params, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse request(HttpRequest req) throws TwitterException {
        int retry = this.retryCount + 1;
        HttpResponse res = null;
        for (int retriedCount = 0; retriedCount < retry; ++retriedCount) {
            block26: {
                int responseCode = -1;
                try {
                    HttpURLConnection con = null;
                    OutputStream os = null;
                    try {
                        con = this.getConnection(req.getURL());
                        con.setDoInput(true);
                        this.setHeaders(req, con);
                        con.setRequestMethod(req.getMethod().name());
                        if (req.getMethod() == RequestMethod.POST) {
                            if (HttpParameter.containsFile(req.getParameters())) {
                                String boundary = "----Twitter4J-upload" + System.currentTimeMillis();
                                con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                                boundary = "--" + boundary;
                                con.setDoOutput(true);
                                os = con.getOutputStream();
                                DataOutputStream out = new DataOutputStream(os);
                                HttpParameter[] arr$ = req.getParameters();
                                int len$ = arr$.length;
                                for (int i$ = 0; i$ < len$; ++i$) {
                                    HttpParameter param = arr$[i$];
                                    if (param.isFile()) {
                                        this.write(out, boundary + "\r\n");
                                        this.write(out, "Content-Disposition: form-data; name=\"" + param.getName() + "\"; filename=\"" + param.getFile().getName() + "\"\r\n");
                                        this.write(out, "Content-Type: " + param.getContentType() + "\r\n\r\n");
                                        BufferedInputStream in = new BufferedInputStream(param.hasFileBody() ? param.getFileBody() : new FileInputStream(param.getFile()));
                                        int buff = 0;
                                        while ((buff = in.read()) != -1) {
                                            out.write(buff);
                                        }
                                        this.write(out, "\r\n");
                                        in.close();
                                        continue;
                                    }
                                    this.write(out, boundary + "\r\n");
                                    this.write(out, "Content-Disposition: form-data; name=\"" + param.getName() + "\"\r\n");
                                    this.write(out, "Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                                    logger.debug(param.getValue());
                                    out.write(param.getValue().getBytes("UTF-8"));
                                    this.write(out, "\r\n");
                                }
                                this.write(out, boundary + "--\r\n");
                                this.write(out, "\r\n");
                            } else {
                                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                String postParam = HttpParameter.encodeParameters(req.getParameters());
                                logger.debug("Post Params: ", postParam);
                                byte[] bytes = postParam.getBytes("UTF-8");
                                con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                                con.setDoOutput(true);
                                os = con.getOutputStream();
                                os.write(bytes);
                            }
                            os.flush();
                            os.close();
                        }
                        res = new HttpResponseImpl(con);
                        responseCode = con.getResponseCode();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Response: ");
                            Map<String, List<String>> responseHeaders = con.getHeaderFields();
                            Iterator<String> i$ = responseHeaders.keySet().iterator();
                            while (i$.hasNext()) {
                                String key = i$.next();
                                List<String> values = responseHeaders.get(key);
                                Iterator<String> i$2 = values.iterator();
                                while (i$2.hasNext()) {
                                    String value = i$2.next();
                                    if (null != key) {
                                        logger.debug(key + ": " + value);
                                        continue;
                                    }
                                    logger.debug(value);
                                }
                            }
                        }
                        if (responseCode >= 200 && 300 > responseCode) break;
                        if (responseCode == 420 || responseCode == 503 || responseCode == 400 || responseCode < 500 || retriedCount == this.retryCount) {
                            throw new TwitterException(res.asString(), res);
                        }
                    }
                    finally {
                        try {
                            os.close();
                        }
                        catch (Exception ignore) {}
                    }
                }
                catch (IOException ioe) {
                    if (retriedCount != this.retryCount) break block26;
                    throw new TwitterException(ioe.getMessage(), ioe, responseCode);
                }
            }
            try {
                if (logger.isDebugEnabled() && null != res) {
                    res.asString();
                }
                logger.debug("Sleeping " + this.retryIntervalSeconds + " seconds until the next retry.");
                Thread.sleep(this.retryIntervalSeconds * 1000);
                continue;
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        return res;
    }

    private void write(DataOutputStream out, String outStr) throws IOException {
        out.writeBytes(outStr);
        logger.debug(outStr);
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException neverHappen) {
            throw new AssertionError((Object)"will never happen");
        }
    }

    private void setHeaders(HttpRequest req, HttpURLConnection connection) {
        String authorizationHeader;
        if (logger.isDebugEnabled()) {
            logger.debug("Request: ");
            logger.debug(req.getMethod().name() + " ", req.getURL());
        }
        if (null != req.getAuthorization() && null != (authorizationHeader = req.getAuthorization().getAuthorizationHeader(req))) {
            if (logger.isDebugEnabled()) {
                logger.debug("Authorization: ", StringUtil.maskString(authorizationHeader));
            }
            connection.addRequestProperty("Authorization", authorizationHeader);
        }
        if (null != req.getRequestHeaders()) {
            Iterator<String> i$ = req.getRequestHeaders().keySet().iterator();
            while (i$.hasNext()) {
                String key = i$.next();
                connection.addRequestProperty(key, req.getRequestHeaders().get(key));
                logger.debug(key + ": " + req.getRequestHeaders().get(key));
            }
        }
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection con = null;
        if (this.isProxyConfigured() && !isJDK14orEarlier) {
            if (this.proxyAuthUser != null && !this.proxyAuthUser.equals("")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Proxy AuthUser: " + this.proxyAuthUser);
                    logger.debug("Proxy AuthPassword: " + StringUtil.maskString(this.proxyAuthPassword));
                }
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClientImpl.this.proxyAuthUser, HttpClientImpl.this.proxyAuthPassword.toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.proxyHost, this.proxyPort));
            if (logger.isDebugEnabled()) {
                logger.debug("Opening proxied connection(" + this.proxyHost + ":" + this.proxyPort + ")");
            }
            con = (HttpURLConnection)new URL(url).openConnection(proxy);
        } else {
            con = (HttpURLConnection)new URL(url).openConnection();
        }
        if (this.connectionTimeout > 0 && !isJDK14orEarlier) {
            con.setConnectTimeout(this.connectionTimeout);
        }
        if (this.readTimeout > 0 && !isJDK14orEarlier) {
            con.setReadTimeout(this.readTimeout);
        }
        return con;
    }

    private boolean isProxyConfigured() {
        return this.proxyHost != null && !this.proxyHost.equals("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpClientImpl)) {
            return false;
        }
        HttpClientImpl that = (HttpClientImpl)o;
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.proxyPort != that.proxyPort) {
            return false;
        }
        if (this.readTimeout != that.readTimeout) {
            return false;
        }
        if (this.retryCount != that.retryCount) {
            return false;
        }
        if (this.retryIntervalSeconds != that.retryIntervalSeconds) {
            return false;
        }
        if (this.proxyAuthPassword != null ? !this.proxyAuthPassword.equals(that.proxyAuthPassword) : that.proxyAuthPassword != null) {
            return false;
        }
        if (this.proxyAuthUser != null ? !this.proxyAuthUser.equals(that.proxyAuthUser) : that.proxyAuthUser != null) {
            return false;
        }
        return !(this.proxyHost != null ? !this.proxyHost.equals(that.proxyHost) : that.proxyHost != null);
    }

    public int hashCode() {
        int result = this.proxyHost != null ? this.proxyHost.hashCode() : 0;
        result = 31 * result + this.proxyPort;
        result = 31 * result + (this.proxyAuthUser != null ? this.proxyAuthUser.hashCode() : 0);
        result = 31 * result + (this.proxyAuthPassword != null ? this.proxyAuthPassword.hashCode() : 0);
        result = 31 * result + this.connectionTimeout;
        result = 31 * result + this.readTimeout;
        result = 31 * result + this.retryCount;
        result = 31 * result + this.retryIntervalSeconds;
        return result;
    }

    public String toString() {
        return "HttpClientImpl{proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + ", proxyAuthUser='" + this.proxyAuthUser + '\'' + ", proxyAuthPassword='" + this.proxyAuthPassword + '\'' + ", connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ", retryCount=" + this.retryCount + ", retryIntervalSeconds=" + this.retryIntervalSeconds + '}';
    }

    static {
        try {
            String versionStr = System.getProperty("java.specification.version");
            if (null != versionStr) {
                boolean bl = isJDK14orEarlier = 1.5 > Double.parseDouble(versionStr);
            }
            if (ConfigurationContext.getInstance().isDalvik()) {
                System.setProperty("http.keepAlive", "false");
            }
        }
        catch (SecurityException ignore) {
            isJDK14orEarlier = true;
        }
        instanceMap = new HashMap<HttpClientConfiguration, HttpClient>(1);
    }
}

