/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.TwitterException;
import twitter4j.UserJSONImpl;
import twitter4j.UserListJSONImpl;
import twitter4j.UserStream;
import twitter4j.UserStreamListener;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatusStreamImpl
implements StatusStream,
UserStream {
    private static final Logger logger = Logger.getLogger(class$twitter4j$StatusStreamImpl == null ? (class$twitter4j$StatusStreamImpl = StatusStreamImpl.class$("twitter4j.StatusStreamImpl")) : class$twitter4j$StatusStreamImpl);
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private HttpResponse response;
    static /* synthetic */ Class class$twitter4j$StatusStreamImpl;

    StatusStreamImpl(InputStream stream) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
    }

    StatusStreamImpl(HttpResponse response) throws IOException {
        this(response.asStream());
        this.response = response;
    }

    @Override
    public void next(UserStreamListener listener) throws TwitterException {
        ArrayList<StatusListener> list = new ArrayList<StatusListener>(1);
        list.add(listener);
        this.handleNextElement(list);
    }

    @Override
    public void next(StatusListener listener) throws TwitterException {
        ArrayList<StatusListener> list = new ArrayList<StatusListener>(1);
        list.add(listener);
        this.handleNextElement(list);
    }

    void next(List<StatusListener> listeners) throws TwitterException {
        this.handleNextElement(listeners);
    }

    private void handleNextElement(List<StatusListener> listeners) throws TwitterException {
        block66: {
            if (!this.streamAlive) {
                throw new IllegalStateException("Stream already closed.");
            }
            try {
                String line = this.br.readLine();
                if (null == line) {
                    throw new IOException("the end of the stream has been reached");
                }
                if (line.length() <= 0) break block66;
                DataObjectFactoryUtil.clearThreadLocalMap();
                logger.debug("received:", line);
                try {
                    JSONObject json = new JSONObject(line);
                    if (!json.isNull("sender")) {
                        for (StatusListener listener : listeners) {
                            if (!(listener instanceof UserStreamListener)) continue;
                            ((UserStreamListener)listener).onDirectMessage(new DirectMessageJSONImpl(json));
                        }
                    } else if (!json.isNull("text")) {
                        for (StatusListener listener : listeners) {
                            listener.onStatus(DataObjectFactoryUtil.registerJSONObject(new StatusJSONImpl(json), json));
                        }
                    } else if (!json.isNull("direct_message")) {
                        for (StatusListener listener : listeners) {
                            if (!(listener instanceof UserStreamListener)) continue;
                            ((UserStreamListener)listener).onDirectMessage(new DirectMessageJSONImpl(json.getJSONObject("direct_message")));
                        }
                    } else if (!json.isNull("delete")) {
                        for (StatusListener listener : listeners) {
                            listener.onDeletionNotice(new StatusDeletionNoticeImpl(json));
                        }
                    } else if (!json.isNull("limit")) {
                        for (StatusListener listener : listeners) {
                            listener.onTrackLimitationNotice(ParseUtil.getInt("track", json.getJSONObject("limit")));
                        }
                    } else if (!json.isNull("scrub_geo")) {
                        System.out.println(new StringBuffer().append("Geo-tagging deletion notice (not implemented yet): ").append(line).toString());
                    } else if (!json.isNull("friends")) {
                        JSONArray friends = json.getJSONArray("friends");
                        int[] friendIds = new int[friends.length()];
                        for (int i = 0; i < friendIds.length; ++i) {
                            friendIds[i] = friends.getInt(i);
                        }
                        for (StatusListener listener : listeners) {
                            if (!(listener instanceof UserStreamListener)) continue;
                            ((UserStreamListener)listener).onFriendList(friendIds);
                        }
                    } else if (!json.isNull("event")) {
                        String event = json.getString("event");
                        UserJSONImpl source = new UserJSONImpl(json.getJSONObject("source"));
                        UserJSONImpl target = new UserJSONImpl(json.getJSONObject("target"));
                        if ("favorite".equals(event)) {
                            StatusJSONImpl targetObject = new StatusJSONImpl(json.getJSONObject("target_object"));
                            for (StatusListener listener : listeners) {
                                if (!(listener instanceof UserStreamListener)) continue;
                                ((UserStreamListener)listener).onFavorite(source, target, targetObject);
                            }
                        } else if ("unfavorite".equals(event)) {
                            StatusJSONImpl targetObject = new StatusJSONImpl(json.getJSONObject("target_object"));
                            for (StatusListener listener : listeners) {
                                if (!(listener instanceof UserStreamListener)) continue;
                                ((UserStreamListener)listener).onUnfavorite(source, target, targetObject);
                            }
                        } else if ("retweet".equals(event)) {
                            StatusJSONImpl targetObject = new StatusJSONImpl(json.getJSONObject("target_object"));
                            for (StatusListener listener : listeners) {
                                if (!(listener instanceof UserStreamListener)) continue;
                                ((UserStreamListener)listener).onRetweet(source, target, targetObject);
                            }
                        } else if ("follow".equals(event)) {
                            for (StatusListener listener : listeners) {
                                if (!(listener instanceof UserStreamListener)) continue;
                                ((UserStreamListener)listener).onFollow(source, target);
                            }
                        } else if ("unfollow".equals(event)) {
                            for (StatusListener listener : listeners) {
                                if (!(listener instanceof UserStreamListener)) continue;
                                ((UserStreamListener)listener).onUnfollow(source, target);
                            }
                        } else if (event.startsWith("list_")) {
                            UserListJSONImpl targetObject = new UserListJSONImpl(json.getJSONObject("target_object"));
                            if ("list_user_subscribed".equals(event)) {
                                for (StatusListener listener : listeners) {
                                    if (!(listener instanceof UserStreamListener)) continue;
                                    ((UserStreamListener)listener).onUserListSubscribed(source, target, targetObject);
                                }
                            } else if ("list_created".equals(event)) {
                                for (StatusListener listener : listeners) {
                                    if (!(listener instanceof UserStreamListener)) continue;
                                    ((UserStreamListener)listener).onUserListCreated(source, targetObject);
                                }
                            } else if ("list_updated".equals(event)) {
                                for (StatusListener listener : listeners) {
                                    if (!(listener instanceof UserStreamListener)) continue;
                                    ((UserStreamListener)listener).onUserListUpdated(source, targetObject);
                                }
                            } else if ("list_destroyed".equals(event)) {
                                for (StatusListener listener : listeners) {
                                    if (!(listener instanceof UserStreamListener)) continue;
                                    ((UserStreamListener)listener).onUserListDestroyed(source, targetObject);
                                }
                            }
                        } else if ("block".equals(event)) {
                            for (StatusListener listener : listeners) {
                                if (!(listener instanceof UserStreamListener)) continue;
                                ((UserStreamListener)listener).onBlock(source, target);
                            }
                        } else if ("unblock".equals(event)) {
                            for (StatusListener listener : listeners) {
                                if (!(listener instanceof UserStreamListener)) continue;
                                ((UserStreamListener)listener).onUnblock(source, target);
                            }
                        } else {
                            logger.info(new StringBuffer().append("Received unknown event type '").append(event).append("': ").append(line).toString());
                        }
                    } else {
                        logger.info(new StringBuffer().append("Received unknown event: ").append(line).toString());
                    }
                }
                catch (JSONException jsone) {
                    for (StatusListener listener : listeners) {
                        listener.onException(jsone);
                    }
                }
            }
            catch (IOException ioe) {
                try {
                    this.is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                boolean isUnexceptedException = this.streamAlive;
                this.streamAlive = false;
                if (!isUnexceptedException) break block66;
                throw new TwitterException("Stream closed.", ioe);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.streamAlive = false;
        this.is.close();
        this.br.close();
        if (null != this.response) {
            this.response.disconnect();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

