/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.StatusDeletionNoticeImpl;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusListener;
import twitter4j.StatusStream;
import twitter4j.TwitterException;
import twitter4j.UserJSONImpl;
import twitter4j.UserListJSONImpl;
import twitter4j.UserStream;
import twitter4j.UserStreamAdapter;
import twitter4j.UserStreamListener;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

class StatusStreamImpl
implements StatusStream,
UserStream {
    private static final Logger logger = Logger.getLogger(StatusStreamImpl.class);
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private HttpResponse response;
    private static final UserStreamAdapter nullAdapter = new UserStreamAdapter();

    StatusStreamImpl(InputStream stream) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
    }

    StatusStreamImpl(HttpResponse response) throws IOException {
        this(response.asStream());
        this.response = response;
    }

    public void next(UserStreamListener listener) throws TwitterException {
        this.handleNextElement(listener, listener);
    }

    public void next(StatusListener listener) throws TwitterException {
        this.handleNextElement(listener, nullAdapter);
    }

    private void handleNextElement(StatusListener listener, UserStreamListener userStreamListener) throws TwitterException {
        block40: {
            if (!this.streamAlive) {
                throw new IllegalStateException("Stream already closed.");
            }
            try {
                String line = this.br.readLine();
                if (null == line) {
                    throw new IOException("the end of the stream has been reached");
                }
                if (line.length() <= 0) break block40;
                logger.debug("received:", line);
                try {
                    JSONObject json = new JSONObject(line);
                    if (!json.isNull("sender")) {
                        userStreamListener.onDirectMessage(new DirectMessageJSONImpl(json));
                        break block40;
                    }
                    if (!json.isNull("text")) {
                        listener.onStatus(new StatusJSONImpl(json));
                        break block40;
                    }
                    if (!json.isNull("direct_message")) {
                        userStreamListener.onDirectMessage(new DirectMessageJSONImpl(json.getJSONObject("direct_message")));
                        break block40;
                    }
                    if (!json.isNull("delete")) {
                        listener.onDeletionNotice(new StatusDeletionNoticeImpl(json));
                        break block40;
                    }
                    if (!json.isNull("limit")) {
                        listener.onTrackLimitationNotice(ParseUtil.getInt("track", json.getJSONObject("limit")));
                        break block40;
                    }
                    if (!json.isNull("scrub_geo")) {
                        System.out.println("Geo-tagging deletion notice (not implemented yet): " + line);
                        break block40;
                    }
                    if (!json.isNull("friends")) {
                        JSONArray friends = json.getJSONArray("friends");
                        int[] friendIds = new int[friends.length()];
                        for (int i = 0; i < friendIds.length; ++i) {
                            friendIds[i] = friends.getInt(i);
                        }
                        userStreamListener.onFriendList(friendIds);
                        break block40;
                    }
                    if (!json.isNull("event")) {
                        String event = json.getString("event");
                        UserJSONImpl source = new UserJSONImpl(json.getJSONObject("source"));
                        UserJSONImpl target = new UserJSONImpl(json.getJSONObject("target"));
                        if ("favorite".equals(event)) {
                            StatusJSONImpl targetObject = new StatusJSONImpl(json.getJSONObject("target_object"));
                            userStreamListener.onFavorite(source, target, targetObject);
                        } else if ("unfavorite".equals(event)) {
                            StatusJSONImpl targetObject = new StatusJSONImpl(json.getJSONObject("target_object"));
                            userStreamListener.onUnfavorite(source, target, targetObject);
                        } else if ("retweet".equals(event)) {
                            StatusJSONImpl targetObject = new StatusJSONImpl(json.getJSONObject("target_object"));
                            userStreamListener.onRetweet(source, target, targetObject);
                        } else if ("follow".equals(event)) {
                            userStreamListener.onFollow(source, target);
                        } else if ("unfollow".equals(event)) {
                            userStreamListener.onUnfollow(source, target);
                        } else if (event.startsWith("list_")) {
                            UserListJSONImpl targetObject = new UserListJSONImpl(json.getJSONObject("target_object"));
                            if ("list_user_subscribed".equals(event)) {
                                userStreamListener.onUserListSubscribed(source, target, targetObject);
                            } else if ("list_created".equals(event)) {
                                userStreamListener.onUserListCreated(source, targetObject);
                            } else if ("list_updated".equals(event)) {
                                userStreamListener.onUserListUpdated(source, targetObject);
                            } else if ("list_destroyed".equals(event)) {
                                userStreamListener.onUserListDestroyed(source, targetObject);
                            }
                        } else if ("block".equals(event)) {
                            userStreamListener.onBlock(source, target);
                        } else if ("unblock".equals(event)) {
                            userStreamListener.onUnblock(source, target);
                        } else {
                            logger.info("Received unknown event type '" + event + "': " + line);
                        }
                        break block40;
                    }
                    logger.info("Received unknown event: " + line);
                }
                catch (JSONException jsone) {
                    listener.onException(jsone);
                }
            }
            catch (IOException ioe) {
                try {
                    this.is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                this.streamAlive = false;
                throw new TwitterException("Stream closed.", ioe);
            }
        }
    }

    public void close() throws IOException {
        this.is.close();
        this.br.close();
        if (null != this.response) {
            this.response.disconnect();
        }
    }
}

