/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp;

import com.google.appengine.api.channel.ChannelServicePb;
import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.apphosting.api.ApiBasePb;
import com.google.net.rpc.DefaultStubCreationFilter;
import com.google.net.rpc.RPC;
import com.google.net.rpc.RpcCallback;
import com.google.net.rpc.RpcCancelCallback;
import com.google.net.rpc.RpcException;
import com.google.net.rpc.RpcInterface;
import com.google.net.rpc.RpcServerParameters;
import com.google.net.rpc.RpcService;
import com.google.net.rpc.RpcStub;
import com.google.net.rpc.RpcStubFactory;
import com.google.net.rpc.RpcStubParameters;
import com.google.net.rpc.StubCreationFilter;
import com.google.net.rpc.impl.ApplicationHandler;
import com.google.net.rpc.impl.BlockingApplicationHandler;
import com.google.net.rpc.impl.RpcHandlerRegistry;
import com.google.net.rpc.impl.RpcServerConfig;
import com.google.net.rpc3.impl.compatibility.Rpc1CompatibilityStub;
import com.google.net.rpc3.impl.compatibility.Rpc1HandlerRegistry;
import com.google.net.rpc3.server.RpcServer;
import com.google.net.rpc3.server.RpcServiceParameters;
import com.google.net.ssl.SslSecurityLevel;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class XMPPServicePb {
    private XMPPServicePb() {
    }

    public static final class XmppService {
        private static volatile StubCreationFilter stubCreationFilter_ = new DefaultStubCreationFilter();
        private static final RpcStubFactory stubFactory_ = new RpcStubFactory(){

            public RpcStub newRpcStub(RpcStubParameters params) {
                return new SimpleStub(stubCreationFilter_.filterStubParameters("XmppService", params));
            }
        };

        private XmppService() {
        }

        public static void setStubCreationFilter(StubCreationFilter filter) {
            stubCreationFilter_ = filter == null ? new DefaultStubCreationFilter() : filter;
        }

        public static RpcStubFactory stubFactory() {
            return stubFactory_;
        }

        public static BlockingStub newBlockingStub(RpcStubParameters params) {
            return new BlockingStub(stubCreationFilter_.filterStubParameters("XmppService", params));
        }

        public static Stub newStub(RpcStubParameters params) {
            return new Stub(stubCreationFilter_.filterStubParameters("XmppService", params));
        }

        public static ServerConfig exportService(Interface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            XmppService.exportServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportServiceUsingConfig(final Interface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "GetPresence", (ProtocolMessage)new PresenceRequest(), (ProtocolMessage)new PresenceResponse(), null, config.GetPresence_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.getPresence(rpc, (PresenceRequest)rpc.internalRequest(), (PresenceResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "SendMessage", (ProtocolMessage)new XmppMessageRequest(), (ProtocolMessage)new XmppMessageResponse(), null, config.SendMessage_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.sendMessage(rpc, (XmppMessageRequest)rpc.internalRequest(), (XmppMessageResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "SendInvite", (ProtocolMessage)new XmppInviteRequest(), (ProtocolMessage)new XmppInviteResponse(), null, config.SendInvite_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.sendInvite(rpc, (XmppInviteRequest)rpc.internalRequest(), (XmppInviteResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "SendPresence", (ProtocolMessage)new XmppSendPresenceRequest(), (ProtocolMessage)new XmppSendPresenceResponse(), null, config.SendPresence_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.sendPresence(rpc, (XmppSendPresenceRequest)rpc.internalRequest(), (XmppSendPresenceResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "CreateChannel", (ProtocolMessage)new ChannelServicePb.CreateChannelRequest(), (ProtocolMessage)new ChannelServicePb.CreateChannelResponse(), null, config.CreateChannel_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.createChannel(rpc, (ChannelServicePb.CreateChannelRequest)rpc.internalRequest(), (ChannelServicePb.CreateChannelResponse)rpc.internalResponse(), rpc.internalCallback());
                }
            });
            registry.registerHandler(config.serviceName(), "SendChannelMessage", (ProtocolMessage)new ChannelServicePb.SendMessageRequest(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.SendChannelMessage_parameters_, new ApplicationHandler(){

                public void handleRequest(RPC rpc) {
                    service.sendChannelMessage(rpc, (ChannelServicePb.SendMessageRequest)rpc.internalRequest(), (ApiBasePb.VoidProto)rpc.internalResponse(), rpc.internalCallback());
                }
            });
        }

        public static RpcService newService(final Interface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return XmppService.exportService(impl, registry);
                }
            };
        }

        public static ServerConfig exportService(Interface service, RpcServer.Builder builder) {
            ServerConfig config = new ServerConfig();
            XmppService.exportServiceUsingConfig(service, builder, config);
            return config;
        }

        public static void exportServiceUsingConfig(Interface service, RpcServer.Builder builder, ServerConfig config) {
            Rpc1HandlerRegistry registry = new Rpc1HandlerRegistry(config.serviceName());
            XmppService.exportServiceUsingConfig(service, (RpcHandlerRegistry)registry, config);
            builder.addService((RpcServiceParameters)registry);
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcHandlerRegistry registry) {
            ServerConfig config = new ServerConfig();
            XmppService.exportBlockingServiceUsingConfig(service, registry, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(final BlockingInterface service, RpcHandlerRegistry registry, ServerConfig config) {
            registry.registerHandler(config.serviceName(), "GetPresence", (ProtocolMessage)new PresenceRequest(), (ProtocolMessage)new PresenceResponse(), null, config.GetPresence_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public PresenceResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.getPresence(rpc, (PresenceRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "SendMessage", (ProtocolMessage)new XmppMessageRequest(), (ProtocolMessage)new XmppMessageResponse(), null, config.SendMessage_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public XmppMessageResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.sendMessage(rpc, (XmppMessageRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "SendInvite", (ProtocolMessage)new XmppInviteRequest(), (ProtocolMessage)new XmppInviteResponse(), null, config.SendInvite_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public XmppInviteResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.sendInvite(rpc, (XmppInviteRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "SendPresence", (ProtocolMessage)new XmppSendPresenceRequest(), (ProtocolMessage)new XmppSendPresenceResponse(), null, config.SendPresence_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public XmppSendPresenceResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.sendPresence(rpc, (XmppSendPresenceRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "CreateChannel", (ProtocolMessage)new ChannelServicePb.CreateChannelRequest(), (ProtocolMessage)new ChannelServicePb.CreateChannelResponse(), null, config.CreateChannel_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ChannelServicePb.CreateChannelResponse handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.createChannel(rpc, (ChannelServicePb.CreateChannelRequest)rpc.internalRequest());
                }
            });
            registry.registerHandler(config.serviceName(), "SendChannelMessage", (ProtocolMessage)new ChannelServicePb.SendMessageRequest(), (ProtocolMessage)new ApiBasePb.VoidProto(), null, config.SendChannelMessage_parameters_, (ApplicationHandler)new BlockingApplicationHandler(){

                public ApiBasePb.VoidProto handleBlockingRequest(RPC rpc) throws RpcException {
                    return service.sendChannelMessage(rpc, (ChannelServicePb.SendMessageRequest)rpc.internalRequest());
                }
            });
        }

        public static RpcService newBlockingService(final BlockingInterface impl) {
            return new RpcService(){

                protected RpcServerConfig export(RpcHandlerRegistry registry) {
                    return XmppService.exportBlockingService(impl, registry);
                }
            };
        }

        public static ServerConfig exportBlockingService(BlockingInterface service, RpcServer.Builder builder) {
            ServerConfig config = new ServerConfig();
            XmppService.exportBlockingServiceUsingConfig(service, builder, config);
            return config;
        }

        public static void exportBlockingServiceUsingConfig(BlockingInterface service, RpcServer.Builder builder, ServerConfig config) {
            Rpc1HandlerRegistry registry = new Rpc1HandlerRegistry(config.serviceName());
            XmppService.exportBlockingServiceUsingConfig(service, (RpcHandlerRegistry)registry, config);
            builder.addService((RpcServiceParameters)registry);
        }

        public static void unexport(RpcHandlerRegistry registry) {
            registry.unregisterService("XmppService");
        }

        public static class ServerConfig
        extends RpcServerConfig {
            final RpcServerParameters GetPresence_parameters_ = new RpcServerParameters();
            final RpcServerParameters SendMessage_parameters_ = new RpcServerParameters();
            final RpcServerParameters SendInvite_parameters_ = new RpcServerParameters();
            final RpcServerParameters SendPresence_parameters_ = new RpcServerParameters();
            final RpcServerParameters CreateChannel_parameters_ = new RpcServerParameters();
            final RpcServerParameters SendChannelMessage_parameters_ = new RpcServerParameters();

            public ServerConfig() {
                this("XmppService");
            }

            public ServerConfig(String serviceName) {
                super(serviceName);
            }

            public void setRpcRunner(Executor t) {
                this.setRpcRunner_GetPresence(t);
                this.setRpcRunner_SendMessage(t);
                this.setRpcRunner_SendInvite(t);
                this.setRpcRunner_SendPresence(t);
                this.setRpcRunner_CreateChannel(t);
                this.setRpcRunner_SendChannelMessage(t);
            }

            public void setRpcRunner_GetPresence(Executor t) {
                this.GetPresence_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_SendMessage(Executor t) {
                this.SendMessage_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_SendInvite(Executor t) {
                this.SendInvite_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_SendPresence(Executor t) {
                this.SendPresence_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_CreateChannel(Executor t) {
                this.CreateChannel_parameters_.setRpcRunner(t);
            }

            public void setRpcRunner_SendChannelMessage(Executor t) {
                this.SendChannelMessage_parameters_.setRpcRunner(t);
            }

            public void setServerLogging_GetPresence(int t) {
                this.GetPresence_parameters_.setServerLogging(t);
            }

            public void setServerLogging_SendMessage(int t) {
                this.SendMessage_parameters_.setServerLogging(t);
            }

            public void setServerLogging_SendInvite(int t) {
                this.SendInvite_parameters_.setServerLogging(t);
            }

            public void setServerLogging_SendPresence(int t) {
                this.SendPresence_parameters_.setServerLogging(t);
            }

            public void setServerLogging_CreateChannel(int t) {
                this.CreateChannel_parameters_.setServerLogging(t);
            }

            public void setServerLogging_SendChannelMessage(int t) {
                this.SendChannelMessage_parameters_.setServerLogging(t);
            }

            public void setSecurityLevel_GetPresence(SslSecurityLevel t) {
                this.GetPresence_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_SendMessage(SslSecurityLevel t) {
                this.SendMessage_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_SendInvite(SslSecurityLevel t) {
                this.SendInvite_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_SendPresence(SslSecurityLevel t) {
                this.SendPresence_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_CreateChannel(SslSecurityLevel t) {
                this.CreateChannel_parameters_.setSecurityLevel(t);
            }

            public void setSecurityLevel_SendChannelMessage(SslSecurityLevel t) {
                this.SendChannelMessage_parameters_.setSecurityLevel(t);
            }

            public void setRpcCancelCallback_GetPresence(RpcCancelCallback t) {
                this.GetPresence_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_SendMessage(RpcCancelCallback t) {
                this.SendMessage_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_SendInvite(RpcCancelCallback t) {
                this.SendInvite_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_SendPresence(RpcCancelCallback t) {
                this.SendPresence_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_CreateChannel(RpcCancelCallback t) {
                this.CreateChannel_parameters_.setRpcCancelCallback(t);
            }

            public void setRpcCancelCallback_SendChannelMessage(RpcCancelCallback t) {
                this.SendChannelMessage_parameters_.setRpcCancelCallback(t);
            }
        }

        public static class Stub
        extends BlockingStub
        implements Interface {
            Stub(RpcStubParameters params) {
                super(params);
            }

            public void getPresence(RPC rpc, PresenceRequest req, PresenceResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.GetPresence_method_, "GetPresence", req, reply, cb, this.GetPresence_parameters_);
            }

            public void sendMessage(RPC rpc, XmppMessageRequest req, XmppMessageResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.SendMessage_method_, "SendMessage", req, reply, cb, this.SendMessage_parameters_);
            }

            public void sendInvite(RPC rpc, XmppInviteRequest req, XmppInviteResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.SendInvite_method_, "SendInvite", req, reply, cb, this.SendInvite_parameters_);
            }

            public void sendPresence(RPC rpc, XmppSendPresenceRequest req, XmppSendPresenceResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.SendPresence_method_, "SendPresence", req, reply, cb, this.SendPresence_parameters_);
            }

            public void createChannel(RPC rpc, ChannelServicePb.CreateChannelRequest req, ChannelServicePb.CreateChannelResponse reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.CreateChannel_method_, "CreateChannel", req, reply, cb, this.CreateChannel_parameters_);
            }

            public void sendChannelMessage(RPC rpc, ChannelServicePb.SendMessageRequest req, ApiBasePb.VoidProto reply, RpcCallback cb) {
                this.startNonBlockingRpc(rpc, this.SendChannelMessage_method_, "SendChannelMessage", req, reply, cb, this.SendChannelMessage_parameters_);
            }
        }

        public static interface Interface
        extends RpcInterface {
            public void getPresence(RPC var1, PresenceRequest var2, PresenceResponse var3, RpcCallback var4);

            public void sendMessage(RPC var1, XmppMessageRequest var2, XmppMessageResponse var3, RpcCallback var4);

            public void sendInvite(RPC var1, XmppInviteRequest var2, XmppInviteResponse var3, RpcCallback var4);

            public void sendPresence(RPC var1, XmppSendPresenceRequest var2, XmppSendPresenceResponse var3, RpcCallback var4);

            public void createChannel(RPC var1, ChannelServicePb.CreateChannelRequest var2, ChannelServicePb.CreateChannelResponse var3, RpcCallback var4);

            public void sendChannelMessage(RPC var1, ChannelServicePb.SendMessageRequest var2, ApiBasePb.VoidProto var3, RpcCallback var4);
        }

        public static class BlockingStub
        extends BaseStub
        implements BlockingInterface {
            BlockingStub(RpcStubParameters params) {
                super(params);
            }

            public PresenceResponse getPresence(RPC rpc, PresenceRequest req) throws RpcException {
                PresenceResponse reply = new PresenceResponse();
                this.startBlockingRpc(rpc, this.GetPresence_method_, "GetPresence", req, reply, this.GetPresence_parameters_);
                return reply;
            }

            public XmppMessageResponse sendMessage(RPC rpc, XmppMessageRequest req) throws RpcException {
                XmppMessageResponse reply = new XmppMessageResponse();
                this.startBlockingRpc(rpc, this.SendMessage_method_, "SendMessage", req, reply, this.SendMessage_parameters_);
                return reply;
            }

            public XmppInviteResponse sendInvite(RPC rpc, XmppInviteRequest req) throws RpcException {
                XmppInviteResponse reply = new XmppInviteResponse();
                this.startBlockingRpc(rpc, this.SendInvite_method_, "SendInvite", req, reply, this.SendInvite_parameters_);
                return reply;
            }

            public XmppSendPresenceResponse sendPresence(RPC rpc, XmppSendPresenceRequest req) throws RpcException {
                XmppSendPresenceResponse reply = new XmppSendPresenceResponse();
                this.startBlockingRpc(rpc, this.SendPresence_method_, "SendPresence", req, reply, this.SendPresence_parameters_);
                return reply;
            }

            public ChannelServicePb.CreateChannelResponse createChannel(RPC rpc, ChannelServicePb.CreateChannelRequest req) throws RpcException {
                ChannelServicePb.CreateChannelResponse reply = new ChannelServicePb.CreateChannelResponse();
                this.startBlockingRpc(rpc, this.CreateChannel_method_, "CreateChannel", req, reply, this.CreateChannel_parameters_);
                return reply;
            }

            public ApiBasePb.VoidProto sendChannelMessage(RPC rpc, ChannelServicePb.SendMessageRequest req) throws RpcException {
                ApiBasePb.VoidProto reply = new ApiBasePb.VoidProto();
                this.startBlockingRpc(rpc, this.SendChannelMessage_method_, "SendChannelMessage", req, reply, this.SendChannelMessage_parameters_);
                return reply;
            }
        }

        public static interface BlockingInterface
        extends RpcInterface {
            public PresenceResponse getPresence(RPC var1, PresenceRequest var2) throws RpcException;

            public XmppMessageResponse sendMessage(RPC var1, XmppMessageRequest var2) throws RpcException;

            public XmppInviteResponse sendInvite(RPC var1, XmppInviteRequest var2) throws RpcException;

            public XmppSendPresenceResponse sendPresence(RPC var1, XmppSendPresenceRequest var2) throws RpcException;

            public ChannelServicePb.CreateChannelResponse createChannel(RPC var1, ChannelServicePb.CreateChannelRequest var2) throws RpcException;

            public ApiBasePb.VoidProto sendChannelMessage(RPC var1, ChannelServicePb.SendMessageRequest var2) throws RpcException;
        }

        private static class BaseStub
        extends Rpc1CompatibilityStub {
            protected final String GetPresence_method_;
            protected final RPC GetPresence_parameters_ = this.newRpcPrototype(Method.GetPresence);
            protected final String SendMessage_method_;
            protected final RPC SendMessage_parameters_ = this.newRpcPrototype(Method.SendMessage);
            protected final String SendInvite_method_;
            protected final RPC SendInvite_parameters_ = this.newRpcPrototype(Method.SendInvite);
            protected final String SendPresence_method_;
            protected final RPC SendPresence_parameters_ = this.newRpcPrototype(Method.SendPresence);
            protected final String CreateChannel_method_;
            protected final RPC CreateChannel_parameters_ = this.newRpcPrototype(Method.CreateChannel);
            protected final String SendChannelMessage_method_;
            protected final RPC SendChannelMessage_parameters_ = this.newRpcPrototype(Method.SendChannelMessage);

            protected BaseStub(RpcStubParameters params) {
                super("XmppService", params, Method.class);
                this.GetPresence_method_ = this.makeFullMethodName("GetPresence");
                this.SendMessage_method_ = this.makeFullMethodName("SendMessage");
                this.SendInvite_method_ = this.makeFullMethodName("SendInvite");
                this.SendPresence_method_ = this.makeFullMethodName("SendPresence");
                this.CreateChannel_method_ = this.makeFullMethodName("CreateChannel");
                this.SendChannelMessage_method_ = this.makeFullMethodName("SendChannelMessage");
            }
        }

        private static class SimpleStub
        extends Rpc1CompatibilityStub {
            public SimpleStub(RpcStubParameters params) {
                super("XmppService", params, Method.class);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Method {
            GetPresence,
            SendMessage,
            SendInvite,
            SendPresence,
            CreateChannel,
            SendChannelMessage;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmppInviteResponse
    extends ProtocolMessage<XmppInviteResponse> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        public static final XmppInviteResponse IMMUTABLE_DEFAULT_INSTANCE = new XmppInviteResponse(){
            private static final long serialVersionUID = 1L;

            public XmppInviteResponse mergeFrom(XmppInviteResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public XmppInviteResponse freeze() {
                return this;
            }

            public XmppInviteResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public XmppInviteResponse mergeFrom(XmppInviteResponse that) {
            assert (that != this);
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(XmppInviteResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(XmppInviteResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(XmppInviteResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof XmppInviteResponse && this.equals((XmppInviteResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = 777877264;
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        public void clear() {
            this.uninterpreted = null;
        }

        @Override
        public XmppInviteResponse newInstance() {
            return new XmppInviteResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block3;
                    }
                }
            }
            return result;
        }

        @Override
        public XmppInviteResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final XmppInviteResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        static {
            XmppInviteResponse.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            XmppInviteResponse.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(XmppInviteResponse.class, "Z&apphosting/api/xmpp/xmpp_service.proto\n\u001dapphosting.XmppInviteResponse", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmppInviteRequest
    extends ProtocolMessage<XmppInviteRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final XmppInviteRequest IMMUTABLE_DEFAULT_INSTANCE = new XmppInviteRequest(){
            private static final long serialVersionUID = 1L;

            public XmppInviteRequest clearJid() {
                return this;
            }

            public XmppInviteRequest setJidAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppInviteRequest setJid(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppInviteRequest setJid(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppInviteRequest clearFromJid() {
                return this;
            }

            public XmppInviteRequest setFromJidAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppInviteRequest setFromJid(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppInviteRequest setFromJid(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppInviteRequest mergeFrom(XmppInviteRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public XmppInviteRequest freeze() {
                return this;
            }

            public XmppInviteRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kjid = 1;
        public static final int kfrom_jid = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getJidAsBytes() {
            return this.jid_;
        }

        public final boolean hasJid() {
            return (this.optional_0_ & 1) != 0;
        }

        public XmppInviteRequest clearJid() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public XmppInviteRequest setJidAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.jid_ = x;
            return this;
        }

        public final String getJid() {
            return ProtocolSupport.toStringUtf8(this.jid_);
        }

        public XmppInviteRequest setJid(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.jid_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getJid(Charset cs) {
            return ProtocolSupport.toString(this.jid_, cs);
        }

        public XmppInviteRequest setJid(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.jid_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getFromJidAsBytes() {
            return this.from_jid_;
        }

        public final boolean hasFromJid() {
            return (this.optional_0_ & 2) != 0;
        }

        public XmppInviteRequest clearFromJid() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public XmppInviteRequest setFromJidAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.from_jid_ = x;
            return this;
        }

        public final String getFromJid() {
            return ProtocolSupport.toStringUtf8(this.from_jid_);
        }

        public XmppInviteRequest setFromJid(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.from_jid_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getFromJid(Charset cs) {
            return ProtocolSupport.toString(this.from_jid_, cs);
        }

        public XmppInviteRequest setFromJid(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.from_jid_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public XmppInviteRequest mergeFrom(XmppInviteRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.jid_ = that.jid_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.from_jid_ = that.from_jid_;
            }
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(XmppInviteRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(XmppInviteRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(XmppInviteRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.jid_, that.jid_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.from_jid_, that.from_jid_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof XmppInviteRequest && this.equals((XmppInviteRequest)that);
        }

        @Override
        public int hashCode() {
            int hash = 1179139582;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.jid_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.from_jid_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) == 1;
        }

        @Override
        public int encodingSize() {
            int n = 1 + Protocol.stringSize(this.jid_.length);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                n += 1 + Protocol.stringSize(this.from_jid_.length);
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 6 + this.jid_.length;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                n += 6 + this.from_jid_.length;
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public XmppInviteRequest newInstance() {
            return new XmppInviteRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.jid_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)18);
                sink.putPrefixedData(this.from_jid_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        this.jid_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 18: {
                        this.from_jid_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public XmppInviteRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final XmppInviteRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public XmppInviteRequest freeze() {
            this.jid_ = ProtocolSupport.freezeString(this.jid_);
            this.from_jid_ = ProtocolSupport.freezeString(this.from_jid_);
            return this;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        static {
            XmppInviteRequest.text[0] = "ErrorCode";
            XmppInviteRequest.text[1] = "jid";
            XmppInviteRequest.text[2] = "from_jid";
            types = new int[3];
            Arrays.fill(types, 6);
            XmppInviteRequest.types[0] = 0;
            XmppInviteRequest.types[1] = 2;
            XmppInviteRequest.types[2] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(XmppInviteRequest.class, "Z&apphosting/api/xmpp/xmpp_service.proto\n\u001capphosting.XmppInviteRequest\u0013\u001a\u0003jid \u0001(\u00020\t8\u0002\u0014\u0013\u001a\bfrom_jid \u0002(\u00020\t8\u0001\u0014", new ProtocolType.FieldType("jid", "jid", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("from_jid", "from_jid", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmppSendPresenceResponse
    extends ProtocolMessage<XmppSendPresenceResponse> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        public static final XmppSendPresenceResponse IMMUTABLE_DEFAULT_INSTANCE = new XmppSendPresenceResponse(){
            private static final long serialVersionUID = 1L;

            public XmppSendPresenceResponse mergeFrom(XmppSendPresenceResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public XmppSendPresenceResponse freeze() {
                return this;
            }

            public XmppSendPresenceResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public XmppSendPresenceResponse mergeFrom(XmppSendPresenceResponse that) {
            assert (that != this);
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(XmppSendPresenceResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(XmppSendPresenceResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(XmppSendPresenceResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof XmppSendPresenceResponse && this.equals((XmppSendPresenceResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = -185513675;
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        public void clear() {
            this.uninterpreted = null;
        }

        @Override
        public XmppSendPresenceResponse newInstance() {
            return new XmppSendPresenceResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block3;
                    }
                }
            }
            return result;
        }

        @Override
        public XmppSendPresenceResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final XmppSendPresenceResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        static {
            XmppSendPresenceResponse.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            XmppSendPresenceResponse.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(XmppSendPresenceResponse.class, "Z&apphosting/api/xmpp/xmpp_service.proto\n#apphosting.XmppSendPresenceResponse", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmppSendPresenceRequest
    extends ProtocolMessage<XmppSendPresenceRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] show_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] status_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final XmppSendPresenceRequest IMMUTABLE_DEFAULT_INSTANCE = new XmppSendPresenceRequest(){
            private static final long serialVersionUID = 1L;

            public XmppSendPresenceRequest clearJid() {
                return this;
            }

            public XmppSendPresenceRequest setJidAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setJid(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setJid(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest clearType() {
                return this;
            }

            public XmppSendPresenceRequest setTypeAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setType(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setType(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest clearShow() {
                return this;
            }

            public XmppSendPresenceRequest setShowAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setShow(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setShow(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest clearStatus() {
                return this;
            }

            public XmppSendPresenceRequest setStatusAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setStatus(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setStatus(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest clearFromJid() {
                return this;
            }

            public XmppSendPresenceRequest setFromJidAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setFromJid(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest setFromJid(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppSendPresenceRequest mergeFrom(XmppSendPresenceRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public XmppSendPresenceRequest freeze() {
                return this;
            }

            public XmppSendPresenceRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kjid = 1;
        public static final int ktype = 2;
        public static final int kshow = 3;
        public static final int kstatus = 4;
        public static final int kfrom_jid = 5;
        public static final String[] text = new String[6];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getJidAsBytes() {
            return this.jid_;
        }

        public final boolean hasJid() {
            return (this.optional_0_ & 1) != 0;
        }

        public XmppSendPresenceRequest clearJid() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public XmppSendPresenceRequest setJidAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.jid_ = x;
            return this;
        }

        public final String getJid() {
            return ProtocolSupport.toStringUtf8(this.jid_);
        }

        public XmppSendPresenceRequest setJid(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.jid_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getJid(Charset cs) {
            return ProtocolSupport.toString(this.jid_, cs);
        }

        public XmppSendPresenceRequest setJid(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.jid_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getTypeAsBytes() {
            return this.type_;
        }

        public final boolean hasType() {
            return (this.optional_0_ & 2) != 0;
        }

        public XmppSendPresenceRequest clearType() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public XmppSendPresenceRequest setTypeAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.type_ = x;
            return this;
        }

        public final String getType() {
            return ProtocolSupport.toStringUtf8(this.type_);
        }

        public XmppSendPresenceRequest setType(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.type_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getType(Charset cs) {
            return ProtocolSupport.toString(this.type_, cs);
        }

        public XmppSendPresenceRequest setType(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.type_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getShowAsBytes() {
            return this.show_;
        }

        public final boolean hasShow() {
            return (this.optional_0_ & 4) != 0;
        }

        public XmppSendPresenceRequest clearShow() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.show_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public XmppSendPresenceRequest setShowAsBytes(byte[] x) {
            this.optional_0_ |= 4;
            this.show_ = x;
            return this;
        }

        public final String getShow() {
            return ProtocolSupport.toStringUtf8(this.show_);
        }

        public XmppSendPresenceRequest setShow(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.show_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getShow(Charset cs) {
            return ProtocolSupport.toString(this.show_, cs);
        }

        public XmppSendPresenceRequest setShow(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.show_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getStatusAsBytes() {
            return this.status_;
        }

        public final boolean hasStatus() {
            return (this.optional_0_ & 8) != 0;
        }

        public XmppSendPresenceRequest clearStatus() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.status_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public XmppSendPresenceRequest setStatusAsBytes(byte[] x) {
            this.optional_0_ |= 8;
            this.status_ = x;
            return this;
        }

        public final String getStatus() {
            return ProtocolSupport.toStringUtf8(this.status_);
        }

        public XmppSendPresenceRequest setStatus(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.status_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getStatus(Charset cs) {
            return ProtocolSupport.toString(this.status_, cs);
        }

        public XmppSendPresenceRequest setStatus(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.status_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getFromJidAsBytes() {
            return this.from_jid_;
        }

        public final boolean hasFromJid() {
            return (this.optional_0_ & 0x10) != 0;
        }

        public XmppSendPresenceRequest clearFromJid() {
            this.optional_0_ &= 0xFFFFFFEF;
            this.from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public XmppSendPresenceRequest setFromJidAsBytes(byte[] x) {
            this.optional_0_ |= 0x10;
            this.from_jid_ = x;
            return this;
        }

        public final String getFromJid() {
            return ProtocolSupport.toStringUtf8(this.from_jid_);
        }

        public XmppSendPresenceRequest setFromJid(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.from_jid_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getFromJid(Charset cs) {
            return ProtocolSupport.toString(this.from_jid_, cs);
        }

        public XmppSendPresenceRequest setFromJid(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 0x10;
            this.from_jid_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public XmppSendPresenceRequest mergeFrom(XmppSendPresenceRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.jid_ = that.jid_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.type_ = that.type_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.show_ = that.show_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.status_ = that.status_;
            }
            if ((that_t0 & 0x10) != 0) {
                this_t0 |= 0x10;
                this.from_jid_ = that.from_jid_;
            }
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(XmppSendPresenceRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(XmppSendPresenceRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(XmppSendPresenceRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.jid_, that.jid_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.type_, that.type_)) {
                return false;
            }
            if ((this_t0 & 4) != 0 && !Arrays.equals(this.show_, that.show_)) {
                return false;
            }
            if ((this_t0 & 8) != 0 && !Arrays.equals(this.status_, that.status_)) {
                return false;
            }
            if ((this_t0 & 0x10) != 0 && !Arrays.equals(this.from_jid_, that.from_jid_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof XmppSendPresenceRequest && this.equals((XmppSendPresenceRequest)that);
        }

        @Override
        public int hashCode() {
            int hash = 650409308;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.jid_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.type_) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? Arrays.hashCode(this.show_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? Arrays.hashCode(this.status_) : -113);
            hash = hash * 31 + ((this_t0 & 0x10) != 0 ? Arrays.hashCode(this.from_jid_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) == 1;
        }

        @Override
        public int encodingSize() {
            int n = 1 + Protocol.stringSize(this.jid_.length);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x1E) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 1 + Protocol.stringSize(this.type_.length);
                }
                if ((this_t0 & 4) != 0) {
                    n += 1 + Protocol.stringSize(this.show_.length);
                }
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.stringSize(this.status_.length);
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 1 + Protocol.stringSize(this.from_jid_.length);
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 6 + this.jid_.length;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0x1E) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 6 + this.type_.length;
                }
                if ((this_t0 & 4) != 0) {
                    n += 6 + this.show_.length;
                }
                if ((this_t0 & 8) != 0) {
                    n += 6 + this.status_.length;
                }
                if ((this_t0 & 0x10) != 0) {
                    n += 6 + this.from_jid_.length;
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.type_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.show_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.status_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public XmppSendPresenceRequest newInstance() {
            return new XmppSendPresenceRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.jid_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)18);
                sink.putPrefixedData(this.type_);
            }
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)26);
                sink.putPrefixedData(this.show_);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)34);
                sink.putPrefixedData(this.status_);
            }
            if ((this_t0 & 0x10) != 0) {
                sink.putByte((byte)42);
                sink.putPrefixedData(this.from_jid_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block8: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block8;
                    }
                    case 10: {
                        this.jid_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block8;
                    }
                    case 18: {
                        this.type_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block8;
                    }
                    case 26: {
                        this.show_ = source.getPrefixedData();
                        this_t0 |= 4;
                        continue block8;
                    }
                    case 34: {
                        this.status_ = source.getPrefixedData();
                        this_t0 |= 8;
                        continue block8;
                    }
                    case 42: {
                        this.from_jid_ = source.getPrefixedData();
                        this_t0 |= 0x10;
                        continue block8;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block8;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public XmppSendPresenceRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final XmppSendPresenceRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public XmppSendPresenceRequest freeze() {
            this.jid_ = ProtocolSupport.freezeString(this.jid_);
            this.type_ = ProtocolSupport.freezeString(this.type_);
            this.show_ = ProtocolSupport.freezeString(this.show_);
            this.status_ = ProtocolSupport.freezeString(this.status_);
            this.from_jid_ = ProtocolSupport.freezeString(this.from_jid_);
            return this;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        static {
            XmppSendPresenceRequest.text[0] = "ErrorCode";
            XmppSendPresenceRequest.text[1] = "jid";
            XmppSendPresenceRequest.text[2] = "type";
            XmppSendPresenceRequest.text[3] = "show";
            XmppSendPresenceRequest.text[4] = "status";
            XmppSendPresenceRequest.text[5] = "from_jid";
            types = new int[6];
            Arrays.fill(types, 6);
            XmppSendPresenceRequest.types[0] = 0;
            XmppSendPresenceRequest.types[1] = 2;
            XmppSendPresenceRequest.types[2] = 2;
            XmppSendPresenceRequest.types[3] = 2;
            XmppSendPresenceRequest.types[4] = 2;
            XmppSendPresenceRequest.types[5] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(XmppSendPresenceRequest.class, "Z&apphosting/api/xmpp/xmpp_service.proto\n\"apphosting.XmppSendPresenceRequest\u0013\u001a\u0003jid \u0001(\u00020\t8\u0002\u0014\u0013\u001a\u0004type \u0002(\u00020\t8\u0001\u0014\u0013\u001a\u0004show \u0003(\u00020\t8\u0001\u0014\u0013\u001a\u0006status \u0004(\u00020\t8\u0001\u0014\u0013\u001a\bfrom_jid \u0005(\u00020\t8\u0001\u0014", new ProtocolType.FieldType("jid", "jid", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("type", "type", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("show", "show", 3, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("status", "status", 4, 3, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("from_jid", "from_jid", 5, 4, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmppMessageResponse
    extends ProtocolMessage<XmppMessageResponse> {
        private static final long serialVersionUID = 1L;
        private int[] status_ = ProtocolSupport.EMPTY_INT_ARRAY;
        private int status_elts_;
        private UninterpretedTags uninterpreted;
        public static final XmppMessageResponse IMMUTABLE_DEFAULT_INSTANCE = new XmppMessageResponse(){
            private static final long serialVersionUID = 1L;

            public XmppMessageResponse clearStatus() {
                return this;
            }

            public XmppMessageResponse setStatus(int i, int v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageResponse addStatus(int v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageResponse mergeFrom(XmppMessageResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public XmppMessageResponse freeze() {
                return this;
            }

            public XmppMessageResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kstatus = 1;
        public static final String[] text = new String[2];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int statusSize() {
            return this.status_elts_;
        }

        public final int getStatus(int i) {
            assert (i >= 0 && i < this.status_elts_);
            return this.status_[i];
        }

        public XmppMessageResponse clearStatus() {
            this.status_elts_ = 0;
            this.status_ = ProtocolSupport.EMPTY_INT_ARRAY;
            return this;
        }

        public XmppMessageResponse setStatus(int i, int v) {
            assert (i >= 0 && i < this.status_elts_);
            this.status_[i] = v;
            return this;
        }

        public XmppMessageResponse addStatus(int v) {
            if (this.status_elts_ == this.status_.length) {
                this.status_ = ProtocolSupport.growArray(this.status_);
            }
            this.status_[this.status_elts_++] = v;
            return this;
        }

        public final Iterator<Integer> statusIterator() {
            return ProtocolSupport.asList(this.status_, 0, this.status_elts_).iterator();
        }

        public final List<Integer> statuss() {
            return ProtocolSupport.asList(this.status_, 0, this.status_elts_);
        }

        public final List<Integer> mutableStatuss() {
            return new AbstractList<Integer>(){

                @Override
                public int size() {
                    return XmppMessageResponse.this.status_elts_;
                }

                @Override
                public Integer get(int i) {
                    if (i < 0 || i >= this.size()) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    return XmppMessageResponse.this.status_[i];
                }

                @Override
                public Integer set(int i, Integer elt) {
                    Integer result = this.get(i);
                    XmppMessageResponse.this.setStatus(i, elt);
                    return result;
                }

                @Override
                public boolean add(Integer elt) {
                    XmppMessageResponse.this.addStatus(elt);
                    return true;
                }

                @Override
                public Integer remove(int i) {
                    if (i < 0 || i >= this.size()) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    Integer result = this.get(i);
                    for (int j = i + 1; j < this.size(); ++j) {
                        ((XmppMessageResponse)XmppMessageResponse.this).status_[j - 1] = XmppMessageResponse.this.status_[j];
                    }
                    XmppMessageResponse.this.status_elts_--;
                    return result;
                }

                @Override
                public void clear() {
                    XmppMessageResponse.this.status_elts_ = 0;
                }
            };
        }

        @Override
        public XmppMessageResponse mergeFrom(XmppMessageResponse that) {
            assert (that != this);
            if (that.status_elts_ > 0) {
                this.status_ = ProtocolSupport.ensureCapacity(this.status_, this.status_elts_ + that.status_elts_);
                System.arraycopy(that.status_, 0, this.status_, this.status_elts_, that.status_elts_);
                this.status_elts_ += that.status_elts_;
            }
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(XmppMessageResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(XmppMessageResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(XmppMessageResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int n = this.status_elts_;
            if (n != that.status_elts_) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.status_[i] == that.status_[i]) continue;
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof XmppMessageResponse && this.equals((XmppMessageResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = -21064635;
            hash *= 31;
            int n = this.status_elts_;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + this.status_[i];
            }
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            int m = this.status_elts_;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.varLongSize(this.status_[i]);
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : (n += 11 * this.status_elts_);
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        public void clear() {
            this.status_elts_ = 0;
            this.status_ = ProtocolSupport.EMPTY_INT_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public XmppMessageResponse newInstance() {
            return new XmppMessageResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m = this.status_elts_;
            for (int i = 0; i < m; ++i) {
                int v = this.status_[i];
                sink.putByte((byte)8);
                sink.putVarLong(v);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block4: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block4;
                    }
                    case 8: {
                        this.addStatus(source.getVarInt());
                        continue block4;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block4;
                    }
                }
            }
            return result;
        }

        @Override
        public XmppMessageResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final XmppMessageResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public XmppMessageResponse freeze() {
            this.status_ = ProtocolSupport.freezeArray(this.status_, this.status_elts_);
            return this;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        static {
            XmppMessageResponse.text[0] = "ErrorCode";
            XmppMessageResponse.text[1] = "status";
            types = new int[2];
            Arrays.fill(types, 6);
            XmppMessageResponse.types[0] = 0;
            XmppMessageResponse.types[1] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(XmppMessageResponse.class, "Z&apphosting/api/xmpp/xmpp_service.proto\n\u001eapphosting.XmppMessageResponse\u0013\u001a\u0006status \u0001(\u00000\u00058\u0003h\u0000\u0014sz\u0011XmppMessageStatus\u008b\u0001\u0092\u0001\bNO_ERROR\u0098\u0001\u0000\u008c\u0001\u008b\u0001\u0092\u0001\u000bINVALID_JID\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u000bOTHER_ERROR\u0098\u0001\u0002\u008c\u0001t", new ProtocolType.FieldType("status", "status", 1, -1, ProtocolType.Presence.REPEATED, XmppMessageStatus.class));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum XmppMessageStatus implements ProtocolMessageEnum
        {
            NO_ERROR(0),
            INVALID_JID(1),
            OTHER_ERROR(2);

            public static final XmppMessageStatus XmppMessageStatus_MIN;
            public static final XmppMessageStatus XmppMessageStatus_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static XmppMessageStatus valueOf(int value) {
                switch (value) {
                    case 0: {
                        return NO_ERROR;
                    }
                    case 1: {
                        return INVALID_JID;
                    }
                    case 2: {
                        return OTHER_ERROR;
                    }
                }
                return null;
            }

            private XmppMessageStatus(int v) {
                this.value = v;
            }

            static {
                XmppMessageStatus_MIN = NO_ERROR;
                XmppMessageStatus_MAX = OTHER_ERROR;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmppMessageRequest
    extends ProtocolMessage<XmppMessageRequest> {
        private static final long serialVersionUID = 1L;
        private List<byte[]> jid_ = null;
        private byte[] body_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private boolean raw_xml_ = false;
        private static final byte[] type_DEFAULT_ = new byte[]{99, 104, 97, 116};
        private byte[] type_ = type_DEFAULT_;
        private byte[] from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final XmppMessageRequest IMMUTABLE_DEFAULT_INSTANCE = new XmppMessageRequest(){
            private static final long serialVersionUID = 1L;

            public XmppMessageRequest clearJid() {
                return this;
            }

            public XmppMessageRequest setJidAsBytes(int i, byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest setJid(int i, String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest addJidAsBytes(byte[] v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest addJid(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest setJid(int i, String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest addJid(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest clearBody() {
                return this;
            }

            public XmppMessageRequest setBodyAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest setBody(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest setBody(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest clearRawXml() {
                return this;
            }

            public XmppMessageRequest setRawXml(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest clearType() {
                return this;
            }

            public XmppMessageRequest setTypeAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest setType(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest setType(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest clearFromJid() {
                return this;
            }

            public XmppMessageRequest setFromJidAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest setFromJid(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest setFromJid(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public XmppMessageRequest mergeFrom(XmppMessageRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public XmppMessageRequest freeze() {
                return this;
            }

            public XmppMessageRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kjid = 1;
        public static final int kbody = 2;
        public static final int kraw_xml = 3;
        public static final int ktype = 4;
        public static final int kfrom_jid = 5;
        public static final String[] text = new String[6];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final int jidSize() {
            return this.jid_ != null ? this.jid_.size() : 0;
        }

        public final byte[] getJidAsBytes(int i) {
            assert (i >= 0 && i < (this.jid_ != null ? this.jid_.size() : 0));
            return this.jid_.get(i);
        }

        public XmppMessageRequest clearJid() {
            if (this.jid_ != null) {
                this.jid_.clear();
            }
            return this;
        }

        public final String getJid(int i) {
            return ProtocolSupport.toStringUtf8(this.jid_.get(i));
        }

        public XmppMessageRequest setJidAsBytes(int i, byte[] v) {
            this.jid_.set(i, v);
            return this;
        }

        public XmppMessageRequest setJid(int i, String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.jid_.set(i, ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public XmppMessageRequest addJidAsBytes(byte[] v) {
            if (this.jid_ == null) {
                this.jid_ = new ArrayList<byte[]>(4);
            }
            this.jid_.add(v);
            return this;
        }

        public XmppMessageRequest addJid(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.jid_ == null) {
                this.jid_ = new ArrayList<byte[]>(4);
            }
            this.jid_.add(ProtocolSupport.toBytesUtf8(v));
            return this;
        }

        public final Iterator<String> jidIterator() {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.jid_);
        }

        public final List<String> jids() {
            return ProtocolSupport.byteArrayToUnicodeList(this.jid_);
        }

        public final Iterator<byte[]> jidAsBytesIterator() {
            return this.jid_ == null ? ProtocolSupport.emptyIterator() : this.jid_.iterator();
        }

        public final List<byte[]> jidsAsBytes() {
            return ProtocolSupport.unmodifiableList(this.jid_);
        }

        public final List<byte[]> mutableJidsAsBytes() {
            if (this.jid_ == null) {
                this.jid_ = new ArrayList<byte[]>(4);
            }
            return this.jid_;
        }

        public final String getJid(int i, Charset cs) {
            return ProtocolSupport.toString(this.jid_.get(i), cs);
        }

        public XmppMessageRequest setJid(int i, String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.jid_.set(i, ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public XmppMessageRequest addJid(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            if (this.jid_ == null) {
                this.jid_ = new ArrayList<byte[]>(4);
            }
            this.jid_.add(ProtocolSupport.toBytes(v, cs));
            return this;
        }

        public final Iterator<String> jidIterator(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeIterator(this.jid_, cs);
        }

        public final List<String> jids(Charset cs) {
            return ProtocolSupport.byteArrayToUnicodeList(this.jid_, cs);
        }

        public final byte[] getBodyAsBytes() {
            return this.body_;
        }

        public final boolean hasBody() {
            return (this.optional_0_ & 1) != 0;
        }

        public XmppMessageRequest clearBody() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.body_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public XmppMessageRequest setBodyAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.body_ = x;
            return this;
        }

        public final String getBody() {
            return ProtocolSupport.toStringUtf8(this.body_);
        }

        public XmppMessageRequest setBody(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.body_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getBody(Charset cs) {
            return ProtocolSupport.toString(this.body_, cs);
        }

        public XmppMessageRequest setBody(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.body_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final boolean isRawXml() {
            return this.raw_xml_;
        }

        public final boolean hasRawXml() {
            return (this.optional_0_ & 2) != 0;
        }

        public XmppMessageRequest clearRawXml() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.raw_xml_ = false;
            return this;
        }

        public XmppMessageRequest setRawXml(boolean x) {
            this.optional_0_ |= 2;
            this.raw_xml_ = x;
            return this;
        }

        public final byte[] getTypeAsBytes() {
            return this.type_;
        }

        public final boolean hasType() {
            return (this.optional_0_ & 4) != 0;
        }

        public XmppMessageRequest clearType() {
            this.optional_0_ &= 0xFFFFFFFB;
            this.type_ = (byte[])type_DEFAULT_.clone();
            return this;
        }

        public XmppMessageRequest setTypeAsBytes(byte[] x) {
            this.optional_0_ |= 4;
            this.type_ = x;
            return this;
        }

        public final String getType() {
            return ProtocolSupport.toStringUtf8(this.type_);
        }

        public XmppMessageRequest setType(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.type_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getType(Charset cs) {
            return ProtocolSupport.toString(this.type_, cs);
        }

        public XmppMessageRequest setType(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 4;
            this.type_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getFromJidAsBytes() {
            return this.from_jid_;
        }

        public final boolean hasFromJid() {
            return (this.optional_0_ & 8) != 0;
        }

        public XmppMessageRequest clearFromJid() {
            this.optional_0_ &= 0xFFFFFFF7;
            this.from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public XmppMessageRequest setFromJidAsBytes(byte[] x) {
            this.optional_0_ |= 8;
            this.from_jid_ = x;
            return this;
        }

        public final String getFromJid() {
            return ProtocolSupport.toStringUtf8(this.from_jid_);
        }

        public XmppMessageRequest setFromJid(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.from_jid_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getFromJid(Charset cs) {
            return ProtocolSupport.toString(this.from_jid_, cs);
        }

        public XmppMessageRequest setFromJid(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 8;
            this.from_jid_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public XmppMessageRequest mergeFrom(XmppMessageRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (that.jid_ != null && that.jid_.size() > 0) {
                if (this.jid_ == null) {
                    this.jid_ = new ArrayList<byte[]>(that.jid_);
                } else {
                    this.jid_.addAll(that.jid_);
                }
            }
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.body_ = that.body_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.raw_xml_ = that.raw_xml_;
            }
            if ((that_t0 & 4) != 0) {
                this_t0 |= 4;
                this.type_ = that.type_;
            }
            if ((that_t0 & 8) != 0) {
                this_t0 |= 8;
                this.from_jid_ = that.from_jid_;
            }
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(XmppMessageRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(XmppMessageRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(XmppMessageRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            int n = this.jid_ != null ? this.jid_.size() : 0;
            if (n != (that.jid_ != null ? that.jid_.size() : 0)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Arrays.equals(this.jid_.get(i), that.jid_.get(i))) continue;
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.body_, that.body_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.raw_xml_ != that.raw_xml_) {
                return false;
            }
            if ((this_t0 & 4) != 0 && !Arrays.equals(this.type_, that.type_)) {
                return false;
            }
            if ((this_t0 & 8) != 0 && !Arrays.equals(this.from_jid_, that.from_jid_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof XmppMessageRequest && this.equals((XmppMessageRequest)that);
        }

        @Override
        public int hashCode() {
            int n;
            int hash = -1032797480;
            hash *= 31;
            int n2 = n = this.jid_ != null ? this.jid_.size() : 0;
            for (int i = 0; i < n; ++i) {
                hash = hash * 31 + Arrays.hashCode(this.jid_.get(i));
            }
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.body_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? (this.raw_xml_ ? 1231 : 1237) : -113);
            hash = hash * 31 + ((this_t0 & 4) != 0 ? Arrays.hashCode(this.type_) : -113);
            hash = hash * 31 + ((this_t0 & 8) != 0 ? Arrays.hashCode(this.from_jid_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) == 1;
        }

        @Override
        public int encodingSize() {
            int n = 1 + Protocol.stringSize(this.body_.length);
            int m = this.jid_ != null ? this.jid_.size() : 0;
            n += m;
            for (int i = 0; i < m; ++i) {
                n += Protocol.stringSize(this.jid_.get(i).length);
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0xE) != 0) {
                if ((this_t0 & 2) != 0) {
                    n += 2;
                }
                if ((this_t0 & 4) != 0) {
                    n += 1 + Protocol.stringSize(this.type_.length);
                }
                if ((this_t0 & 8) != 0) {
                    n += 1 + Protocol.stringSize(this.from_jid_.length);
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 8 + this.body_.length;
            int m = this.jid_ != null ? this.jid_.size() : 0;
            n += 6 * m;
            for (int i = 0; i < m; ++i) {
                n += this.jid_.get(i).length;
            }
            int this_t0 = this.optional_0_;
            if ((this_t0 & 0xC) != 0) {
                if ((this_t0 & 4) != 0) {
                    n += 6 + this.type_.length;
                }
                if ((this_t0 & 8) != 0) {
                    n += 6 + this.from_jid_.length;
                }
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            if (this.jid_ != null) {
                this.jid_.clear();
            }
            this.body_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.raw_xml_ = false;
            this.type_ = (byte[])type_DEFAULT_.clone();
            this.from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public XmppMessageRequest newInstance() {
            return new XmppMessageRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            int m;
            int n = m = this.jid_ != null ? this.jid_.size() : 0;
            for (int i = 0; i < m; ++i) {
                byte[] v = this.jid_.get(i);
                sink.putByte((byte)10);
                sink.putPrefixedData(v);
            }
            sink.putByte((byte)18);
            sink.putPrefixedData(this.body_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)24);
                sink.putBoolean(this.raw_xml_);
            }
            if ((this_t0 & 4) != 0) {
                sink.putByte((byte)34);
                sink.putPrefixedData(this.type_);
            }
            if ((this_t0 & 8) != 0) {
                sink.putByte((byte)42);
                sink.putPrefixedData(this.from_jid_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block8: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block8;
                    }
                    case 10: {
                        this.addJidAsBytes(source.getPrefixedData());
                        continue block8;
                    }
                    case 18: {
                        this.body_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block8;
                    }
                    case 24: {
                        this.raw_xml_ = source.getBoolean();
                        this_t0 |= 2;
                        continue block8;
                    }
                    case 34: {
                        this.type_ = source.getPrefixedData();
                        this_t0 |= 4;
                        continue block8;
                    }
                    case 42: {
                        this.from_jid_ = source.getPrefixedData();
                        this_t0 |= 8;
                        continue block8;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block8;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public XmppMessageRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final XmppMessageRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public XmppMessageRequest freeze() {
            this.jid_ = ProtocolSupport.freezeStrings(this.jid_);
            this.body_ = ProtocolSupport.freezeString(this.body_);
            this.type_ = ProtocolSupport.freezeString(this.type_);
            this.from_jid_ = ProtocolSupport.freezeString(this.from_jid_);
            return this;
        }

        @Override
        public XmppMessageRequest unfreeze() {
            this.jid_ = ProtocolSupport.unfreezeStrings(this.jid_);
            return this;
        }

        @Override
        public boolean isFrozen() {
            return ProtocolSupport.isFrozenStrings(this.jid_);
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        static {
            XmppMessageRequest.text[0] = "ErrorCode";
            XmppMessageRequest.text[1] = "jid";
            XmppMessageRequest.text[2] = "body";
            XmppMessageRequest.text[3] = "raw_xml";
            XmppMessageRequest.text[4] = "type";
            XmppMessageRequest.text[5] = "from_jid";
            types = new int[6];
            Arrays.fill(types, 6);
            XmppMessageRequest.types[0] = 0;
            XmppMessageRequest.types[1] = 2;
            XmppMessageRequest.types[2] = 2;
            XmppMessageRequest.types[3] = 0;
            XmppMessageRequest.types[4] = 2;
            XmppMessageRequest.types[5] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(XmppMessageRequest.class, "Z&apphosting/api/xmpp/xmpp_service.proto\n\u001dapphosting.XmppMessageRequest\u0013\u001a\u0003jid \u0001(\u00020\t8\u0003\u0014\u0013\u001a\u0004body \u0002(\u00020\t8\u0002\u0014\u0013\u001a\u0007raw_xml \u0003(\u00000\b8\u0001B\u0005false\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0005false\u00a4\u0001\u0014\u0013\u001a\u0004type \u0004(\u00020\t8\u0001B\u0004chat\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0006\"chat\"\u00a4\u0001\u0014\u0013\u001a\bfrom_jid \u0005(\u00020\t8\u0001\u0014", new ProtocolType.FieldType("jid", "jid", 1, -1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REPEATED), new ProtocolType.FieldType("body", "body", 2, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("raw_xml", "raw_xml", 3, 1, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("type", "type", 4, 2, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL), new ProtocolType.FieldType("from_jid", "from_jid", 5, 3, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PresenceResponse
    extends ProtocolMessage<PresenceResponse> {
        private static final long serialVersionUID = 1L;
        private boolean is_available_ = false;
        private int presence_ = 0;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final PresenceResponse IMMUTABLE_DEFAULT_INSTANCE = new PresenceResponse(){
            private static final long serialVersionUID = 1L;

            public PresenceResponse clearIsAvailable() {
                return this;
            }

            public PresenceResponse setIsAvailable(boolean x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public PresenceResponse clearPresence() {
                return this;
            }

            public PresenceResponse setPresence(int x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public PresenceResponse mergeFrom(PresenceResponse that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public PresenceResponse freeze() {
                return this;
            }

            public PresenceResponse unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kis_available = 1;
        public static final int kpresence = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final boolean isIsAvailable() {
            return this.is_available_;
        }

        public final boolean hasIsAvailable() {
            return (this.optional_0_ & 1) != 0;
        }

        public PresenceResponse clearIsAvailable() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.is_available_ = false;
            return this;
        }

        public PresenceResponse setIsAvailable(boolean x) {
            this.optional_0_ |= 1;
            this.is_available_ = x;
            return this;
        }

        public final int getPresence() {
            return this.presence_;
        }

        public SHOW getPresenceEnum() {
            return SHOW.valueOf(this.getPresence());
        }

        public final boolean hasPresence() {
            return (this.optional_0_ & 2) != 0;
        }

        public PresenceResponse clearPresence() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.presence_ = 0;
            return this;
        }

        public PresenceResponse setPresence(int x) {
            this.optional_0_ |= 2;
            this.presence_ = x;
            return this;
        }

        public PresenceResponse setPresence(SHOW x) {
            if (x == null) {
                this.optional_0_ &= 0xFFFFFFFD;
                this.presence_ = 0;
            } else {
                this.setPresence(x.getValue());
            }
            return this;
        }

        @Override
        public PresenceResponse mergeFrom(PresenceResponse that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.is_available_ = that.is_available_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.presence_ = that.presence_;
            }
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(PresenceResponse that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(PresenceResponse that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(PresenceResponse that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && this.is_available_ != that.is_available_) {
                return false;
            }
            if ((this_t0 & 2) != 0 && this.presence_ != that.presence_) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof PresenceResponse && this.equals((PresenceResponse)that);
        }

        @Override
        public int hashCode() {
            int hash = 384658789;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? (this.is_available_ ? 1231 : 1237) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? this.presence_ : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) == 1;
        }

        @Override
        public int encodingSize() {
            int n = 2;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                n += 1 + Protocol.varLongSize(this.presence_);
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 13;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.is_available_ = false;
            this.presence_ = 0;
            this.uninterpreted = null;
        }

        @Override
        public PresenceResponse newInstance() {
            return new PresenceResponse();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)8);
            sink.putBoolean(this.is_available_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)16);
                sink.putVarLong(this.presence_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 8: {
                        this.is_available_ = source.getBoolean();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 16: {
                        this.presence_ = source.getVarInt();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public PresenceResponse getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final PresenceResponse getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        static {
            PresenceResponse.text[0] = "ErrorCode";
            PresenceResponse.text[1] = "is_available";
            PresenceResponse.text[2] = "presence";
            types = new int[3];
            Arrays.fill(types, 6);
            PresenceResponse.types[0] = 0;
            PresenceResponse.types[1] = 0;
            PresenceResponse.types[2] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(PresenceResponse.class, "Z&apphosting/api/xmpp/xmpp_service.proto\n\u001bapphosting.PresenceResponse\u0013\u001a\fis_available \u0001(\u00000\b8\u0002\u0014\u0013\u001a\bpresence \u0002(\u00000\u00058\u0001h\u0000\u0014sz\u0004SHOW\u008b\u0001\u0092\u0001\u0006NORMAL\u0098\u0001\u0000\u008c\u0001\u008b\u0001\u0092\u0001\u0004AWAY\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u000eDO_NOT_DISTURB\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0004CHAT\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\rEXTENDED_AWAY\u0098\u0001\u0004\u008c\u0001t", new ProtocolType.FieldType("is_available", "is_available", 1, 0, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("presence", "presence", 2, 1, ProtocolType.Presence.OPTIONAL, SHOW.class));

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SHOW implements ProtocolMessageEnum
        {
            NORMAL(0),
            AWAY(1),
            DO_NOT_DISTURB(2),
            CHAT(3),
            EXTENDED_AWAY(4);

            public static final SHOW SHOW_MIN;
            public static final SHOW SHOW_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static SHOW valueOf(int value) {
                switch (value) {
                    case 0: {
                        return NORMAL;
                    }
                    case 1: {
                        return AWAY;
                    }
                    case 2: {
                        return DO_NOT_DISTURB;
                    }
                    case 3: {
                        return CHAT;
                    }
                    case 4: {
                        return EXTENDED_AWAY;
                    }
                }
                return null;
            }

            private SHOW(int v) {
                this.value = v;
            }

            static {
                SHOW_MIN = NORMAL;
                SHOW_MAX = EXTENDED_AWAY;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PresenceRequest
    extends ProtocolMessage<PresenceRequest> {
        private static final long serialVersionUID = 1L;
        private byte[] jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private byte[] from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        private UninterpretedTags uninterpreted;
        private int optional_0_;
        public static final PresenceRequest IMMUTABLE_DEFAULT_INSTANCE = new PresenceRequest(){
            private static final long serialVersionUID = 1L;

            public PresenceRequest clearJid() {
                return this;
            }

            public PresenceRequest setJidAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public PresenceRequest setJid(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public PresenceRequest setJid(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public PresenceRequest clearFromJid() {
                return this;
            }

            public PresenceRequest setFromJidAsBytes(byte[] x) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public PresenceRequest setFromJid(String v) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public PresenceRequest setFromJid(String v, Charset cs) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public PresenceRequest mergeFrom(PresenceRequest that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public PresenceRequest freeze() {
                return this;
            }

            public PresenceRequest unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final int kjid = 1;
        public static final int kfrom_jid = 2;
        public static final String[] text = new String[3];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        public final byte[] getJidAsBytes() {
            return this.jid_;
        }

        public final boolean hasJid() {
            return (this.optional_0_ & 1) != 0;
        }

        public PresenceRequest clearJid() {
            this.optional_0_ &= 0xFFFFFFFE;
            this.jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public PresenceRequest setJidAsBytes(byte[] x) {
            this.optional_0_ |= 1;
            this.jid_ = x;
            return this;
        }

        public final String getJid() {
            return ProtocolSupport.toStringUtf8(this.jid_);
        }

        public PresenceRequest setJid(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.jid_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getJid(Charset cs) {
            return ProtocolSupport.toString(this.jid_, cs);
        }

        public PresenceRequest setJid(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 1;
            this.jid_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        public final byte[] getFromJidAsBytes() {
            return this.from_jid_;
        }

        public final boolean hasFromJid() {
            return (this.optional_0_ & 2) != 0;
        }

        public PresenceRequest clearFromJid() {
            this.optional_0_ &= 0xFFFFFFFD;
            this.from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            return this;
        }

        public PresenceRequest setFromJidAsBytes(byte[] x) {
            this.optional_0_ |= 2;
            this.from_jid_ = x;
            return this;
        }

        public final String getFromJid() {
            return ProtocolSupport.toStringUtf8(this.from_jid_);
        }

        public PresenceRequest setFromJid(String v) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.from_jid_ = ProtocolSupport.toBytesUtf8(v);
            return this;
        }

        public final String getFromJid(Charset cs) {
            return ProtocolSupport.toString(this.from_jid_, cs);
        }

        public PresenceRequest setFromJid(String v, Charset cs) {
            if (v == null) {
                throw new NullPointerException();
            }
            this.optional_0_ |= 2;
            this.from_jid_ = ProtocolSupport.toBytes(v, cs);
            return this;
        }

        @Override
        public PresenceRequest mergeFrom(PresenceRequest that) {
            assert (that != this);
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if ((that_t0 & 1) != 0) {
                this_t0 |= 1;
                this.jid_ = that.jid_;
            }
            if ((that_t0 & 2) != 0) {
                this_t0 |= 2;
                this.from_jid_ = that.from_jid_;
            }
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            this.optional_0_ = this_t0;
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(PresenceRequest that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(PresenceRequest that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(PresenceRequest that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            int this_t0 = this.optional_0_;
            int that_t0 = that.optional_0_;
            if (this_t0 != that_t0) {
                return false;
            }
            if ((this_t0 & 1) != 0 && !Arrays.equals(this.jid_, that.jid_)) {
                return false;
            }
            if ((this_t0 & 2) != 0 && !Arrays.equals(this.from_jid_, that.from_jid_)) {
                return false;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof PresenceRequest && this.equals((PresenceRequest)that);
        }

        @Override
        public int hashCode() {
            int hash = 1072279583;
            int this_t0 = this.optional_0_;
            hash = hash * 31 + ((this_t0 & 1) != 0 ? Arrays.hashCode(this.jid_) : -113);
            hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.from_jid_) : -113);
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            int this_t0 = this.optional_0_;
            return (this_t0 & 1) == 1;
        }

        @Override
        public int encodingSize() {
            int n = 1 + Protocol.stringSize(this.jid_.length);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                n += 1 + Protocol.stringSize(this.from_jid_.length);
            }
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 6 + this.jid_.length;
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                n += 6 + this.from_jid_.length;
            }
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        public void clear() {
            this.optional_0_ = 0;
            this.jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.from_jid_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
            this.uninterpreted = null;
        }

        @Override
        public PresenceRequest newInstance() {
            return new PresenceRequest();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            sink.putByte((byte)10);
            sink.putPrefixedData(this.jid_);
            int this_t0 = this.optional_0_;
            if ((this_t0 & 2) != 0) {
                sink.putByte((byte)18);
                sink.putPrefixedData(this.from_jid_);
            }
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            int this_t0 = this.optional_0_;
            block5: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block5;
                    }
                    case 10: {
                        this.jid_ = source.getPrefixedData();
                        this_t0 |= 1;
                        continue block5;
                    }
                    case 18: {
                        this.from_jid_ = source.getPrefixedData();
                        this_t0 |= 2;
                        continue block5;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block5;
                    }
                }
            }
            this.optional_0_ = this_t0;
            return result;
        }

        @Override
        public PresenceRequest getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final PresenceRequest getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        @Override
        public PresenceRequest freeze() {
            this.jid_ = ProtocolSupport.freezeString(this.jid_);
            this.from_jid_ = ProtocolSupport.freezeString(this.from_jid_);
            return this;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        static {
            PresenceRequest.text[0] = "ErrorCode";
            PresenceRequest.text[1] = "jid";
            PresenceRequest.text[2] = "from_jid";
            types = new int[3];
            Arrays.fill(types, 6);
            PresenceRequest.types[0] = 0;
            PresenceRequest.types[1] = 2;
            PresenceRequest.types[2] = 2;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(PresenceRequest.class, "Z&apphosting/api/xmpp/xmpp_service.proto\n\u001aapphosting.PresenceRequest\u0013\u001a\u0003jid \u0001(\u00020\t8\u0002\u0014\u0013\u001a\bfrom_jid \u0002(\u00020\t8\u0001\u0014", new ProtocolType.FieldType("jid", "jid", 1, 0, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("from_jid", "from_jid", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.OPTIONAL));

            private StaticHolder() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XmppServiceError
    extends ProtocolMessage<XmppServiceError> {
        private static final long serialVersionUID = 1L;
        private UninterpretedTags uninterpreted;
        public static final XmppServiceError IMMUTABLE_DEFAULT_INSTANCE = new XmppServiceError(){
            private static final long serialVersionUID = 1L;

            public XmppServiceError mergeFrom(XmppServiceError that) {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean merge(ProtocolSource source) {
                ProtocolSupport.unsupportedOperation();
                return false;
            }

            public XmppServiceError freeze() {
                return this;
            }

            public XmppServiceError unfreeze() {
                ProtocolSupport.unsupportedOperation();
                return this;
            }

            public boolean isFrozen() {
                return true;
            }
        };
        public static final String[] text = new String[1];
        public static final int[] types;
        public static final String style = "";
        public static final String style_content_type = "";

        @Override
        public XmppServiceError mergeFrom(XmppServiceError that) {
            assert (that != this);
            if (that.uninterpreted != null) {
                this.getUninterpretedForWrite().putAll(that.uninterpreted);
            }
            return this;
        }

        @Override
        public boolean equalsIgnoreUninterpreted(XmppServiceError that) {
            return this.equals(that, true);
        }

        @Override
        public boolean equals(XmppServiceError that) {
            return this.equals(that, false);
        }

        @Override
        public boolean equals(XmppServiceError that, boolean ignoreUninterpreted) {
            if (that == null) {
                return false;
            }
            if (that == this) {
                return true;
            }
            return ignoreUninterpreted || UninterpretedTags.equivalent(this.uninterpreted, that.uninterpreted);
        }

        @Override
        public boolean equals(Object that) {
            return that instanceof XmppServiceError && this.equals((XmppServiceError)that);
        }

        @Override
        public int hashCode() {
            int hash = -2138676254;
            if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
                hash = hash * 31 + this.uninterpreted.hashCode();
            }
            return hash;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public int encodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
        }

        @Override
        public int maxEncodingSize() {
            int n = 0;
            return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
        }

        @Override
        public MessageAppender getMessageAppender() {
            return this.getUninterpretedForWrite();
        }

        @Override
        public void clear() {
            this.uninterpreted = null;
        }

        @Override
        public XmppServiceError newInstance() {
            return new XmppServiceError();
        }

        @Override
        public ProtocolType getProtocolType() {
            return StaticHolder.protocolType;
        }

        @Override
        public void outputTo(ProtocolSink sink) {
            if (this.uninterpreted != null) {
                this.uninterpreted.put(sink);
            }
        }

        @Override
        public boolean merge(ProtocolSource source) {
            boolean result = true;
            block3: while (source.hasRemaining()) {
                int tt = source.getVarInt();
                switch (tt) {
                    case 0: {
                        result = false;
                        break block3;
                    }
                    default: {
                        this.getUninterpretedForWrite().putBytes(tt, source.getUninterpreted(tt));
                        continue block3;
                    }
                }
            }
            return result;
        }

        @Override
        public XmppServiceError getDefaultInstanceForType() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public static final XmppServiceError getDefaultInstance() {
            return IMMUTABLE_DEFAULT_INSTANCE;
        }

        public UninterpretedTags getUninterpretedForWrite() {
            if (this.uninterpreted == null) {
                this.uninterpreted = new UninterpretedTags();
            }
            return this.uninterpreted;
        }

        static {
            XmppServiceError.text[0] = "ErrorCode";
            types = new int[1];
            Arrays.fill(types, 6);
            XmppServiceError.types[0] = 0;
        }

        private static class StaticHolder {
            private static final ProtocolType protocolType = new ProtocolType(XmppServiceError.class, "Z&apphosting/api/xmpp/xmpp_service.proto\n\u001bapphosting.XmppServiceErrorsz\tErrorCode\u008b\u0001\u0092\u0001\u0011UNSPECIFIED_ERROR\u0098\u0001\u0001\u008c\u0001\u008b\u0001\u0092\u0001\u000bINVALID_JID\u0098\u0001\u0002\u008c\u0001\u008b\u0001\u0092\u0001\u0007NO_BODY\u0098\u0001\u0003\u008c\u0001\u008b\u0001\u0092\u0001\u000bINVALID_XML\u0098\u0001\u0004\u008c\u0001\u008b\u0001\u0092\u0001\fINVALID_TYPE\u0098\u0001\u0005\u008c\u0001\u008b\u0001\u0092\u0001\fINVALID_SHOW\u0098\u0001\u0006\u008c\u0001\u008b\u0001\u0092\u0001\u0011EXCEEDED_MAX_SIZE\u0098\u0001\u0007\u008c\u0001t", new ProtocolType.FieldType[0]);

            private StaticHolder() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ErrorCode implements ProtocolMessageEnum
        {
            UNSPECIFIED_ERROR(1),
            INVALID_JID(2),
            NO_BODY(3),
            INVALID_XML(4),
            INVALID_TYPE(5),
            INVALID_SHOW(6),
            EXCEEDED_MAX_SIZE(7);

            public static final ErrorCode ErrorCode_MIN;
            public static final ErrorCode ErrorCode_MAX;
            private final int value;

            @Override
            public int getValue() {
                return this.value;
            }

            public static ErrorCode valueOf(int value) {
                switch (value) {
                    case 1: {
                        return UNSPECIFIED_ERROR;
                    }
                    case 2: {
                        return INVALID_JID;
                    }
                    case 3: {
                        return NO_BODY;
                    }
                    case 4: {
                        return INVALID_XML;
                    }
                    case 5: {
                        return INVALID_TYPE;
                    }
                    case 6: {
                        return INVALID_SHOW;
                    }
                    case 7: {
                        return EXCEEDED_MAX_SIZE;
                    }
                }
                return null;
            }

            private ErrorCode(int v) {
                this.value = v;
            }

            static {
                ErrorCode_MIN = UNSPECIFIED_ERROR;
                ErrorCode_MAX = EXCEEDED_MAX_SIZE;
            }
        }
    }
}

