/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.utils;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FutureWrapper<K, V>
implements Future<V> {
    private final Future<K> parent;

    public FutureWrapper(Future<K> parent) {
        this.parent = parent;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.parent.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.parent.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.parent.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        K data;
        try {
            data = this.parent.get();
        }
        catch (ExecutionException ex) {
            throw new ExecutionException(this.convertException(ex.getCause()));
        }
        try {
            return this.wrap(data);
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        K data;
        try {
            data = this.parent.get(timeout, unit);
        }
        catch (ExecutionException ex) {
            throw new ExecutionException(this.convertException(ex.getCause()));
        }
        try {
            return this.wrap(data);
        }
        catch (Exception ex) {
            throw new ExecutionException(ex);
        }
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected abstract V wrap(K var1) throws Exception;

    protected abstract Throwable convertException(Throwable var1);
}

