/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.images.Composite;
import com.google.appengine.api.images.Image;
import com.google.appengine.api.images.OutputSettings;
import com.google.appengine.api.images.Transform;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ImagesService {
    public static final int MAX_TRANSFORMS_PER_REQUEST = 10;
    public static final int MAX_RESIZE_DIMENSIONS = 4000;
    public static final int MAX_COMPOSITES_PER_REQUEST = 16;
    public static final Set<Integer> SERVING_SIZES = new TreeSet<Integer>(Arrays.asList(0, 32, 48, 64, 72, 80, 90, 94, 104, 110, 120, 128, 144, 150, 160, 200, 220, 288, 320, 400, 512, 576, 640, 720, 800, 912, 1024, 1152, 1280, 1440, 1600));
    public static final Set<Integer> SERVING_CROP_SIZES = new TreeSet<Integer>(Arrays.asList(32, 48, 64, 72, 80, 104, 136, 144, 150, 160));

    public Image applyTransform(Transform var1, Image var2);

    public Future<Image> applyTransformAsync(Transform var1, Image var2);

    public Image applyTransform(Transform var1, Image var2, OutputEncoding var3);

    public Future<Image> applyTransformAsync(Transform var1, Image var2, OutputEncoding var3);

    public Image applyTransform(Transform var1, Image var2, OutputSettings var3);

    public Future<Image> applyTransformAsync(Transform var1, Image var2, OutputSettings var3);

    public Image composite(Collection<Composite> var1, int var2, int var3, long var4);

    public Image composite(Collection<Composite> var1, int var2, int var3, long var4, OutputEncoding var6);

    public Image composite(Collection<Composite> var1, int var2, int var3, long var4, OutputSettings var6);

    public int[][] histogram(Image var1);

    public String getServingUrl(BlobKey var1);

    public String getServingUrl(BlobKey var1, int var2, boolean var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputEncoding {
        PNG,
        JPEG;

    }
}

