/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.FileUserData;
import charactermanaj.util.UserData;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserDataFactory {
    private static final Logger logger = Logger.getLogger(UserDataFactory.class.getName());
    private final File userDataDir;
    private static Charset mangledEncoding;
    private static Charset[] systemEncodings;
    public static final String KEY_MANGLED_ENCODING = "charactermanaj.mangled.encoding";

    private UserDataFactory(File userDataDir) {
        this.userDataDir = userDataDir;
    }

    public static UserDataFactory getInstance() {
        return new UserDataFactory(ConfigurationDirUtilities.getUserDataDir());
    }

    public static UserDataFactory getLocalInstance() {
        return new UserDataFactory(ConfigurationDirUtilities.getLocalUserDataDir());
    }

    public File getSpecialDataDir(String name) {
        return this.getSpecialDataDir(name, this.userDataDir);
    }

    private File getSpecialDataDir(String name, File userDataDir) {
        if (name != null && name.length() > 0) {
            int seppos = name.lastIndexOf(45);
            if (name.endsWith(".xml") && seppos >= 0) {
                String groupName = name.substring(seppos + 1, name.length() - 4);
                if (groupName.length() > 0) {
                    userDataDir = new File(userDataDir, groupName);
                }
            } else {
                String ext;
                int pos = name.lastIndexOf(46);
                if (pos >= 0 && (ext = name.substring(pos + 1)).length() > 0) {
                    userDataDir = "ser".equals(ext) ? new File(userDataDir, "caches") : new File(userDataDir, ext + "s");
                }
            }
        }
        if (!userDataDir.exists()) {
            boolean result = userDataDir.mkdirs();
            logger.log(Level.INFO, "makeDir: " + userDataDir + " /succeeded=" + result);
        }
        return userDataDir;
    }

    public UserData getUserData(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        return new FileUserData(new File(this.getSpecialDataDir(name), name));
    }

    public UserData getMangledNamedUserData(URI docBase, String name) {
        Charset fileNameEncoding = UserDataFactory.getMangledEncoding();
        String mangledName = this.getMangledName(docBase, fileNameEncoding);
        FileUserData userData = (FileUserData)this.getUserData(mangledName + "-" + name);
        if (!userData.exists()) {
            for (Charset defaultEncoding : UserDataFactory.getSystemEncodings()) {
                String oldMangledName;
                FileUserData oldUserData;
                if (fileNameEncoding.equals(defaultEncoding) || !(oldUserData = (FileUserData)this.getUserData((oldMangledName = this.getMangledName(docBase, defaultEncoding)) + "-" + name)).exists()) continue;
                logger.log(Level.INFO, "rename mangled: (" + defaultEncoding + ")" + oldUserData.getFile() + " -> (" + fileNameEncoding + ")" + userData.getFile());
                oldUserData.getFile().renameTo(userData.getFile());
                break;
            }
        }
        return userData;
    }

    private String getMangledName(URI docBase, Charset encoding) {
        String docBaseStr = docBase == null ? "" : docBase.toString();
        String mangledName = UUID.nameUUIDFromBytes(docBaseStr.getBytes(encoding)).toString();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "mangledName " + docBase + "=" + mangledName);
        }
        return mangledName;
    }

    private static Charset getMangledEncoding() {
        if (mangledEncoding == null) {
            String encName = System.getProperty(KEY_MANGLED_ENCODING, "UTF-8");
            Charset fileNameEncoding = null;
            if (encName != null && encName.length() > 0) {
                try {
                    fileNameEncoding = Charset.forName(encName);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "unsupported charset: " + encName, ex);
                }
            }
            if (fileNameEncoding == null) {
                fileNameEncoding = Charset.defaultCharset();
            }
            mangledEncoding = fileNameEncoding;
        }
        return mangledEncoding;
    }

    private static Charset[] getSystemEncodings() {
        if (systemEncodings == null) {
            String[] keys = new String[]{"file.encoding", "sun.jnu.encoding"};
            Charset[] encodings = new Charset[keys.length];
            int cnt = 0;
            for (String key : keys) {
                Charset encoding;
                String encodingName = System.getProperty(key);
                if (encodingName == null || encodingName.length() <= 0) continue;
                try {
                    encoding = Charset.forName(encodingName);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "invalid charset:" + encodingName, ex);
                    continue;
                }
                boolean found = false;
                for (int idx = 0; idx < cnt; ++idx) {
                    if (!encodings[idx].equals(encoding)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                encodings[cnt++] = encoding;
            }
            systemEncodings = Arrays.copyOf(encodings, cnt);
        }
        return systemEncodings;
    }
}

