/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DownloadUtils {
    private static final Logger logger = Logger.getLogger(DownloadUtils.class.getName());
    private String impersonateUserAgent;
    private int maxHop = 10;
    private boolean deleteDownloadFileOnExit = true;

    public void setImpersonateUserAgent(String impersonateUserAgent) {
        this.impersonateUserAgent = impersonateUserAgent;
    }

    public String getImpersonateUserAgent() {
        return this.impersonateUserAgent;
    }

    public void setMaxHop(int maxHop) {
        this.maxHop = maxHop;
    }

    public int getMaxHop() {
        return this.maxHop;
    }

    public void setDeleteDownloadFileOnExit(boolean deleteOnExit) {
        this.deleteDownloadFileOnExit = deleteOnExit;
    }

    public boolean isDeleteDownloadFileOnExit() {
        return this.deleteDownloadFileOnExit;
    }

    public void loadContents(String location, OutputStream os) throws IOException {
        this.loadContents(this.getHead(location), os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadContents(HeadResponse headResponse, OutputStream os) throws IOException {
        String realLoction = headResponse.getLocation();
        URL url = new URL(realLoction);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (this.impersonateUserAgent != null && this.impersonateUserAgent.length() > 0) {
            conn.setRequestProperty("User-Agent", this.impersonateUserAgent);
        }
        conn.connect();
        try {
            int status = conn.getResponseCode();
            if (status == 404) {
                throw new FileNotFoundException("Failed to load contents. status=" + status + ", url=" + url);
            }
            if (status < 200 || status >= 300) {
                throw new IOException("Failed to load contents. status=" + status + ", url=" + url);
            }
            byte[] buf = new byte[4096];
            InputStream is = conn.getInputStream();
            try {
                int rd;
                while ((rd = is.read(buf)) >= 0) {
                    os.write(buf, 0, rd);
                }
                os.flush();
            }
            finally {
                is.close();
            }
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File downloadTemporary(HeadResponse headResponse) throws IOException {
        String ext = headResponse.getDotExtension();
        if (ext == null || ext.length() == 0) {
            ext = ".tmp";
        }
        File tmpFile = File.createTempFile("cmj-", ext);
        if (this.isDeleteDownloadFileOnExit()) {
            tmpFile.deleteOnExit();
        }
        logger.log(Level.INFO, "Create temporary file: " + tmpFile);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmpFile));
            try {
                this.loadContents(headResponse, (OutputStream)bos);
            }
            finally {
                ((OutputStream)bos).close();
            }
        }
        catch (RuntimeException ex) {
            tmpFile.delete();
            logger.log(Level.INFO, "Delete temporary file: " + tmpFile);
            throw ex;
        }
        catch (IOException ex) {
            logger.log(Level.INFO, "Delete temporary file: " + tmpFile);
            tmpFile.delete();
            throw ex;
        }
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeadResponse getHead(String location) throws IOException {
        int status;
        HttpURLConnection conn;
        URL url;
        String initLocation = location;
        int hopCount = 0;
        while (true) {
            logger.log(Level.INFO, "Connect to " + location);
            url = new URL(location);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setInstanceFollowRedirects(false);
            if (this.impersonateUserAgent != null && this.impersonateUserAgent.length() > 0) {
                conn.setRequestProperty("User-Agent", this.impersonateUserAgent);
            }
            conn.connect();
            try {
                status = conn.getResponseCode();
            }
            finally {
                conn.disconnect();
            }
            if (status != 302 && status != 301 && status != 303) break;
            if (hopCount > this.maxHop) {
                throw new IOException("too many hops! " + hopCount);
            }
            location = conn.getHeaderField("Location");
            if (location == null || location.isEmpty()) {
                throw new IOException("bad response. location not found.");
            }
            ++hopCount;
            logger.log(Level.INFO, "Location to " + location);
        }
        if (status >= 200 && status < 300) {
            HeadResponse response = new HeadResponse();
            response.location = location;
            response.contentType = conn.getContentType();
            String contentDisposition = conn.getHeaderField("Content-Disposition");
            String fileName = null;
            if (contentDisposition != null && contentDisposition.length() > 0) {
                fileName = DownloadUtils.parseAttachmentFileName(contentDisposition);
            }
            if (fileName == null || fileName.length() == 0) {
                fileName = initLocation;
            }
            response.fileName = fileName;
            logger.log(Level.INFO, "response success. " + response);
            return response;
        }
        if (status == 404) {
            throw new FileNotFoundException("Failed to load contents. status=" + status + ", url=" + url);
        }
        logger.log(Level.WARNING, "response failed. status=" + status);
        throw new IOException("response failed. status=" + status);
    }

    private static List<String> splitSemicolon(String line) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        boolean mode = false;
        for (char ch : line.toCharArray()) {
            if (!mode) {
                if (ch == '\"') {
                    buf.append(ch);
                    mode = true;
                    continue;
                }
                if (ch == ';') {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    continue;
                }
                buf.append(ch);
                continue;
            }
            if (!mode) continue;
            if (ch == '\"') {
                buf.append(ch);
                mode = false;
                continue;
            }
            buf.append(ch);
        }
        if (buf.length() > 0) {
            lines.add(buf.toString());
        }
        return lines;
    }

    private static Map<String, String> parseKeyValuePair(List<String> lines) {
        TreeMap<String, String> keyValueMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String line : lines) {
            String value;
            String key;
            if ((line = line.trim()).isEmpty()) continue;
            int pos = line.indexOf("=");
            if (pos >= 0) {
                key = line.substring(0, pos);
                value = line.substring(pos + 1);
                if ((value = value.trim()).startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
            } else {
                key = line;
                value = "";
            }
            keyValueMap.put(key, value);
        }
        return keyValueMap;
    }

    private static String parseAttachmentFileName(String contentDisposition) {
        List<String> lines = DownloadUtils.splitSemicolon(contentDisposition);
        logger.log(Level.FINE, "content-dispotion: " + lines);
        Map<String, String> kv = DownloadUtils.parseKeyValuePair(lines);
        String fileName = null;
        String encodedFileName = kv.get("filename*");
        if (encodedFileName != null && encodedFileName.length() > 0) {
            int pos = encodedFileName.indexOf(39);
            String encoding = encodedFileName.substring(0, pos);
            if (encoding.isEmpty()) {
                encoding = "utf-8";
            }
            int pos2 = encodedFileName.indexOf(39, pos + 1);
            String language = encodedFileName.substring(pos + 1, pos2);
            try {
                fileName = URLDecoder.decode(encodedFileName.substring(pos2 + 1), encoding);
            }
            catch (UnsupportedEncodingException ex) {
                logger.log(Level.WARNING, "url encoding error: " + encodedFileName, ex);
                fileName = null;
            }
            logger.log(Level.INFO, "attachment filename*=" + encoding + "," + language + "," + fileName);
        }
        if (fileName == null || fileName.length() == 0) {
            fileName = kv.get("filename");
            logger.log(Level.INFO, "attachment filename=" + fileName);
        }
        return fileName;
    }

    public static final class HeadResponse {
        String location;
        String contentType;
        String fileName;

        public String getLocation() {
            return this.location;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getDotExtension() {
            String name = this.fileName;
            int pos = name.lastIndexOf(47);
            if (pos >= 0) {
                name = name.substring(pos + 1);
            }
            if ((pos = name.lastIndexOf(92)) >= 0) {
                name = name.substring(pos + 1);
            }
            int extPos = name.lastIndexOf(".");
            String ext = "";
            if (extPos > 0) {
                ext = name.substring(extPos).toLowerCase();
            }
            return ext;
        }

        public String toString() {
            return "location=" + this.location + ", contentType=" + this.contentType + ", fileName=" + this.fileName;
        }
    }
}

