/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.util;

import charactermanaj.util.JavaVersionUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ScaleSupport {
    private static final int resolution;
    private static final float computeScale;
    private static final boolean noNeedCheckScaleByReflection;
    private double scaleX;
    private double scaleY;
    private double manualScaleX;
    private double manualScaleY;
    private boolean retina;

    private ScaleSupport(double scaleX, double scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        if (scaleX > 1.0 || scaleY > 1.0 || Boolean.getBoolean("disableScaleCalibrate")) {
            this.manualScaleX = 1.0;
            this.manualScaleY = 1.0;
        } else {
            this.manualScaleX = computeScale;
            this.manualScaleY = computeScale;
        }
    }

    public static int getScreenResolution() {
        return resolution;
    }

    public static float getScreenScale() {
        return computeScale;
    }

    private void setRetina(boolean retina) {
        this.retina = retina;
    }

    public boolean isRetina() {
        return this.retina;
    }

    public static ScaleSupport getInstance(Component comp) {
        GraphicsConfiguration gconf = comp.getGraphicsConfiguration();
        if (gconf == null) {
            return null;
        }
        return ScaleSupport.getInstance(gconf);
    }

    public static ScaleSupport getDefault() {
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gdev = genv.getDefaultScreenDevice();
        return ScaleSupport.getInstance(gdev.getDefaultConfiguration());
    }

    public static ScaleSupport getInstance(GraphicsConfiguration gconf) {
        AffineTransform trans = gconf.getDefaultTransform();
        double scaleX = trans.getScaleX();
        double scaleY = trans.getScaleY();
        boolean retina = false;
        if (scaleX == 1.0 && scaleY == 1.0 && !noNeedCheckScaleByReflection) {
            GraphicsDevice device = gconf.getDevice();
            Object scaleObj = null;
            try {
                Method methodGetScaleFactor = device.getClass().getMethod("getScaleFactor", new Class[0]);
                scaleObj = methodGetScaleFactor.invoke((Object)device, new Object[0]);
            }
            catch (Exception ex) {
                try {
                    Field field = device.getClass().getDeclaredField("scale");
                    field.setAccessible(true);
                    scaleObj = field.get(device);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (scaleObj instanceof Number) {
                int scale = ((Number)scaleObj).intValue();
                scaleX = scaleY = (double)scale;
                if (scale >= 2) {
                    retina = true;
                }
            }
        }
        ScaleSupport inst = new ScaleSupport(scaleX, scaleY);
        inst.setRetina(retina);
        return inst;
    }

    public double getDefaultScaleX() {
        return this.scaleX;
    }

    public double getDefaultScaleY() {
        return this.scaleY;
    }

    public double getManualScaleX() {
        return this.manualScaleX;
    }

    public double getManualScaleY() {
        return this.manualScaleY;
    }

    public Dimension manualScaled(Dimension dim) {
        return new Dimension((int)(dim.getWidth() * this.manualScaleX), (int)(dim.getHeight() * this.manualScaleY));
    }

    static {
        Toolkit tk = Toolkit.getDefaultToolkit();
        resolution = tk.getScreenResolution();
        float dpi = System.getProperty("os.name").startsWith("Windows") ? 96.0f : (float)resolution;
        computeScale = (float)resolution / dpi;
        noNeedCheckScaleByReflection = JavaVersionUtils.getJavaVersion() >= 9.0;
    }
}

