/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.graphics.io.UkagakaImageConverter;
import charactermanaj.ui.ColorBox;
import charactermanaj.ui.SamplePicturePanel;
import charactermanaj.ui.util.ScaleSupport;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UkagakaConvertDialog
extends JDialog {
    private static final long serialVersionUID = 4189631881766588004L;
    protected static final String STRINGS_RESOURCE = "languages/ukagakaConvertDialog";
    private TextField caption = new TextField();
    private AbstractAction actCancel;
    private AbstractAction actSave;
    private SamplePicturePanel opaqueImagePanel = new SamplePicturePanel();
    private SamplePicturePanel alphaImagePanel = new SamplePicturePanel();
    private ColorBox colorBox = new ColorBox();
    private BufferedImage originalImage;
    private boolean manualTransparentColorKey;
    private JRadioButton radioAuto;
    private JRadioButton radioManual;
    private JCheckBox chkOverwriteOption;
    private Object result;
    private ActionListener saveActionListener;
    private boolean showOverwriteOption;

    public UkagakaConvertDialog(JFrame parent) {
        this(parent, false);
    }

    public UkagakaConvertDialog(JFrame parent, boolean overwriteOption) {
        this(parent, null, overwriteOption);
    }

    public UkagakaConvertDialog(JFrame parent, ActionListener saveActionListener, boolean overwriteOption) {
        super((Frame)parent, true);
        this.saveActionListener = saveActionListener;
        this.showOverwriteOption = overwriteOption;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UkagakaConvertDialog.this.onClose();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                UkagakaConvertDialog.this.result = null;
            }
        });
        try {
            this.initComponent();
        }
        catch (RuntimeException ex) {
            this.dispose();
            throw ex;
        }
    }

    private void initComponent() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UkagakaConvertDialog.this.onClose();
            }
        };
        this.actSave = new AbstractAction(strings.getProperty("btn.save")){
            private static final long serialVersionUID = -1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UkagakaConvertDialog.this.onSave();
            }
        };
        JButton btnCancel = new JButton(this.actCancel);
        JButton btnSave = new JButton(this.actSave);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(3, 3));
        contentPane.add((Component)this.caption, "North");
        this.caption.setEditable(false);
        this.caption.setVisible(false);
        JScrollPane opaqueSp = new JScrollPane(this.opaqueImagePanel);
        JScrollPane alphaSp = new JScrollPane(this.alphaImagePanel);
        JPanel previewSpPane = new JPanel();
        BoxLayout boxlayout = new BoxLayout(previewSpPane, 2);
        previewSpPane.setLayout(boxlayout);
        previewSpPane.add(opaqueSp);
        previewSpPane.add(Box.createHorizontalStrut(3));
        previewSpPane.add(alphaSp);
        previewSpPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(strings.getProperty("preview")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        JPanel centerPane = new JPanel(new BorderLayout());
        centerPane.add((Component)previewSpPane, "Center");
        JPanel transparentColorPanel = new JPanel();
        GridBagLayout tc_gbl = new GridBagLayout();
        transparentColorPanel.setLayout(tc_gbl);
        transparentColorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(strings.getProperty("caption.chooseTransparentColorKey")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        centerPane.add((Component)transparentColorPanel, "South");
        GridBagConstraints gbc = new GridBagConstraints();
        this.radioAuto = new JRadioButton(strings.getProperty("radio.auto"));
        this.radioAuto.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UkagakaConvertDialog.this.onChange(!UkagakaConvertDialog.this.radioAuto.isSelected());
            }
        });
        this.radioManual = new JRadioButton(strings.getProperty("radio.manual"));
        this.radioAuto.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UkagakaConvertDialog.this.onChange(!UkagakaConvertDialog.this.radioAuto.isSelected());
            }
        });
        ButtonGroup btngroup = new ButtonGroup();
        btngroup.add(this.radioAuto);
        btngroup.add(this.radioManual);
        this.radioAuto.setSelected(!this.manualTransparentColorKey);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 17;
        gbc.fill = 1;
        transparentColorPanel.add((Component)this.radioAuto, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        transparentColorPanel.add((Component)this.radioManual, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        transparentColorPanel.add((Component)this.colorBox, gbc);
        contentPane.add((Component)centerPane, "Center");
        JPanel btnPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        btnPanel.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 17;
        gbc.fill = 1;
        this.chkOverwriteOption = new JCheckBox(strings.getProperty("chk.overwriteOriginalFile"));
        if (this.showOverwriteOption) {
            btnPanel.add((Component)this.chkOverwriteOption, gbc);
        } else {
            btnPanel.add(Box.createHorizontalGlue(), gbc);
        }
        gbc.gridx = Main.isLinuxOrMacOSX() ? 2 : 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        btnPanel.add((Component)btnSave, gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 1 : 2;
        gbc.gridy = 0;
        btnPanel.add((Component)btnCancel, gbc);
        btnPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 45));
        contentPane.add((Component)btnPanel, "South");
        JRootPane rootPane = this.getRootPane();
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeExportWizDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeExportWizDialog");
        am.put("closeExportWizDialog", this.actCancel);
        rootPane.setDefaultButton(btnSave);
        rootPane.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        Dimension dim = new Dimension(450, 450);
        ScaleSupport scaleSupport = ScaleSupport.getInstance(this);
        if (scaleSupport != null) {
            dim = scaleSupport.manualScaled(dim);
        }
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
        this.colorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UkagakaConvertDialog.this.onChooseTransparentColorKey();
            }
        });
    }

    public void setExportImage(BufferedImage img, Color colorKey) {
        if (img == null) {
            throw new IllegalArgumentException();
        }
        if (img.getType() != 2) {
            throw new IllegalArgumentException("TYPE_INT_ARGB\u4ee5\u5916\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (colorKey == null) {
            colorKey = Color.GREEN;
        }
        this.originalImage = img;
        this.colorBox.setColorKey(colorKey);
        this.rebuildImage();
    }

    public BufferedImage getOpaqueImage() {
        return this.opaqueImagePanel.getSamplePictrue();
    }

    public BufferedImage getAlphaImage() {
        return this.alphaImagePanel.getSamplePictrue();
    }

    public void setAutoTransparentColor(boolean mode) {
        if (mode) {
            this.radioAuto.setSelected(true);
            this.radioManual.setSelected(false);
        } else {
            this.radioManual.setSelected(true);
            this.radioAuto.setSelected(false);
        }
    }

    public Color getTransparentColorKey() {
        return this.colorBox.getColorKey();
    }

    public void setTransparentColorKey(Color colorKey) {
        this.colorBox.setColorKey(colorKey);
    }

    public boolean isAutoTransparentColor() {
        return this.radioAuto.isSelected();
    }

    public boolean isOverwriteOriginalFile() {
        return this.chkOverwriteOption.isSelected();
    }

    public void setOverwriteOriginalFile(boolean overwriteOriginalFile) {
        this.chkOverwriteOption.setSelected(overwriteOriginalFile);
    }

    protected void onClose() {
        this.result = null;
        this.dispose();
    }

    protected void onSave() {
        if (this.saveActionListener != null) {
            ActionEvent e = new ActionEvent(this, 0, "save");
            this.saveActionListener.actionPerformed(e);
        }
    }

    public void setSaveActionListener(ActionListener saveActionListener) {
        this.saveActionListener = saveActionListener;
    }

    public ActionListener getSaveActionListener() {
        return this.saveActionListener;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setCaption(String text) {
        if (text == null || text.length() == 0) {
            this.caption.setText("");
            this.caption.setVisible(false);
        } else {
            this.caption.setText(text);
            this.caption.setVisible(true);
        }
    }

    public String getCaption() {
        return this.caption.getText();
    }

    protected void onChooseTransparentColorKey() {
        this.setAutoTransparentColor(false);
        this.rebuildImage();
    }

    protected void onChange(boolean modeManual) {
        if (this.manualTransparentColorKey != modeManual) {
            this.manualTransparentColorKey = modeManual;
            this.rebuildImage();
        }
    }

    protected void rebuildImage() {
        if (this.originalImage == null) {
            return;
        }
        UkagakaImageConverter conv = UkagakaImageConverter.getInstance();
        BufferedImage pna = conv.createUkagakaPNA(this.originalImage);
        Color transparentColorKey = null;
        transparentColorKey = this.manualTransparentColorKey ? this.colorBox.getColorKey() : conv.detectTransparentColorKey(this.originalImage);
        BufferedImage png = conv.createUkagakaPNG(this.originalImage, transparentColorKey);
        this.opaqueImagePanel.setSamplePicture(png);
        this.alphaImagePanel.setSamplePicture(pna);
    }
}

