/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.CharacterData;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSet;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.ImportModel;
import charactermanaj.ui.ImportFileSelectPanel;
import charactermanaj.ui.ImportPartsSelectPanel;
import charactermanaj.ui.ImportPresetSelectPanel;
import charactermanaj.ui.ImportTypeSelectPanel;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.util.ScaleSupport;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImportWizardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "languages/importwizdialog";
    public static final int EXIT_PROFILE_UPDATED = 1;
    public static final int EXIT_PROFILE_CREATED = 2;
    public static final int EXIT_CANCELED = 0;
    private int exitCode = 0;
    private CharacterData importedCharacterData;
    protected CharacterData current;
    private CardLayout mainPanelLayout;
    private ImportWizardCardPanel activePanel;
    private AbstractAction actNext;
    private AbstractAction actPrev;
    private AbstractAction actFinish;
    protected ImportFileSelectPanel importFileSelectPanel;
    protected ImportTypeSelectPanel importTypeSelectPanel;
    protected ImportPartsSelectPanel importPartsSelectPanel;
    protected ImportPresetSelectPanel importPresetSelectPanel;
    protected ImportModel importModel = new ImportModel();

    public ImportWizardDialog(JFrame parent, CharacterData current) {
        super((Frame)parent, true);
        this.initComponent(parent, current);
    }

    public ImportWizardDialog(JDialog parent, CharacterData current) {
        super((Dialog)parent, true);
        this.initComponent(parent, current);
    }

    public void initSelectFile(File initFile) {
        this.importFileSelectPanel.setSelectFile(initFile);
    }

    public void initSelectURL(String url) {
        this.importFileSelectPanel.initSelectURL(url);
    }

    private void initComponent(Component parent, CharacterData current) {
        this.current = current;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ImportWizardDialog.this.onClose();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (current == null) {
            this.setTitle(strings.getProperty("title.new"));
        } else {
            this.setTitle(strings.getProperty("title.update"));
        }
        ScaleSupport scaleSupport = ScaleSupport.getInstance(this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        final JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEtchedBorder());
        int gap = (int)(5.0 * scaleSupport.getManualScaleX());
        this.mainPanelLayout = new CardLayout(gap, gap);
        mainPanel.setLayout(this.mainPanelLayout);
        contentPane.add((Component)mainPanel, "Center");
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImportWizardDialog.this.updateBtnPanelState();
            }
        };
        ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ImportWizardDialog.this.onComponentShown((ImportWizardCardPanel)e.getComponent());
            }
        };
        this.actNext = new AbstractAction(strings.getProperty("btn.next")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportWizardDialog.this.setEnableButtons(false);
                String nextPanelName = ImportWizardDialog.this.doNext();
                if (nextPanelName != null) {
                    ImportWizardDialog.this.mainPanelLayout.show(mainPanel, nextPanelName);
                } else {
                    ImportWizardDialog.this.updateBtnPanelState();
                }
            }
        };
        this.actPrev = new AbstractAction(strings.getProperty("btn.prev")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportWizardDialog.this.setEnableButtons(false);
                String prevPanelName = ImportWizardDialog.this.doPrevious();
                if (prevPanelName != null) {
                    ImportWizardDialog.this.mainPanelLayout.show(mainPanel, prevPanelName);
                } else {
                    ImportWizardDialog.this.updateBtnPanelState();
                }
            }
        };
        this.actFinish = new AbstractAction(strings.getProperty("btn.finish")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportWizardDialog.this.onFinish();
            }
        };
        AbstractAction actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportWizardDialog.this.onClose();
            }
        };
        this.importFileSelectPanel = new ImportFileSelectPanel(scaleSupport);
        this.importFileSelectPanel.addComponentListener(componentListener);
        this.importFileSelectPanel.addChangeListener(changeListener);
        mainPanel.add((Component)this.importFileSelectPanel, "fileSelectPanel");
        this.importTypeSelectPanel = new ImportTypeSelectPanel(scaleSupport);
        this.importTypeSelectPanel.addComponentListener(componentListener);
        this.importTypeSelectPanel.addChangeListener(changeListener);
        mainPanel.add((Component)this.importTypeSelectPanel, "importTypeSelectPanel");
        this.importPartsSelectPanel = new ImportPartsSelectPanel(scaleSupport);
        this.importPartsSelectPanel.addComponentListener(componentListener);
        this.importPartsSelectPanel.addChangeListener(changeListener);
        mainPanel.add((Component)this.importPartsSelectPanel, "importPartsSelectPanel");
        this.importPresetSelectPanel = new ImportPresetSelectPanel(scaleSupport);
        this.importPresetSelectPanel.addComponentListener(componentListener);
        this.importPresetSelectPanel.addChangeListener(changeListener);
        mainPanel.add((Component)this.importPresetSelectPanel, "importPresetSelectPanel");
        JPanel btnPanel = new JPanel();
        int mergin = (int)(3.0 * scaleSupport.getManualScaleX());
        btnPanel.setBorder(BorderFactory.createEmptyBorder(mergin, mergin, mergin, mergin * 15));
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        this.actPrev.setEnabled(false);
        this.actNext.setEnabled(false);
        this.actFinish.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(mergin, mergin, mergin, mergin);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 2 : 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        btnPanel.add((Component)new JButton(this.actPrev), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 3 : 2;
        gbc.gridy = 0;
        JButton btnNext = new JButton(this.actNext);
        btnPanel.add((Component)btnNext, gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 4 : 3;
        gbc.gridy = 0;
        btnPanel.add((Component)new JButton(this.actFinish), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 1 : 4;
        gbc.gridy = 0;
        JButton btnCancel = new JButton(actCancel);
        btnPanel.add((Component)btnCancel, gbc);
        contentPane.add((Component)btnPanel, "South");
        Toolkit tk = Toolkit.getDefaultToolkit();
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnNext);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeImportWizDialog");
        im.put(KeyStroke.getKeyStroke(87, tk.getMenuShortcutKeyMask()), "closeImportWizDialog");
        am.put("closeImportWizDialog", actCancel);
        Dimension dim = new Dimension(500, 500);
        dim = scaleSupport.manualScaled(dim);
        this.setSize(dim);
        this.setLocationRelativeTo(parent);
        this.mainPanelLayout.first(mainPanel);
        this.updateBtnPanelState();
    }

    protected void onComponentShown(JPanel panel) {
        ImportWizardCardPanel activePanel = (ImportWizardCardPanel)panel;
        activePanel.onActive(this, this.activePanel);
        this.activePanel = activePanel;
        this.updateBtnPanelState();
    }

    protected void updateBtnPanelState() {
        if (this.activePanel != null) {
            this.actPrev.setEnabled(this.activePanel.isReadyPrevious());
            this.actNext.setEnabled(this.activePanel.isReadyNext());
            this.actFinish.setEnabled(this.activePanel.isReadyFinish());
        } else {
            this.setEnableButtons(false);
        }
    }

    public void setEnableButtons(boolean enabled) {
        this.actPrev.setEnabled(enabled);
        this.actNext.setEnabled(enabled);
        this.actFinish.setEnabled(enabled);
    }

    protected String doNext() {
        String nextPanelName;
        if (this.activePanel == null) {
            throw new IllegalStateException();
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            nextPanelName = this.activePanel.doNext();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return nextPanelName;
    }

    protected String doPrevious() {
        if (this.activePanel == null) {
            throw new IllegalStateException();
        }
        return this.activePanel.doPrevious();
    }

    protected void onClose() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.close"), strings.getProperty("confirm"), 0, 3) != 0) {
            return;
        }
        this.importFileSelectPanel.closeArchive();
        this.exitCode = 0;
        this.importedCharacterData = null;
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(STRINGS_RESOURCE);
        try {
            int exitCode;
            CharacterData importedCharacterData;
            this.setEnableButtons(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (this.current == null) {
                    importedCharacterData = this.createNewProfile();
                    exitCode = 2;
                } else {
                    importedCharacterData = this.updateProfile();
                    exitCode = 1;
                }
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.importFileSelectPanel.closeArchive();
            JOptionPane.showMessageDialog(this, strings.getProperty("complete"));
            this.exitCode = exitCode;
            this.importedCharacterData = importedCharacterData;
            this.dispose();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            this.updateBtnPanelState();
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public CharacterData getImportedCharacterData() {
        return this.importedCharacterData;
    }

    protected CharacterData createNewProfile() throws IOException {
        BufferedImage samplePicture;
        CharacterData cd = this.importModel.getCharacterData();
        if (cd == null || !cd.isValid()) {
            throw new IllegalStateException("imported caharcer data is invalid." + cd);
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        CharacterData characterData = cd.duplicateBasicInfo();
        Map<CustomLayerOrderKey, List<CustomLayerOrder>> customLayerPatterns = this.importModel.getCustomLayerPatternMap();
        characterData.setName(this.importTypeSelectPanel.getCharacterName());
        characterData.setAuthor(this.importTypeSelectPanel.getAuthor());
        characterData.clearPartsSets(false);
        if (this.importTypeSelectPanel.isImportPreset()) {
            for (PartsSet partsSet : this.importPresetSelectPanel.getSelectedPartsSets()) {
                PartsSet ps = partsSet.clone();
                ps.setPresetParts(true);
                characterData.addPartsSet(ps);
            }
            characterData.setDefaultPartsSetId(this.importPresetSelectPanel.getPrefferedDefaultPartsSetId());
        }
        persist.createProfile(characterData, customLayerPatterns);
        if (this.importTypeSelectPanel.isImportPartsImages()) {
            Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents = this.importPartsSelectPanel.getSelectedPartsImageContents();
            this.importModel.copyPartsImageContents(partsImageContents, characterData);
            PartsManageData partsManageData = this.importModel.getPartsManageData();
            this.importModel.updatePartsManageData(partsImageContents, partsManageData, null, characterData);
        }
        if (this.importTypeSelectPanel.isImportSampleImage() && (samplePicture = this.importModel.getSamplePicture()) != null) {
            persist.saveSamplePicture(characterData, samplePicture);
        }
        return characterData;
    }

    protected CharacterData updateProfile() throws IOException {
        Object samplePicture;
        if (this.current == null || !this.current.isValid()) {
            throw new IllegalStateException("current profile is not valid. :" + this.current);
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        CharacterData characterData = this.current.duplicateBasicInfo();
        boolean imported = false;
        boolean modCharacterDef = false;
        boolean modFavories = false;
        if (this.importTypeSelectPanel.isImportPartsImages()) {
            Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents = this.importPartsSelectPanel.getSelectedPartsImageContents();
            this.importModel.copyPartsImageContents(partsImageContents, characterData);
            PartsManageData partsManageData = this.importModel.getPartsManageData();
            this.importModel.updatePartsManageData(partsImageContents, partsManageData, characterData, characterData);
            imported = true;
        }
        if (this.importTypeSelectPanel.isImportSampleImage() && (samplePicture = this.importModel.getSamplePicture()) != null) {
            persist.saveSamplePicture(characterData, (BufferedImage)samplePicture);
            imported = true;
        }
        if (this.importTypeSelectPanel.isImportPreset()) {
            for (PartsSet partsSet : this.importPresetSelectPanel.getSelectedPartsSets()) {
                PartsSet ps = partsSet.clone();
                ps.setPresetParts(false);
                characterData.addPartsSet(ps);
            }
            imported = true;
            modCharacterDef = true;
            modFavories = true;
        }
        if (this.importTypeSelectPanel.isAddDescription() && imported) {
            URI archivedFile = this.importModel.getImportSource();
            String note = this.importTypeSelectPanel.getAdditionalDescription();
            if (note != null && note.length() > 0) {
                String description = characterData.getDescription();
                if (description == null) {
                    description = "";
                }
                String lf = System.getProperty("line.separator");
                Timestamp tm = new Timestamp(System.currentTimeMillis());
                description = description + lf + "--- import: " + tm + " : " + archivedFile + " ---" + lf;
                description = description + note + lf;
                characterData.setDescription(description);
                modCharacterDef = true;
            }
        }
        if (modCharacterDef) {
            persist.updateProfile(characterData);
            this.current.setDescription(characterData.getDescription());
        }
        if (modFavories) {
            persist.saveFavorites(characterData);
        }
        return characterData;
    }
}

