/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.io.CharacterDataFileReaderWriterFactory;
import charactermanaj.ui.ArchiveFileDialog;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.progress.ProgressHandle;
import charactermanaj.ui.progress.Worker;
import charactermanaj.ui.progress.WorkerException;
import charactermanaj.ui.progress.WorkerWithProgessDialog;
import charactermanaj.ui.util.FileDropTarget;
import charactermanaj.ui.util.ScaleSupport;
import charactermanaj.util.DownloadUtils;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ImportFileSelectPanel
extends ImportWizardCardPanel {
    private static final long serialVersionUID = 1L;
    public static final String PANEL_NAME = "fileSelectPanel";
    private static ArchiveFileDialog archiveFileDialog = new ArchiveFileDialog();
    private ImportWizardDialog parent;
    private JRadioButton radioArchiveFile;
    private JTextField txtArchiveFile;
    private Action actChooseFile;
    private JRadioButton radioDirectory;
    private JTextField txtDirectory;
    private Action actChooseDirectory;
    private JRadioButton radioURL;
    private JTextField txtURL;

    public ImportFileSelectPanel(ScaleSupport scaleSupport) {
        this.setLayout(new BorderLayout());
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/importwizdialog");
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.fireEvent();
            }

            protected void fireEvent() {
                ImportFileSelectPanel.this.fireChangeEvent();
            }
        };
        this.txtArchiveFile = new JTextField();
        this.txtDirectory = new JTextField();
        this.txtURL = new JTextField();
        this.txtArchiveFile.getDocument().addDocumentListener(documentListener);
        this.txtDirectory.getDocument().addDocumentListener(documentListener);
        this.txtURL.getDocument().addDocumentListener(documentListener);
        this.actChooseFile = new AbstractAction(strings.getProperty("browse")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportFileSelectPanel.this.onChooseFile();
            }
        };
        this.actChooseDirectory = new AbstractAction(strings.getProperty("browse")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportFileSelectPanel.this.onChooseDirectory();
            }
        };
        JPanel fileChoosePanel = new JPanel();
        GridBagLayout fileChoosePanelLayout = new GridBagLayout();
        fileChoosePanel.setLayout(fileChoosePanelLayout);
        this.radioArchiveFile = new JRadioButton(strings.getProperty("importingArchiveFile"));
        this.radioDirectory = new JRadioButton(strings.getProperty("importingDirectory"));
        this.radioURL = new JRadioButton(strings.getProperty("importingURL"));
        ChangeListener radioChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImportFileSelectPanel.this.updateUIState();
                ImportFileSelectPanel.this.fireChangeEvent();
            }
        };
        this.radioArchiveFile.addChangeListener(radioChangeListener);
        this.radioDirectory.addChangeListener(radioChangeListener);
        this.radioURL.addChangeListener(radioChangeListener);
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.radioArchiveFile);
        btnGroup.add(this.radioDirectory);
        btnGroup.add(this.radioURL);
        this.radioArchiveFile.setSelected(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipadx = 0;
        gbc.ipady = 0;
        int gap = (int)(3.0 * scaleSupport.getManualScaleX());
        gbc.insets = new Insets(gap, gap, gap, gap);
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        fileChoosePanel.add((Component)this.radioArchiveFile, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.ipadx = 45;
        gbc.weightx = 0.0;
        fileChoosePanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.ipadx = 0;
        gbc.weightx = 1.0;
        fileChoosePanel.add((Component)this.txtArchiveFile, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.ipadx = 0;
        gbc.weightx = 0.0;
        fileChoosePanel.add((Component)new JButton(this.actChooseFile), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.ipadx = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        fileChoosePanel.add((Component)this.radioDirectory, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.ipadx = 45;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        fileChoosePanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.ipadx = 0;
        gbc.weightx = 1.0;
        fileChoosePanel.add((Component)this.txtDirectory, gbc);
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.ipadx = 0;
        gbc.weightx = 0.0;
        fileChoosePanel.add((Component)new JButton(this.actChooseDirectory), gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 3;
        fileChoosePanel.add((Component)this.radioURL, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.ipadx = 45;
        gbc.weightx = 0.0;
        fileChoosePanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.ipadx = 0;
        gbc.weightx = 1.0;
        fileChoosePanel.add((Component)this.txtURL, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.ipadx = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        fileChoosePanel.add(Box.createGlue(), gbc);
        this.add((Component)fileChoosePanel, "Center");
        new DropTarget(this, new FileDropTarget(){

            @Override
            protected void onDropFiles(List<File> dropFiles) {
                if (dropFiles == null || dropFiles.isEmpty()) {
                    return;
                }
                File dropFile = dropFiles.get(0);
                ImportFileSelectPanel.this.setSelectFile(dropFile);
            }

            @Override
            protected void onException(Exception ex) {
                ErrorMessageHelper.showErrorDialog(ImportFileSelectPanel.this, ex);
            }
        });
        this.updateUIState();
    }

    public void setSelectFile(File dropFile) {
        if (dropFile == null) {
            this.txtDirectory.setText("");
            this.txtArchiveFile.setText("");
            this.txtURL.setText("");
            this.radioDirectory.setSelected(false);
            this.radioArchiveFile.setSelected(false);
            this.radioURL.setSelected(false);
        } else if (dropFile.isDirectory()) {
            this.txtDirectory.setText(dropFile.getPath());
            this.radioDirectory.setSelected(true);
        } else if (dropFile.isFile()) {
            this.txtArchiveFile.setText(dropFile.getPath());
            this.radioArchiveFile.setSelected(true);
        }
    }

    public void initSelectURL(String url) {
        if (url != null && (url.startsWith("http://") || url.startsWith("https://"))) {
            this.txtURL.setText(url);
            this.radioURL.setSelected(true);
        } else {
            this.txtDirectory.setText("");
            this.txtArchiveFile.setText("");
            this.txtURL.setText("");
            this.radioDirectory.setSelected(false);
            this.radioArchiveFile.setSelected(false);
            this.radioURL.setSelected(false);
        }
    }

    protected void updateUIState() {
        boolean enableArchiveFile = this.radioArchiveFile.isSelected();
        boolean enableDirectory = this.radioDirectory.isSelected();
        boolean enableURL = this.radioURL.isSelected();
        this.txtArchiveFile.setEnabled(enableArchiveFile);
        this.actChooseFile.setEnabled(enableArchiveFile);
        this.txtDirectory.setEnabled(enableDirectory);
        this.actChooseDirectory.setEnabled(enableDirectory);
        this.txtURL.setEnabled(enableURL);
    }

    protected void onChooseFile() {
        File file;
        File initFile = null;
        if (this.txtArchiveFile.getText().trim().length() > 0) {
            initFile = new File(this.txtArchiveFile.getText());
        }
        if ((file = archiveFileDialog.showOpenDialog(this, initFile)) != null) {
            this.txtArchiveFile.setText(file.getPath());
            this.fireChangeEvent();
        }
    }

    protected void onChooseDirectory() {
        String directoryTxt = this.txtDirectory.getText();
        JFileChooser dirChooser = new JFileChooser(directoryTxt);
        dirChooser.setFileSelectionMode(1);
        if (dirChooser.showOpenDialog(this) != 0) {
            return;
        }
        File dir = dirChooser.getSelectedFile();
        if (dir != null) {
            this.txtDirectory.setText(dir.getPath());
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean isReadyNext() {
        String url;
        String directoryTxt;
        String fileTxt;
        return this.radioArchiveFile.isSelected() ? (fileTxt = this.txtArchiveFile.getText()) != null && fileTxt.trim().length() > 0 : (this.radioDirectory.isSelected() ? (directoryTxt = this.txtDirectory.getText()) != null && directoryTxt.trim().length() > 0 : this.radioURL.isSelected() && (url = this.txtURL.getText()) != null && (url.startsWith("http://") || url.startsWith("https://")));
    }

    @Override
    public void onActive(ImportWizardDialog parent, ImportWizardCardPanel previousPanel) {
        this.parent = parent;
        this.closeArchive();
    }

    public void closeArchive() {
        try {
            this.parent.importModel.closeImportSource();
        }
        catch (IOException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    @Override
    public String doNext() {
        URI importArchive;
        File file;
        if (!this.isReadyNext()) {
            return null;
        }
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/importwizdialog");
        if (this.radioArchiveFile.isSelected()) {
            file = new File(this.txtArchiveFile.getText());
            if (!file.exists() || !file.isFile()) {
                JOptionPane.showMessageDialog(this, strings.getProperty("fileNotFound"), "ERROR", 0);
                return null;
            }
            importArchive = file.toURI();
        } else if (this.radioDirectory.isSelected()) {
            file = new File(this.txtDirectory.getText());
            if (!file.exists() || !file.isDirectory()) {
                JOptionPane.showMessageDialog(this, strings.getProperty("directoryNotFound"), "ERROR", 0);
                return null;
            }
            importArchive = file.toURI();
        } else if (this.radioURL.isSelected()) {
            File tmpFile = this.loadTemporaryFromURL(this.txtURL.getText());
            if (tmpFile == null) {
                return null;
            }
            importArchive = tmpFile.toURI();
        } else {
            return null;
        }
        try {
            this.parent.importModel.openImportSource(importArchive, this.parent.current);
            Worker<Void> worker = new Worker<Void>(){

                @Override
                public Void doWork(ProgressHandle progressHandle) throws IOException {
                    ((ImportFileSelectPanel)ImportFileSelectPanel.this).parent.importModel.loadContents(progressHandle);
                    return null;
                }
            };
            WorkerWithProgessDialog<Void> dlg = new WorkerWithProgessDialog<Void>(this.parent, worker);
            dlg.startAndWait();
            return "importTypeSelectPanel";
        }
        catch (WorkerException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex.getCause());
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
        return null;
    }

    private File loadTemporaryFromURL(final String url) {
        final Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/importwizdialog");
        AppConfig appConfig = AppConfig.getInstance();
        final DownloadUtils downloader = new DownloadUtils();
        downloader.setImpersonateUserAgent(appConfig.getImpersonateUserAgent());
        downloader.setDeleteDownloadFileOnExit(appConfig.isDeleteDownloadFileOnExit());
        try {
            Worker<File> worker = new Worker<File>(){

                @Override
                public File doWork(ProgressHandle progressHandle) throws IOException {
                    progressHandle.setIndeterminate(true);
                    progressHandle.setCaption(strings.getProperty("downloading.checkhead"));
                    DownloadUtils.HeadResponse headResponse = downloader.getHead(url);
                    String contentType = headResponse.getContentType();
                    String ext = headResponse.getDotExtension();
                    CharacterDataFileReaderWriterFactory archiveRdWrFactory = CharacterDataFileReaderWriterFactory.getInstance();
                    if (contentType == null || !contentType.startsWith("application/") || !archiveRdWrFactory.isSupportedFile(ext)) {
                        return null;
                    }
                    progressHandle.setCaption(strings.getProperty("downloading.waitForDownload"));
                    return downloader.downloadTemporary(headResponse);
                }
            };
            WorkerWithProgessDialog<File> dlg = new WorkerWithProgessDialog<File>(this.parent, worker);
            try {
                File tempFile = dlg.startAndWait();
                if (tempFile != null) {
                    return tempFile;
                }
                JOptionPane.showMessageDialog(this, strings.getProperty("downloading.invalidFileType"), "ERROR", 0);
                return null;
            }
            catch (WorkerException ex) {
                Throwable iex = ex.getCause();
                throw iex == null ? ex : (Exception)iex;
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, strings.getProperty("downloading.notFound"), "ERROR", 0);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
        return null;
    }
}

