/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.IndependentPartsSetInfo;
import charactermanaj.model.IndependentWorkingSet;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.WorkingSet;
import charactermanaj.model.io.WorkingSetXMLReader;
import charactermanaj.model.io.WorkingSetXMLWriter;
import charactermanaj.util.FileUtilities;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkingSetPersist {
    private static final Logger logger = Logger.getLogger(WorkingSetPersist.class.getName());
    private static final String WORKINGSET_FILE_SUFFIX = "workingset.xml";
    private static final WorkingSetPersist singletion = new WorkingSetPersist();
    private final UserDataFactory userDataFactory = UserDataFactory.getLocalInstance();

    public static WorkingSetPersist getInstance() {
        return singletion;
    }

    public void removeAllWorkingSet() {
        File dir = this.userDataFactory.getSpecialDataDir("foo-workingset.xml");
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(WorkingSetPersist.WORKINGSET_FILE_SUFFIX);
                }
            });
            if (files == null) {
                logger.log(Level.WARNING, "dir access failed. " + dir);
                return;
            }
            for (File file : files) {
                logger.log(Level.INFO, "remove file: " + file);
                try {
                    FileUtilities.delete(file);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "failed to remove file: " + file, ex);
                }
            }
        }
    }

    public void removeWorkingSet(CharacterData cd) {
        UserData workingSetXmlData = this.userDataFactory.getMangledNamedUserData(cd.getDocBase(), WORKINGSET_FILE_SUFFIX);
        if (workingSetXmlData != null && workingSetXmlData.exists()) {
            logger.log(Level.INFO, "remove file: " + workingSetXmlData);
            workingSetXmlData.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWorkingSet(WorkingSet workingSet) throws IOException {
        if (workingSet == null) {
            throw new IllegalArgumentException();
        }
        CharacterData characterData = workingSet.getCharacterData();
        if (characterData == null) {
            throw new IllegalArgumentException("character-data must be set.");
        }
        UserData workingSetXmlData = this.userDataFactory.getMangledNamedUserData(characterData.getDocBase(), WORKINGSET_FILE_SUFFIX);
        OutputStream outstm = workingSetXmlData.getOutputStream();
        try {
            WorkingSetXMLWriter workingSetXmlWriter = new WorkingSetXMLWriter();
            workingSetXmlWriter.writeWorkingSet(workingSet, outstm);
        }
        finally {
            outstm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkingSet loadWorkingSet(CharacterData characterData) throws IOException {
        IndependentWorkingSet workingSet2;
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        UserData workingSetXmlData = this.userDataFactory.getMangledNamedUserData(characterData.getDocBase(), WORKINGSET_FILE_SUFFIX);
        if (workingSetXmlData == null || !workingSetXmlData.exists()) {
            return null;
        }
        InputStream is = workingSetXmlData.openStream();
        try {
            WorkingSetXMLReader WorkingSetXMLReader2 = new WorkingSetXMLReader();
            workingSet2 = WorkingSetXMLReader2.loadWorkingSet(is);
        }
        finally {
            is.close();
        }
        URI docBase = characterData.getDocBase();
        if (docBase != null && !docBase.equals(workingSet2.getCharacterDocBase())) {
            logger.log(Level.INFO, "docBase missmatch");
            return null;
        }
        String sig = characterData.toSignatureString();
        if (!sig.equals(workingSet2.getCharacterDataSig())) {
            logger.log(Level.INFO, "character data structure missmatch");
            return null;
        }
        WorkingSet ws = new WorkingSet();
        ws.setCharacterData(characterData);
        ws.setCharacterDataRev(characterData.getRev());
        ws.setCharacterDocBase(docBase);
        ws.setLastUsedExportDir(workingSet2.getLastUsedExportDir());
        ws.setLastUsedSaveDir(workingSet2.getLastUsedSaveDir());
        Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap = characterData.getPartsColorManager().getPartsColorInfoMap();
        workingSet2.createCompatible(characterData, partsColorInfoMap);
        ws.setPartsColorInfoMap(partsColorInfoMap);
        IndependentPartsSetInfo partsSetInfo = workingSet2.getCurrentPartsSet();
        if (partsSetInfo != null) {
            PartsSet partsSet = IndependentPartsSetInfo.convertPartsSet(partsSetInfo, characterData, false);
            ws.setCurrentPartsSet(partsSet);
            IndependentPartsSetInfo lastUsePresetPartsInfo = workingSet2.getLastUsePresetParts();
            if (lastUsePresetPartsInfo != null && lastUsePresetPartsInfo.getId() != null && lastUsePresetPartsInfo.getId().trim().length() > 0) {
                PartsSet lastUsePresetParts = IndependentPartsSetInfo.convertPartsSet(lastUsePresetPartsInfo, characterData, false);
                ws.setLastUsePresetParts(lastUsePresetParts);
            }
        }
        ws.setWallpaperInfo(workingSet2.getWallpaperInfo());
        ws.setZoomFactor(workingSet2.getZoomFactor());
        ws.setViewPosition(workingSet2.getViewPosition());
        ws.setWindowRect(workingSet2.getWindowRect());
        ws.setNoNeedDataDownload(workingSet2.isNoNeedDataDownload());
        return ws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(final long expireDate) {
        String XML_SUFFIX = "-workingset.xml";
        UserDataFactory userDataFactory = UserDataFactory.getLocalInstance();
        File dir = userDataFactory.getSpecialDataDir("-workingset.xml");
        File[] xmls = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith("-workingset.xml") && pathname.lastModified() < expireDate && pathname.length() > 0L;
            }
        });
        if (xmls == null) {
            logger.log(Level.WARNING, "workingset-dir access failed.");
            return;
        }
        for (File xmlFile : xmls) {
            try {
                IndependentWorkingSet ws;
                WorkingSetXMLReader reader = new WorkingSetXMLReader();
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(xmlFile));
                try {
                    ws = reader.loadWorkingSet(is);
                }
                finally {
                    ((InputStream)is).close();
                }
                URI docBase = ws.getCharacterDocBase();
                if (!docBase.getScheme().equals("file")) continue;
                File characterXml = new File(docBase);
                if (!characterXml.exists()) {
                    logger.log(Level.INFO, "remove amandone workingset: " + xmlFile + ", docBase=" + docBase);
                    xmlFile.delete();
                    continue;
                }
                xmlFile.setLastModified(System.currentTimeMillis());
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "file access failed. " + xmlFile, ex);
            }
        }
    }
}

