/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.RecommendationURL;
import charactermanaj.model.io.CharacterDataDefaultProvider;
import java.util.List;

public final class RecommendationURLCompensator {
    private static final RecommendationURLCompensator INST = new RecommendationURLCompensator();

    private RecommendationURLCompensator() {
    }

    public static RecommendationURLCompensator getInstance() {
        return INST;
    }

    public void compensateRecommendationList(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        List<RecommendationURL> recommendations = this.getCompensateRecommendationList(characterData);
        if (recommendations != null) {
            characterData.setRecommendationURLList(recommendations);
        }
    }

    public List<RecommendationURL> getCompensateRecommendationList(CharacterData characterData) {
        if (characterData != null && characterData.getRecommendationURLList() == null) {
            CharacterDataDefaultProvider defProv = new CharacterDataDefaultProvider();
            for (CharacterDataDefaultProvider.DefaultCharacterDataVersion dataVersion : CharacterDataDefaultProvider.DefaultCharacterDataVersion.values()) {
                CharacterData defaultCd = defProv.createDefaultCharacterData(dataVersion);
                if (!defaultCd.toSignatureString().equals(characterData.toSignatureString())) continue;
                return defaultCd.getRecommendationURLList();
            }
        }
        return null;
    }

    public List<RecommendationURL> getUncompensateRecommendationList(CharacterData cd) {
        if (cd == null) {
            return null;
        }
        String cdSig = cd.toStructureString();
        List<RecommendationURL> recommendations = cd.getRecommendationURLList();
        if (recommendations != null) {
            CharacterDataDefaultProvider defProv = new CharacterDataDefaultProvider();
            for (CharacterDataDefaultProvider.DefaultCharacterDataVersion dataVersion : CharacterDataDefaultProvider.DefaultCharacterDataVersion.values()) {
                List<RecommendationURL> defaultRecommendationURLList;
                CharacterData defaultCd = defProv.createDefaultCharacterData(dataVersion);
                String defSig = defaultCd.toStructureString();
                if (!cdSig.equals(defSig) || (defaultRecommendationURLList = defaultCd.getRecommendationURLList()) == null || !defaultRecommendationURLList.equals(recommendations)) continue;
                recommendations = null;
                break;
            }
        }
        return recommendations;
    }
}

