/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.io.PNGFileImageHeader;
import charactermanaj.graphics.io.PNGFileImageHeaderReader;
import charactermanaj.model.CharacterData;
import charactermanaj.model.CustomLayerOrder;
import charactermanaj.model.CustomLayerOrderKey;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.io.CharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataDefaultProvider;
import charactermanaj.model.io.CharacterDataIniReader;
import charactermanaj.model.io.CharacterDataXMLReader;
import charactermanaj.model.io.CustomLayerOrderXMLReader;
import charactermanaj.model.io.PartsInfoXMLReader;
import charactermanaj.model.io.TextReadHelper;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public abstract class AbstractCharacterDataArchiveFile
implements CharacterDataArchiveFile {
    private static final Logger logger = Logger.getLogger(AbstractCharacterDataArchiveFile.class.getName());
    protected File archiveFile;
    protected String rootPrefix = "";
    protected HashMap<String, FileContent> entries = new HashMap();

    public String toString() {
        return "CharacterDataArchiveFile(file=" + this.archiveFile + ")";
    }

    protected AbstractCharacterDataArchiveFile(File archiveFile) {
        if (archiveFile == null) {
            throw new IllegalArgumentException();
        }
        this.archiveFile = archiveFile;
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    protected void addEntry(FileContent fileContent) {
        if (fileContent == null) {
            throw new IllegalArgumentException();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, fileContent.getEntryName());
        }
        this.entries.put(fileContent.getEntryName(), fileContent);
    }

    protected URI getContentURI(String name) throws IOException {
        try {
            URI baseURI = this.archiveFile.toURI();
            return new URI("jar:" + baseURI.toString() + "/!" + name);
        }
        catch (URISyntaxException ex) {
            IOException iex = new IOException(ex.getMessage());
            iex.initCause(ex);
            throw iex;
        }
    }

    @Override
    public boolean hasContent(String name) {
        return this.entries.containsKey(name);
    }

    public FileContent getContent(String name) {
        return this.entries.get(name);
    }

    @Override
    public String getRootPrefix() {
        return this.rootPrefix;
    }

    protected void searchRootPrefix() {
        HashSet<String> dirs = new HashSet<String>();
        for (String name : this.entries.keySet()) {
            int pos = name.indexOf(47);
            if (pos < 0) {
                this.rootPrefix = "";
                return;
            }
            if (pos < 0) continue;
            String dir = name.substring(0, pos + 1);
            dirs.add(dir);
        }
        if (dirs.size() == 1) {
            this.rootPrefix = (String)dirs.iterator().next();
            return;
        }
        this.rootPrefix = "";
    }

    public Map<String, FileContent> getFiles(String dir) {
        if (dir == null) {
            dir = "";
        }
        if (dir.length() > 0 && !dir.endsWith("/")) {
            dir = dir + "/";
        }
        if (dir.equals("/")) {
            dir = "";
        }
        HashMap<String, FileContent> files = new HashMap<String, FileContent>();
        int ep = dir.length();
        for (Map.Entry<String, FileContent> entry : this.entries.entrySet()) {
            String suffix;
            int sep;
            String name = entry.getKey();
            FileContent fileContent = entry.getValue();
            if (!name.startsWith(dir) || (sep = (suffix = name.substring(ep)).indexOf(47)) >= 0) continue;
            files.put(name, fileContent);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharacterData readCharacterData() {
        FileContent characterFile = this.entries.get(this.rootPrefix + "character.xml");
        if (characterFile == null) {
            return null;
        }
        CharacterDataXMLReader xmlReader = new CharacterDataXMLReader();
        try {
            CharacterData cd;
            InputStream is = characterFile.openStream();
            try {
                URI docBase = this.getContentURI(this.rootPrefix + "character.xml");
                cd = xmlReader.loadCharacterDataFromXML(is, docBase);
            }
            finally {
                is.close();
            }
            return cd;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "character.xml load failed.", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharacterData readCharacterINI() {
        FileContent characterFile = null;
        characterFile = this.entries.get(this.rootPrefix + "character.ini");
        boolean hasEyeColorFolder = false;
        ArrayList<String> characterInis = new ArrayList<String>();
        for (Map.Entry<String, FileContent> entry : this.entries.entrySet()) {
            String entryName = entry.getKey();
            if (entryName.endsWith("/character.ini")) {
                characterInis.add(entryName);
            }
            if (!entryName.contains("/eye_color/") && !entryName.endsWith("/eye_color")) continue;
            hasEyeColorFolder = true;
        }
        if (characterFile == null) {
            Collections.sort(characterInis);
            if (characterInis.size() > 0) {
                characterFile = this.entries.get(characterInis.get(0));
            }
        }
        if (characterFile == null) {
            return null;
        }
        CharacterDataDefaultProvider.DefaultCharacterDataVersion version = hasEyeColorFolder ? CharacterDataDefaultProvider.DefaultCharacterDataVersion.V3 : CharacterDataDefaultProvider.DefaultCharacterDataVersion.V2;
        try {
            CharacterData cd;
            InputStream is = characterFile.openStream();
            try {
                CharacterDataIniReader iniReader = new CharacterDataIniReader();
                cd = iniReader.readCharacterDataFromIni(is, version);
            }
            finally {
                is.close();
            }
            URI docBase = this.getContentURI(this.rootPrefix + "character.ini");
            cd.setDocBase(docBase);
            return cd;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "character.ini load failed", ex);
            return null;
        }
    }

    @Override
    public Map<CustomLayerOrderKey, List<CustomLayerOrder>> readCustomLayerPatterns(CharacterData cd) throws IOException {
        FileContent mapFile = this.entries.get(this.rootPrefix + "customlayerorders.xml");
        if (mapFile == null) {
            return null;
        }
        if (mapFile.length() == 0L) {
            return Collections.emptyMap();
        }
        CustomLayerOrderXMLReader xmlReader = new CustomLayerOrderXMLReader(cd);
        try {
            return xmlReader.read(mapFile.openStream());
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "customlayerorders.xml load failed.", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFavorites(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException("characterData\u306bnull\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        FileContent favoritesXml = this.entries.get(this.rootPrefix + "favorites.xml");
        if (favoritesXml == null) {
            return;
        }
        CharacterDataXMLReader xmlReader = new CharacterDataXMLReader();
        try {
            InputStream is = favoritesXml.openStream();
            try {
                xmlReader.loadPartsSet(characterData, is);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "favorites.xml load failed.", ex);
            }
            finally {
                is.close();
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "favorites.xml load failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage readSamplePicture() {
        FileContent samplePictureFile = this.entries.get(this.rootPrefix + "preview.png");
        if (samplePictureFile == null) {
            Map<String, FileContent> files = this.getFiles(this.rootPrefix);
            samplePictureFile = files.get("preview.jpg");
            if (samplePictureFile == null) {
                samplePictureFile = files.get("preview.jpeg");
            }
            if (samplePictureFile == null) {
                for (Map.Entry<String, FileContent> entry : files.entrySet()) {
                    String name = entry.getKey();
                    if (!name.endsWith(".jpg") && !name.endsWith(".jpeg") && !name.endsWith(".png")) continue;
                    samplePictureFile = entry.getValue();
                    break;
                }
            }
        }
        if (samplePictureFile == null) {
            return null;
        }
        try {
            BufferedImage pic;
            InputStream is = samplePictureFile.openStream();
            try {
                pic = ImageIO.read(is);
            }
            finally {
                is.close();
            }
            return pic;
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "sample picture load failed.", ex);
            return null;
        }
    }

    @Override
    public String readReadMe() {
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        ArrayList<FileContent> candiates = new ArrayList<FileContent>();
        Map<String, FileContent> files = this.getFiles(this.rootPrefix);
        block2: for (String findName : new String[]{"readme_" + lang + ".txt", "readme_" + lang, "readme.txt", "readme", null}) {
            for (Map.Entry<String, FileContent> entry : files.entrySet()) {
                String name = entry.getKey().toLowerCase();
                if (findName == null && name.endsWith(".txt")) {
                    candiates.add(entry.getValue());
                    continue block2;
                }
                if (!name.equals(findName)) continue;
                candiates.add(entry.getValue());
            }
        }
        if (candiates.isEmpty()) {
            return null;
        }
        for (FileContent file : candiates) {
            try {
                return this.readTextUTF16(file);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "read file failed. :" + file, ex);
            }
        }
        return null;
    }

    @Override
    public String readTextFile(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        FileContent content = this.entries.get(name);
        if (content == null) {
            return null;
        }
        return this.readTextUTF16(content);
    }

    public String readTextUTF16(FileContent content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException();
        }
        return TextReadHelper.readTextTryEncoding(content.openStream());
    }

    protected Map<String, Collection<CategoryLayerPair>> getLayerDirs(CharacterData characterData, boolean enabledRootPrefix) {
        if (characterData == null) {
            return Collections.emptyMap();
        }
        String rootPrefix = this.getRootPrefix();
        HashMap<String, Collection<CategoryLayerPair>> layerDirs = new HashMap<String, Collection<CategoryLayerPair>>();
        for (PartsCategory partsCategory : characterData.getPartsCategories()) {
            for (Layer layer : partsCategory.getLayers()) {
                Collection<CategoryLayerPair> sameDirLayers;
                String dir = layer.getDir();
                if (!dir.endsWith("/")) {
                    dir = dir + "/";
                }
                if (enabledRootPrefix) {
                    dir = rootPrefix + dir;
                }
                if ((sameDirLayers = layerDirs.get(dir)) == null) {
                    sameDirLayers = new ArrayList<CategoryLayerPair>();
                    layerDirs.put(dir, sameDirLayers);
                }
                sameDirLayers.add(new CategoryLayerPair(partsCategory, layer));
            }
        }
        return layerDirs;
    }

    @Override
    public Collection<PartsImageContent> getPartsImageContents(CharacterData characterData, boolean newly) {
        Collection<PartsImageContent> results = this.getPartsImageContentsStrict(characterData);
        if (results.isEmpty()) {
            results = this.getPartsImageContentsLazy(characterData);
        }
        return results;
    }

    protected Collection<PartsImageContent> getPartsImageContentsStrict(CharacterData characterData) {
        final Map<String, Collection<CategoryLayerPair>> layerDirMap = this.getLayerDirs(characterData, true);
        CategoryLayerPairResolveStrategy strategy = new CategoryLayerPairResolveStrategy(){

            @Override
            public Collection<CategoryLayerPair> resolveCategoryLayerPairs(String dir) {
                Collection categoryLayerPairs = (Collection)layerDirMap.get(dir);
                if (categoryLayerPairs == null || categoryLayerPairs.isEmpty()) {
                    return null;
                }
                return categoryLayerPairs;
            }
        };
        return this.getPartsImageContents(strategy);
    }

    protected Collection<PartsImageContent> getPartsImageContentsLazy(CharacterData characterData) {
        final Map<String, Collection<CategoryLayerPair>> layerDirMap = this.getLayerDirs(characterData, false);
        CategoryLayerPairResolveStrategy strategy = new CategoryLayerPairResolveStrategy(){

            @Override
            public Collection<CategoryLayerPair> resolveCategoryLayerPairs(String dir) {
                dir = dir == null ? "" : dir.toLowerCase();
                for (Map.Entry entry : layerDirMap.entrySet()) {
                    String dirSuffix = ((String)entry.getKey()).toLowerCase();
                    Collection categoryLayerPairs = (Collection)entry.getValue();
                    if (!dir.endsWith(dirSuffix)) continue;
                    return categoryLayerPairs;
                }
                return null;
            }
        };
        return this.getPartsImageContents(strategy);
    }

    protected Collection<PartsImageContent> getPartsImageContents(CategoryLayerPairResolveStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<PartsImageContent> results = new ArrayList<PartsImageContent>();
        for (Map.Entry<String, FileContent> entry : this.entries.entrySet()) {
            String dir;
            Collection<CategoryLayerPair> categoryLayerPairs;
            String lastName;
            String name = entry.getKey();
            FileContent fileContent = entry.getValue();
            String[] split = name.split("/");
            if (split.length < 2 || !(lastName = split[split.length - 1]).toLowerCase().endsWith(".png") || (categoryLayerPairs = strategy.resolveCategoryLayerPairs(dir = name.substring(0, name.length() - lastName.length()))) == null) continue;
            PNGFileImageHeader pngFileHeader = this.readPNGFileHeader(fileContent);
            if (pngFileHeader == null) {
                logger.log(Level.WARNING, "invalid png: " + name);
                continue;
            }
            int extpos = lastName.lastIndexOf(46);
            String partsName = lastName.substring(0, extpos);
            PartsImageContent partsImageContent = new PartsImageContent(fileContent, categoryLayerPairs, lastName, partsName, pngFileHeader);
            results.add(partsImageContent);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PNGFileImageHeader readPNGFileHeader(FileContent fileContent) {
        PNGFileImageHeaderReader pngHeaderReader = PNGFileImageHeaderReader.getInstance();
        PNGFileImageHeader pngFileHeader = null;
        try {
            InputStream is = fileContent.openStream();
            try {
                pngFileHeader = pngHeaderReader.readHeader(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "not png header. " + fileContent, ex);
            pngFileHeader = null;
        }
        return pngFileHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartsManageData getPartsManageData() throws IOException {
        PartsManageData partsManageData;
        FileContent content = this.entries.get(this.rootPrefix + "parts-info.xml");
        if (content == null) {
            return new PartsManageData();
        }
        InputStream is = content.openStream();
        try {
            PartsInfoXMLReader xmlWriter = new PartsInfoXMLReader();
            partsManageData = xmlWriter.loadPartsManageData(is);
        }
        finally {
            is.close();
        }
        return partsManageData;
    }

    protected static interface CategoryLayerPairResolveStrategy {
        public Collection<CategoryLayerPair> resolveCategoryLayerPairs(String var1);
    }

    public static final class PartsImageContent
    implements FileContent {
        private final FileContent fileContent;
        private final Collection<CategoryLayerPair> categoryLayerPairs;
        private final String dirName;
        private final String partsName;
        private final String fileName;
        private final PNGFileImageHeader pngFileImageHeader;

        protected PartsImageContent(FileContent fileContent, Collection<CategoryLayerPair> categoryLayerPairs, String fileName, String partsName, PNGFileImageHeader pngFileImageHeader) {
            if (fileContent == null || categoryLayerPairs == null || categoryLayerPairs.isEmpty() || fileName == null || partsName == null || pngFileImageHeader == null) {
                throw new IllegalArgumentException();
            }
            this.fileContent = fileContent;
            this.categoryLayerPairs = Collections.unmodifiableCollection(categoryLayerPairs);
            this.fileName = fileName;
            this.partsName = partsName;
            this.pngFileImageHeader = pngFileImageHeader;
            CategoryLayerPair categoryLayerPair = categoryLayerPairs.iterator().next();
            this.dirName = categoryLayerPair.getLayer().getDir();
        }

        public int hashCode() {
            return this.getEntryName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj instanceof PartsImageContent) {
                return this.getEntryName().equals(((PartsImageContent)obj).getEntryName());
            }
            return false;
        }

        public Collection<CategoryLayerPair> getCategoryLayerPairs() {
            return this.categoryLayerPairs;
        }

        public String getDirName() {
            return this.dirName;
        }

        @Override
        public String getEntryName() {
            return this.fileContent.getEntryName();
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getPartsName() {
            return this.partsName;
        }

        public PNGFileImageHeader getPngFileImageHeader() {
            return this.pngFileImageHeader;
        }

        @Override
        public long lastModified() {
            return this.fileContent.lastModified();
        }

        @Override
        public long length() {
            return this.fileContent.length();
        }

        @Override
        public InputStream openStream() throws IOException {
            return this.fileContent.openStream();
        }

        public String toString() {
            return this.fileContent.getEntryName();
        }
    }

    public static final class CategoryLayerPair {
        private PartsCategory partsCategory;
        private Layer layer;

        public CategoryLayerPair(PartsCategory partsCategory, Layer layer) {
            if (partsCategory == null || layer == null) {
                throw new IllegalArgumentException();
            }
            this.partsCategory = partsCategory;
            this.layer = layer;
        }

        public int hashCode() {
            return this.partsCategory.hashCode() ^ this.layer.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj instanceof CategoryLayerPair) {
                CategoryLayerPair o = (CategoryLayerPair)obj;
                return this.partsCategory.equals(o.partsCategory) && this.layer.equals(o.layer);
            }
            return false;
        }

        public Layer getLayer() {
            return this.layer;
        }

        public PartsCategory getPartsCategory() {
            return this.partsCategory;
        }

        public String toString() {
            return "(" + this.partsCategory + ":" + this.layer + ")";
        }
    }

    public static interface FileContent {
        public String getEntryName();

        public long lastModified();

        public long length();

        public InputStream openStream() throws IOException;
    }
}

