/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.CharacterData;
import charactermanaj.model.IndependentPartsColorInfo;
import charactermanaj.model.IndependentPartsSetInfo;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.model.WallpaperInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IndependentWorkingSet {
    private URI characterDocBase;
    private String characterDataSig;
    private Map<String, Map<String, List<IndependentPartsColorInfo>>> partsColorMap = Collections.emptyMap();
    private IndependentPartsSetInfo currentPartsSet;
    private File lastUsedSaveDir;
    private File lastUsedExportDir;
    private IndependentPartsSetInfo lastUsePresetParts;
    private WallpaperInfo wallpaperInfo;
    private Double zoomFactor;
    private Point viewPosition;
    private Rectangle windowRect;
    private boolean noNeedDataDownload;

    public void setCharacterDocBase(URI characterDocBase) {
        this.characterDocBase = characterDocBase;
    }

    public URI getCharacterDocBase() {
        return this.characterDocBase;
    }

    public String getCharacterDataSig() {
        return this.characterDataSig;
    }

    public void setCharacterDataSig(String characterDataSig) {
        this.characterDataSig = characterDataSig;
    }

    public Map<String, Map<String, List<IndependentPartsColorInfo>>> getPartsColorMap() {
        return this.partsColorMap;
    }

    public void setPartsColorMap(Map<String, Map<String, List<IndependentPartsColorInfo>>> partsColorMap) {
        if (partsColorMap == null) {
            this.partsColorMap = Collections.emptyMap();
        }
        this.partsColorMap = partsColorMap;
    }

    public void setLastUsedExportDir(File lastUsedExportDir) {
        this.lastUsedExportDir = lastUsedExportDir;
    }

    public File getLastUsedExportDir() {
        return this.lastUsedExportDir;
    }

    public void setLastUsedSaveDir(File lastUsedSaveDir) {
        this.lastUsedSaveDir = lastUsedSaveDir;
    }

    public File getLastUsedSaveDir() {
        return this.lastUsedSaveDir;
    }

    public void setWallpaperInfo(WallpaperInfo wallpaperInfo) {
        this.wallpaperInfo = wallpaperInfo;
    }

    public WallpaperInfo getWallpaperInfo() {
        return this.wallpaperInfo;
    }

    public Double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(Double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public Point getViewPosition() {
        return this.viewPosition;
    }

    public void setViewPosition(Point viewPosition) {
        this.viewPosition = viewPosition;
    }

    public Rectangle getWindowRect() {
        return this.windowRect;
    }

    public void setWindowRect(Rectangle windowRect) {
        this.windowRect = windowRect;
    }

    public IndependentPartsSetInfo getCurrentPartsSet() {
        return this.currentPartsSet;
    }

    public void setCurrentPartsSet(IndependentPartsSetInfo currentPartsSet) {
        this.currentPartsSet = currentPartsSet;
    }

    public IndependentPartsSetInfo getLastUsePresetParts() {
        return this.lastUsePresetParts;
    }

    public void setLastUsePresetParts(IndependentPartsSetInfo lastUsePresetParts) {
        this.lastUsePresetParts = lastUsePresetParts;
    }

    public boolean isNoNeedDataDownload() {
        return this.noNeedDataDownload;
    }

    public void setNoNeedDataDownload(boolean noNeedDataDownload) {
        this.noNeedDataDownload = noNeedDataDownload;
    }

    public void createCompatible(CharacterData characterData, Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap) {
        if (characterData == null || partsColorInfoMap == null) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<String, Map<String, List<IndependentPartsColorInfo>>> catEntry : this.partsColorMap.entrySet()) {
            String categoryId = catEntry.getKey();
            for (Map.Entry<String, List<IndependentPartsColorInfo>> layerEntry : catEntry.getValue().entrySet()) {
                String partsName = layerEntry.getKey();
                List<IndependentPartsColorInfo> partsColorInfos = layerEntry.getValue();
                PartsCategory partsCategory = characterData.getPartsCategory(categoryId);
                if (partsCategory == null) continue;
                String localizedName = partsName;
                PartsIdentifier partsIdentifier = new PartsIdentifier(partsCategory, partsName, localizedName);
                PartsColorInfo partsColorInfo = IndependentPartsColorInfo.buildPartsColorInfo(characterData, partsCategory, partsColorInfos);
                if (partsColorInfo == null) continue;
                partsColorInfoMap.put(partsIdentifier, partsColorInfo);
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(characterDocBase=").append(this.characterDocBase);
        buf.append(", characterDataSig=").append(this.characterDataSig);
        buf.append(", partsColorMap=").append(this.partsColorMap);
        buf.append(", currentPartsSet=").append(this.currentPartsSet);
        buf.append(", lastUsedSaveDir=").append(this.lastUsedSaveDir);
        buf.append(", lastUsedExportDir=").append(this.lastUsedExportDir);
        buf.append(", noNeedDataDownload=").append(this.noNeedDataDownload);
        buf.append(")");
        return buf.toString();
    }
}

