/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

public final class ColorGroup {
    private final String id;
    private final boolean enabled;
    private final String localizedName;
    public static final ColorGroup NA = new ColorGroup("n/a", "", false);

    public ColorGroup(String id, String localizedName) {
        this(id, localizedName, true);
    }

    private ColorGroup(String id, String localizedName, boolean enabled) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.id = id.trim();
        this.localizedName = localizedName == null || localizedName.trim().length() == 0 ? id : localizedName;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof ColorGroup) {
            ColorGroup o = (ColorGroup)obj;
            return this.id.equals(o.getId());
        }
        return false;
    }

    public static boolean equals(ColorGroup v1, ColorGroup v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    public String toString() {
        return this.getLocalizedName();
    }
}

