/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.model.OrderedMap;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.model.RecommendationURL;
import charactermanaj.model.io.PartsDataLoader;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharacterData
implements PartsSpecResolver {
    private static final Logger logger = Logger.getLogger(CharacterData.class.getName());
    public static final Comparator<CharacterData> SORT_DISPLAYNAME = new Comparator<CharacterData>(){

        @Override
        public int compare(CharacterData o1, CharacterData o2) {
            if (!o1.isValid() || !o2.isValid()) {
                return o1.isValid() == o2.isValid() ? 0 : (o1.isValid() ? 1 : -1);
            }
            int ret = o1.getName().compareTo(o2.getName());
            if (ret == 0) {
                ret = o1.getId().compareTo(o2.getId());
            }
            if (ret == 0) {
                ret = o1.getDocBase().toString().compareTo(o2.getDocBase().toString());
            }
            return ret;
        }
    };
    private URI docBase;
    private String id;
    private String rev;
    private String localizedName;
    private String author;
    private String description;
    private Dimension imageSize;
    private OrderedMap<String, PartsCategory> partsCategories = OrderedMap.emptyMap();
    private Properties properties = new Properties();
    private HashMap<String, PartsSet> presets = new HashMap();
    private String defaultPartsSetId;
    private OrderedMap<String, ColorGroup> colorGroups = OrderedMap.emptyMap();
    private List<RecommendationURL> recommendationURLList;
    private transient PartsColorManager partsColorMrg = new PartsColorManager(this);
    private transient PartsDataLoader partsDataLoader;
    private Map<PartsCategory, Map<PartsIdentifier, PartsSpec>> images = new HashMap<PartsCategory, Map<PartsIdentifier, PartsSpec>>();
    private static final String PROPNAME_WATCH_DIR = "watch-dir";
    private static final String PROPNAME_ENABLE_CUSTOM_LAYER_PATTERN = "custom-layer-pattern";

    public CharacterData duplicateBasicInfo() {
        return this.duplicateBasicInfo(true);
    }

    public CharacterData duplicateBasicInfo(boolean needPartsSets) {
        CharacterData cd = new CharacterData();
        cd.setId(this.id);
        cd.setRev(this.rev);
        cd.setDocBase(this.docBase);
        cd.setName(this.localizedName);
        cd.setAuthor(this.author);
        cd.setDescription(this.description);
        cd.setImageSize((Dimension)(this.imageSize == null ? null : this.imageSize.clone()));
        cd.setWatchDirectory(this.isWatchDirectory());
        cd.setEnableCustomLayerPattern(this.isEnableCustonLayerPattern());
        ArrayList<RecommendationURL> recommendationURLList = null;
        if (this.recommendationURLList != null) {
            recommendationURLList = new ArrayList<RecommendationURL>();
            for (RecommendationURL recommendationUrl : this.recommendationURLList) {
                recommendationURLList.add(recommendationUrl.clone());
            }
        }
        cd.setRecommendationURLList(recommendationURLList);
        ArrayList<PartsCategory> partsCategories = new ArrayList<PartsCategory>();
        partsCategories.addAll(this.getPartsCategories());
        cd.setPartsCategories(partsCategories.toArray(new PartsCategory[partsCategories.size()]));
        ArrayList<ColorGroup> colorGroups = new ArrayList<ColorGroup>();
        colorGroups.addAll(this.getColorGroups());
        cd.setColorGroups(colorGroups);
        if (needPartsSets) {
            for (PartsSet partsSet : this.getPartsSets().values()) {
                cd.addPartsSet(partsSet.clone());
            }
            cd.setDefaultPartsSetId(this.defaultPartsSetId);
        }
        return cd;
    }

    public boolean isSameStructure(CharacterData other) {
        if (!this.isValid() || other == null || !other.isValid()) {
            return false;
        }
        ArrayList<ColorGroup> colorGroup1 = new ArrayList<ColorGroup>(this.getColorGroups());
        ArrayList<ColorGroup> colorGroup2 = new ArrayList<ColorGroup>(other.getColorGroups());
        if (colorGroup1.size() != colorGroup2.size()) {
            return false;
        }
        if (!colorGroup1.containsAll(colorGroup2)) {
            return false;
        }
        ArrayList<PartsCategory> categories1 = new ArrayList<PartsCategory>(this.getPartsCategories());
        ArrayList<PartsCategory> categories2 = new ArrayList<PartsCategory>(other.getPartsCategories());
        Comparator<PartsCategory> sortCategoryId = new Comparator<PartsCategory>(){

            @Override
            public int compare(PartsCategory o1, PartsCategory o2) {
                int ret = o1.getCategoryId().compareTo(o2.getCategoryId());
                if (ret == 0) {
                    ret = o1.getOrder() - o2.getOrder();
                }
                return ret;
            }
        };
        Collections.sort(categories1, sortCategoryId);
        Collections.sort(categories2, sortCategoryId);
        int numOfCategories = categories1.size();
        if (numOfCategories != categories2.size()) {
            return false;
        }
        for (int idx = 0; idx < numOfCategories; ++idx) {
            String categoryId2;
            PartsCategory category1 = categories1.get(idx);
            PartsCategory category2 = categories2.get(idx);
            String categoryId1 = category1.getCategoryId();
            if (categoryId1.equals(categoryId2 = category2.getCategoryId())) continue;
            return false;
        }
        int mx = categories1.size();
        for (int idx = 0; idx < mx; ++idx) {
            PartsCategory category1 = categories1.get(idx);
            PartsCategory category2 = categories2.get(idx);
            ArrayList<Layer> layers1 = new ArrayList<Layer>(category1.getLayers());
            ArrayList<Layer> layers2 = new ArrayList<Layer>(category2.getLayers());
            Comparator<Layer> sortLayerId = new Comparator<Layer>(){

                @Override
                public int compare(Layer o1, Layer o2) {
                    int ret = o1.getId().compareTo(o2.getId());
                    if (ret == 0) {
                        ret = o1.getOrder() - o2.getOrder();
                    }
                    return ret;
                }
            };
            Collections.sort(layers1, sortLayerId);
            Collections.sort(layers2, sortLayerId);
            if (layers1.equals(layers2)) continue;
            return false;
        }
        return true;
    }

    public boolean isUpperCompatibleStructure(CharacterData other) {
        ArrayList<ColorGroup> colorGroupOld;
        if (!this.isValid() || other == null || !other.isValid()) {
            return false;
        }
        ArrayList<ColorGroup> colorGroupNew = new ArrayList<ColorGroup>(this.getColorGroups());
        if (!colorGroupNew.containsAll(colorGroupOld = new ArrayList<ColorGroup>(other.getColorGroups()))) {
            return false;
        }
        HashMap<String, PartsCategory> categoriesNew = new HashMap<String, PartsCategory>();
        for (PartsCategory category : this.getPartsCategories()) {
            categoriesNew.put(category.getCategoryId(), category);
        }
        HashMap<String, PartsCategory> categoriesOld = new HashMap<String, PartsCategory>();
        for (PartsCategory partsCategory : other.getPartsCategories()) {
            categoriesOld.put(partsCategory.getCategoryId(), partsCategory);
        }
        if (!categoriesNew.keySet().containsAll(categoriesOld.keySet())) {
            return false;
        }
        for (Map.Entry entry : categoriesOld.entrySet()) {
            String categoryId = (String)entry.getKey();
            PartsCategory categoryOld = (PartsCategory)entry.getValue();
            PartsCategory categoryNew = (PartsCategory)categoriesNew.get(categoryId);
            if (categoryNew == null) {
                return false;
            }
            HashMap<String, Layer> layersNew = new HashMap<String, Layer>();
            for (Layer layer : categoryNew.getLayers()) {
                layersNew.put(layer.getId(), layer);
            }
            HashMap<String, Layer> layersOld = new HashMap<String, Layer>();
            for (Layer layer : categoryOld.getLayers()) {
                layersOld.put(layer.getId(), layer);
            }
            if (!layersNew.keySet().containsAll(layersOld.keySet())) {
                return false;
            }
            for (Map.Entry entry2 : layersOld.entrySet()) {
                File dirNew;
                String layerId = (String)entry2.getKey();
                Layer layerOld = (Layer)entry2.getValue();
                Layer layerNew = (Layer)layersNew.get(layerId);
                if (layerNew == null) {
                    return false;
                }
                File dirOld = new File(layerOld.getDir());
                if (dirOld.equals(dirNew = new File(layerNew.getDir()))) continue;
                return false;
            }
        }
        return true;
    }

    public String toStructureString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{colorGroup:[");
        for (ColorGroup colorGroup : this.getColorGroups()) {
            buf.append(colorGroup.getId());
            buf.append(",");
        }
        buf.append("],");
        buf.append("category:[");
        for (PartsCategory category : this.getPartsCategories()) {
            buf.append("{id:");
            buf.append(category.getCategoryId());
            buf.append(",layer:[");
            for (Layer layer : category.getLayers()) {
                buf.append("{id:");
                buf.append(layer.getId());
                buf.append(",dir:");
                buf.append(layer.getDir());
                buf.append("},");
            }
            buf.append("]},");
        }
        buf.append("]}");
        return buf.toString();
    }

    public String toSignatureString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{id:");
        buf.append(this.getId());
        buf.append(",rev:");
        buf.append(this.getRev());
        buf.append(",structure:");
        buf.append(this.toStructureString());
        buf.append("}");
        return buf.toString();
    }

    public List<RecommendationURL> getRecommendationURLList() {
        return this.recommendationURLList;
    }

    public void setRecommendationURLList(List<RecommendationURL> recommendationURLList) {
        this.recommendationURLList = recommendationURLList;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        if (description != null) {
            description = description.replace("\r\n", "\n");
            description = description.replace("\r", "\n");
            description = description.replace("\n", System.getProperty("line.separator"));
        }
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public void setDocBase(URI docBase) {
        this.docBase = docBase;
    }

    public URI getDocBase() {
        return this.docBase;
    }

    public boolean isWatchDirectory() {
        try {
            String value = this.properties.getProperty(PROPNAME_WATCH_DIR);
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
        }
        catch (RuntimeException ex) {
            logger.log(Level.WARNING, "watch-dir property is invalid.", ex);
        }
        return true;
    }

    public void setWatchDirectory(boolean watchDir) {
        this.properties.setProperty(PROPNAME_WATCH_DIR, Boolean.toString(watchDir));
    }

    public boolean isEnableCustonLayerPattern() {
        try {
            String value = this.properties.getProperty(PROPNAME_ENABLE_CUSTOM_LAYER_PATTERN);
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
        }
        catch (RuntimeException ex) {
            logger.log(Level.WARNING, "custom-layer-pattern property is invalid.", ex);
        }
        return true;
    }

    public void setEnableCustomLayerPattern(boolean enableCustomLayerPattern) {
        this.properties.setProperty(PROPNAME_ENABLE_CUSTOM_LAYER_PATTERN, Boolean.toString(enableCustomLayerPattern));
    }

    public String getProperty(String key) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.properties.getProperty(key.trim());
    }

    public void setProperty(String key, String value) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.setProperty(key.trim(), value);
    }

    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Object key : this.properties.keySet()) {
            names.add(key.toString());
        }
        return names;
    }

    public boolean isValid() {
        return this.id != null && this.id.length() > 0 && this.localizedName != null && this.localizedName.length() > 0 && this.docBase != null;
    }

    public boolean canWrite() {
        try {
            this.checkWritable();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void checkWritable() throws IOException {
        if (this.docBase == null) {
            throw new IOException("invalid profile: " + this);
        }
        if (!"file".equals(this.docBase.getScheme())) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30d7\u30ed\u30c8\u30b3\u30eb\u3067\u306f\u306a\u3044\u305f\u3081\u66f8\u304d\u8fbc\u307f\u306f\u3067\u304d\u307e\u305b\u3093\u3002:" + this.docBase);
        }
        File xmlFile = new File(this.docBase);
        if (xmlFile.exists()) {
            if (!xmlFile.canWrite() || !xmlFile.canRead()) {
                throw new IOException("\u66f8\u304d\u8fbc\u307f\u3001\u3082\u3057\u304f\u306f\u8aad\u307f\u8fbc\u307f\u304c\u7981\u6b62\u3055\u308c\u3066\u3044\u308b\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u3067\u3059\u3002" + this.docBase);
            }
        } else {
            File parent = xmlFile.getParentFile();
            if (!parent.exists()) {
                throw new IOException("\u89aa\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u3042\u308a\u307e\u305b\u3093\u3002" + this.docBase);
            }
            if (!parent.canWrite() || !parent.canRead()) {
                throw new IOException("\u89aa\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u66f8\u304d\u8fbc\u307f\u3001\u3082\u3057\u304f\u306f\u8aad\u307f\u8fbc\u307f\u304c\u7981\u6b62\u3055\u308c\u3066\u3044\u307e\u3059\u3002" + this.docBase);
            }
        }
    }

    public void setName(String name) {
        this.localizedName = name;
    }

    public String getName() {
        return this.localizedName;
    }

    public void setImageSize(Dimension imageSize) {
        if (imageSize != null) {
            imageSize = (Dimension)imageSize.clone();
        }
        this.imageSize = imageSize;
    }

    @Override
    public Dimension getImageSize() {
        return this.imageSize != null ? (Dimension)this.imageSize.clone() : null;
    }

    public void setColorGroups(Collection<ColorGroup> colorGroups) {
        if (colorGroups == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ColorGroup> colorGroupWithNA = new ArrayList<ColorGroup>();
        colorGroupWithNA.add(ColorGroup.NA);
        for (ColorGroup colorGroup : colorGroups) {
            if (!colorGroup.isEnabled()) continue;
            colorGroupWithNA.add(colorGroup);
        }
        OrderedMap<String, ColorGroup> ret = new OrderedMap<String, ColorGroup>(colorGroupWithNA, new OrderedMap.KeyDetector<String, ColorGroup>(){

            @Override
            public String getKey(ColorGroup data) {
                return data.getId();
            }
        });
        this.colorGroups = ret;
    }

    public ColorGroup getColorGroup(String colorGroupId) {
        ColorGroup cg = this.colorGroups.get(colorGroupId);
        if (cg != null) {
            return cg;
        }
        return ColorGroup.NA;
    }

    public Collection<ColorGroup> getColorGroups() {
        return this.colorGroups.values();
    }

    @Override
    public PartsCategory getPartsCategory(String categoryId) {
        if (this.partsCategories == null) {
            return null;
        }
        return this.partsCategories.get(categoryId);
    }

    public void setPartsCategories(PartsCategory[] partsCategories) {
        if (partsCategories == null) {
            partsCategories = new PartsCategory[]{};
        }
        this.partsCategories = new OrderedMap<String, PartsCategory>(Arrays.asList(partsCategories), new OrderedMap.KeyDetector<String, PartsCategory>(){

            @Override
            public String getKey(PartsCategory data) {
                return data.getCategoryId();
            }
        });
    }

    @Override
    public List<PartsCategory> getPartsCategories() {
        return this.partsCategories.asList();
    }

    public boolean isPartsLoaded() {
        return this.partsDataLoader != null;
    }

    public void loadPartsData(PartsDataLoader partsDataLoader) {
        if (partsDataLoader == null) {
            throw new IllegalArgumentException();
        }
        this.partsDataLoader = partsDataLoader;
        this.reloadPartsData();
    }

    public int getPartsCount() {
        int cnt = 0;
        for (PartsCategory category : this.partsCategories.asList()) {
            Map<PartsIdentifier, PartsSpec> partsMap = this.images.get(category);
            if (partsMap == null) continue;
            cnt += partsMap.size();
        }
        return cnt;
    }

    public boolean reloadPartsData() {
        if (this.partsDataLoader == null) {
            throw new IllegalStateException("partsDataLoader is not set.");
        }
        this.images.clear();
        for (PartsCategory category : this.partsCategories.asList()) {
            this.images.put(category, this.partsDataLoader.load(category));
        }
        return true;
    }

    @Override
    public PartsSpec getPartsSpec(PartsIdentifier partsIdentifier) {
        PartsSpec partsSpec;
        if (partsIdentifier == null) {
            throw new IllegalArgumentException();
        }
        PartsCategory partsCategory = partsIdentifier.getPartsCategory();
        Map<PartsIdentifier, PartsSpec> partsSpecMap = this.images.get(partsCategory);
        if (partsSpecMap != null && (partsSpec = partsSpecMap.get(partsIdentifier)) != null) {
            return partsSpec;
        }
        return null;
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> getPartsSpecMap(PartsCategory category) {
        Map<PartsIdentifier, PartsSpec> partsImageMap = this.images.get(category);
        if (partsImageMap == null) {
            return Collections.emptyMap();
        }
        return partsImageMap;
    }

    public PartsColorManager getPartsColorManager() {
        return this.partsColorMrg;
    }

    public boolean addPartsSet(PartsSet partsSet) {
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        if (partsSet.getPartsSetId() == null || partsSet.getPartsSetId().length() == 0 || partsSet.getLocalizedName() == null || partsSet.getLocalizedName().length() == 0) {
            return false;
        }
        PartsSet compatiblePartsSet = partsSet.createCompatible(this);
        if (compatiblePartsSet.isEmpty()) {
            return false;
        }
        this.presets.put(compatiblePartsSet.getPartsSetId(), compatiblePartsSet);
        return true;
    }

    public Map<String, PartsSet> getPartsSets() {
        return this.presets;
    }

    public void clearPartsSets(boolean noRemovePreset) {
        if (!noRemovePreset) {
            this.presets.clear();
            this.defaultPartsSetId = null;
        } else {
            Iterator<Map.Entry<String, PartsSet>> ite = this.presets.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, PartsSet> entry = ite.next();
                if (entry.getValue().isPresetParts()) continue;
                if (entry.getKey().equals(this.defaultPartsSetId)) {
                    this.defaultPartsSetId = null;
                }
                ite.remove();
            }
        }
    }

    public String getDefaultPartsSetId() {
        return this.defaultPartsSetId;
    }

    public void setDefaultPartsSetId(String defaultPartsSetId) {
        this.defaultPartsSetId = defaultPartsSetId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("character-id: " + this.id);
        buf.append("/rev:" + this.rev);
        buf.append("/name:" + this.localizedName);
        buf.append("/image-size:" + this.imageSize.width + "x" + this.imageSize.height);
        buf.append("/docBase:" + this.docBase);
        return buf.toString();
    }
}

