/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.AsyncImageBuilder;
import charactermanaj.graphics.ImageBuilder;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.model.Layer;
import charactermanaj.model.LayerOrderMapper;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.model.io.PartsImageCollectionParser;
import java.io.IOException;

public abstract class ImageBuildJobAbstractAdaptor
implements AsyncImageBuilder.AsyncImageBuildJob {
    protected PartsImageCollectionParser partsImageCollectorParser;

    public ImageBuildJobAbstractAdaptor(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        this.partsImageCollectorParser = new PartsImageCollectionParser(partsSpecResolver);
    }

    @Override
    public void loadParts(final ImageBuilder.ImageSourceCollector collector) throws IOException {
        if (collector == null) {
            throw new IllegalArgumentException("collector is null");
        }
        PartsSet partsSet = this.getPartsSet();
        LayerOrderMapper layerOrderMapper = this.getLayerOrderMapper();
        if (partsSet == null) {
            throw new RuntimeException("PartsSet is null");
        }
        collector.setSize(this.partsImageCollectorParser.getPartsSpecResolver().getImageSize());
        collector.setImageBgColor(partsSet.getBgColor());
        collector.setAffineTramsform(partsSet.getAffineTransformParameter());
        this.partsImageCollectorParser.parse(partsSet, layerOrderMapper, new PartsImageCollectionParser.PartsImageCollectionHandler(){

            @Override
            public void detectImageSource(PartsIdentifier partsIdentifier, Layer layer, float layerOrder, ImageResource imageResource, ColorConvertParameter param) {
                if (param == null) {
                    param = new ColorConvertParameter();
                }
                String partsName = partsIdentifier.getPartsName();
                collector.setImageSource(partsName, layer, layerOrder, imageResource, param);
            }
        });
        collector.setComplite();
    }

    protected abstract PartsSet getPartsSet() throws IOException;

    protected abstract LayerOrderMapper getLayerOrderMapper();

    @Override
    public abstract void buildImage(ImageBuilder.ImageOutput var1);

    @Override
    public abstract void handleException(Throwable var1);

    @Override
    public void onAbandoned() {
    }

    @Override
    public void onQueueing(long ticket) {
    }
}

