/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BeanPropertiesUtilities {
    private static final Logger logger = Logger.getLogger(BeanPropertiesUtilities.class.getName());

    private BeanPropertiesUtilities() {
        throw new RuntimeException("utilities class.");
    }

    public static PropertyAccessorMap getPropertyAccessorMap(Class<?> beanClass) {
        BeanInfo beanInfo;
        if (beanClass == null) {
            throw new NullPointerException("beanClass");
        }
        TreeMap<String, PropertyAccessor> accessorMap = new TreeMap<String, PropertyAccessor>();
        final BeanHolder beanHolder = new BeanHolder();
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("bean intorospector failed. :" + beanClass, ex);
        }
        for (PropertyDescriptor propDesc : beanInfo.getPropertyDescriptors()) {
            String name = propDesc.getName();
            final Class<?> typ = propDesc.getPropertyType();
            final Method mtdReader = propDesc.getReadMethod();
            final Method mtdWriter = propDesc.getWriteMethod();
            if (mtdReader == null || mtdWriter == null) continue;
            PropertyAccessor accessor = new PropertyAccessor(){

                private Object getBean() {
                    Object bean = beanHolder.getBean();
                    if (bean == null) {
                        throw new IllegalStateException("bean not set.");
                    }
                    return bean;
                }

                @Override
                public Class<?> getPropertyType() {
                    return typ;
                }

                @Override
                public Object getValue() {
                    try {
                        return mtdReader.invoke(this.getBean(), new Object[0]);
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (ex.getCause() instanceof RuntimeException) {
                            throw (RuntimeException)ex.getCause();
                        }
                        throw new RuntimeException(ex);
                    }
                }

                @Override
                public void setValue(Object value) {
                    try {
                        mtdWriter.invoke(this.getBean(), value);
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (ex.getCause() instanceof RuntimeException) {
                            throw (RuntimeException)ex.getCause();
                        }
                        throw new RuntimeException(ex);
                    }
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                    T annt = mtdReader.getAnnotation(annotationClass);
                    if (annt == null) {
                        annt = mtdWriter.getAnnotation(annotationClass);
                    }
                    return annt;
                }
            };
            accessorMap.put(name, accessor);
        }
        return new PropertyAccessorMap(accessorMap, beanHolder);
    }

    public static Set<String> loadFromProperties(Object bean, Properties props) {
        if (bean == null || props == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> rejectNames = new HashSet<String>();
        PropertyAccessorMap accessorMap = BeanPropertiesUtilities.getPropertyAccessorMap(bean.getClass());
        accessorMap.setBean(bean);
        for (Map.Entry<String, PropertyAccessor> accessorEntry : accessorMap.entrySet()) {
            String name = accessorEntry.getKey();
            PropertyAccessor accessor = accessorEntry.getValue();
            Class<?> typ = accessor.getPropertyType();
            StringConverterSpec anntStringConverter = accessor.getAnnotation(StringConverterSpec.class);
            String strVal = props.getProperty(name);
            if (strVal == null) continue;
            Exception reject = null;
            try {
                Object val;
                if (anntStringConverter != null) {
                    Class<? extends StringConverter> convCls = anntStringConverter.value();
                    StringConverter conv = convCls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    val = conv.valueOf(strVal);
                } else if (String.class.equals(typ)) {
                    val = strVal;
                } else if (strVal.length() == 0) {
                    val = null;
                } else if (Boolean.class.equals(typ) || Boolean.TYPE.equals(typ)) {
                    val = Boolean.valueOf(strVal);
                } else if (Integer.class.equals(typ) || Integer.TYPE.equals(typ)) {
                    val = Integer.valueOf(strVal);
                } else if (Long.class.equals(typ) || Long.TYPE.equals(typ)) {
                    val = Long.valueOf(strVal);
                } else if (Float.class.equals(typ) || Float.TYPE.equals(typ)) {
                    val = Float.valueOf(strVal);
                } else if (Double.class.equals(typ) || Double.TYPE.equals(typ)) {
                    val = Double.valueOf(strVal);
                } else if (BigInteger.class.equals(typ)) {
                    val = new BigInteger(strVal);
                } else if (BigDecimal.class.equals(typ)) {
                    val = new BigDecimal(strVal);
                } else if (Color.class.equals(typ)) {
                    long decode = Long.decode(strVal);
                    val = (decode & 0xFFFFFFFFFF000000L) != 0L ? new Color((int)decode, true) : new Color((int)decode, false);
                } else {
                    rejectNames.add(name);
                    logger.log(Level.WARNING, "unsupported propery type: " + typ + "/beanClass=" + bean.getClass() + " #" + name);
                    continue;
                }
                accessor.setValue(val);
                reject = null;
            }
            catch (Exception ex) {
                reject = ex;
            }
            if (reject == null) continue;
            rejectNames.add(name);
            logger.log(Level.WARNING, "invalid propery: " + typ + "/beanClass=" + bean.getClass() + " #" + name + " /val=" + strVal, reject);
        }
        return rejectNames;
    }

    public static void saveToProperties(Object bean, Properties props) {
        if (bean == null || props == null) {
            throw new IllegalArgumentException();
        }
        try {
            PropertyAccessorMap accessorMap = BeanPropertiesUtilities.getPropertyAccessorMap(bean.getClass());
            accessorMap.setBean(bean);
            for (Map.Entry<String, PropertyAccessor> accessorEntry : accessorMap.entrySet()) {
                String strVal;
                String name = accessorEntry.getKey();
                PropertyAccessor accessor = accessorEntry.getValue();
                StringConverterSpec anntStringConverter = accessor.getAnnotation(StringConverterSpec.class);
                Object val = accessor.getValue();
                if (anntStringConverter != null) {
                    StringConverter conv = anntStringConverter.value().getConstructor(new Class[0]).newInstance(new Object[0]);
                    strVal = conv.toString(val);
                } else if (val == null) {
                    strVal = "";
                } else if (val instanceof String) {
                    strVal = (String)val;
                } else if (val instanceof Number) {
                    strVal = ((Number)val).toString();
                } else if (val instanceof Boolean) {
                    strVal = (Boolean)val != false ? "true" : "false";
                } else if (val instanceof Color) {
                    Color color = (Color)val;
                    int alpha = color.getAlpha();
                    strVal = alpha == 255 ? "#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) : "#" + Long.toHexString((long)color.getRGB() & 0xFFFFFFFFL);
                } else {
                    logger.log(Level.WARNING, "unsupported propery type: " + val.getClass() + "/beanClass=" + bean.getClass() + " #" + name);
                    continue;
                }
                props.setProperty(name, strVal);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("bean property read failed. :" + bean.getClass(), ex);
        }
    }

    public static interface PropertyAccessor {
        public Class<?> getPropertyType();

        public Object getValue();

        public void setValue(Object var1);

        public <T extends Annotation> T getAnnotation(Class<T> var1);
    }

    public static class BeanHolder {
        private Object bean;

        public Object getBean() {
            return this.bean;
        }

        public void setBean(Object bean) {
            this.bean = bean;
        }
    }

    public static class PropertyAccessorMap
    extends AbstractMap<String, PropertyAccessor> {
        private final BeanHolder beanHolder;
        private final Map<String, PropertyAccessor> accessorMap;

        public PropertyAccessorMap(Map<String, PropertyAccessor> accessorMap, BeanHolder beanHolder) {
            this.accessorMap = accessorMap;
            this.beanHolder = beanHolder;
        }

        public Object getBean() {
            return this.beanHolder.getBean();
        }

        public void setBean(Object bean) {
            this.beanHolder.setBean(bean);
        }

        @Override
        public Set<Map.Entry<String, PropertyAccessor>> entrySet() {
            return this.accessorMap.entrySet();
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StringConverterSpec {
        public Class<? extends StringConverter> value();
    }

    public static class UnsignedHexStringConverter
    implements StringConverter {
        @Override
        public Object valueOf(String text) {
            String string = text = text != null ? text.trim() : null;
            if (text != null && text.length() > 0) {
                return (int)Long.decode(text).longValue();
            }
            return 0;
        }

        @Override
        public String toString(Object obj) {
            if (obj != null) {
                return "#" + Long.toString(((Number)obj).longValue() & 0xFFFFFFFFL, 16);
            }
            return "";
        }
    }

    public static interface StringConverter {
        public Object valueOf(String var1);

        public String toString(Object var1);
    }
}

