/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.ui.MainFrame;
import charactermanaj.util.ErrorMessageHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class AWTExceptionLoggingHandler {
    private static final Logger logger = Logger.getLogger(AWTExceptionLoggingHandler.class.getName());

    public void handle(final Throwable ex) {
        logger.log(Level.SEVERE, "exception occurred on the event dispatch thread.  " + ex, ex);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame currentFrame = MainFrame.getActivedMainFrame();
                if (currentFrame == null || !currentFrame.isDisplayable() || !currentFrame.isVisible()) {
                    currentFrame = null;
                }
                ErrorMessageHelper.showErrorDialog(currentFrame, ex);
            }
        });
    }
}

