/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.ui.model.PartsSelectionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ColorGroupCoordinator {
    private final PartsSelectionManager partsSelectionMrg;
    private final LinkedList<ColorDialog> colorDialogs = new LinkedList();
    private final LinkedList<ColorChangeListener> listeners = new LinkedList();
    private final PartsColorManager partsColorMrg;
    protected final ColorChangeListener listener;

    public ColorGroupCoordinator(PartsSelectionManager partsSelectionMrg, PartsColorManager partsColorMrg) {
        if (partsSelectionMrg == null || partsColorMrg == null) {
            throw new IllegalArgumentException();
        }
        this.partsSelectionMrg = partsSelectionMrg;
        this.partsColorMrg = partsColorMrg;
        this.listener = new ColorChangeListener(){

            @Override
            public void onColorChange(ColorChangeEvent event) {
                Layer layer = event.getLayer();
                ColorDialog colorDialog = (ColorDialog)event.getSource();
                PartsCategory partsCategory = colorDialog.getPartsCategory();
                ColorGroupCoordinator.this.syncColorGroup(partsCategory, layer, colorDialog);
                ColorGroupCoordinator.this.fireColorChangeEvent(event);
            }

            @Override
            public void onColorGroupChange(ColorChangeEvent event) {
                Layer layer = event.getLayer();
                ColorDialog colorDialog = (ColorDialog)event.getSource();
                ColorGroup colorGroup = colorDialog.getColorGroup(layer);
                ColorGroupCoordinator.this.onChangeColorGroup(colorDialog, layer, colorGroup);
                ColorGroupCoordinator.this.fireColorGroupChangeEvent(event);
            }
        };
    }

    public void registerColorDialog(ColorDialog colorDialog) {
        if (colorDialog == null) {
            throw new IllegalArgumentException();
        }
        this.colorDialogs.add(colorDialog);
        colorDialog.addColorChangeListener(this.listener);
    }

    public void unregisterColorDialog(ColorDialog colorDialog) {
        Iterator ite = this.colorDialogs.iterator();
        while (ite.hasNext()) {
            ColorDialog dlg = (ColorDialog)ite.next();
            if (dlg != colorDialog) continue;
            dlg.removeColorChangeListener(this.listener);
            ite.remove();
        }
    }

    public void addColorChangeListener(ColorChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public void removeColorChangeListener(ColorChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireColorChangeEvent(ColorChangeEvent e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        for (ColorChangeListener listener : this.listeners) {
            listener.onColorChange(e);
        }
    }

    protected void fireColorGroupChangeEvent(ColorChangeEvent e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        for (ColorChangeListener listener : this.listeners) {
            listener.onColorGroupChange(e);
        }
    }

    protected void onChangeColorGroup(ColorDialog destColorDialog, Layer layer, ColorGroup colorGroup) {
        if (destColorDialog == null || layer == null || colorGroup == null) {
            throw new IllegalArgumentException();
        }
        block0: for (ColorDialog colorDlg : this.colorDialogs) {
            for (Layer srcLayer : colorDlg.getPartsCategory().getLayers()) {
                if (srcLayer.equals(layer) || !ColorGroup.equals(colorGroup, colorDlg.getColorGroup(srcLayer)) || !colorDlg.isSyncColorGroup(srcLayer)) continue;
                ColorConvertParameter param = colorDlg.getColorConvertParameter(srcLayer);
                destColorDialog.setColorConvertParameter(layer, param);
                continue block0;
            }
        }
    }

    public void syncColorGroup(PartsCategory partsCategory, Layer eventSourceLayer, ColorDialog sourceColorDialog) {
        if (partsCategory == null || sourceColorDialog == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Layer> syncSources = new ArrayList<Layer>();
        if (eventSourceLayer != null) {
            if (sourceColorDialog.isSyncColorGroup(eventSourceLayer)) {
                syncSources.add(eventSourceLayer);
            }
        } else {
            for (Layer layer2 : partsCategory.getLayers()) {
                if (!sourceColorDialog.isSyncColorGroup(layer2)) continue;
                syncSources.add(layer2);
            }
        }
        for (Layer sourceLayer : syncSources) {
            ColorGroup sourceColorGroup = sourceColorDialog.getColorGroup(sourceLayer);
            if (sourceColorGroup == null || !sourceColorGroup.isEnabled()) continue;
            ColorConvertParameter param = sourceColorDialog.getColorConvertParameter(sourceLayer);
            for (ColorDialog targetColorDialog : this.colorDialogs) {
                for (Layer targetLayer : targetColorDialog.getPartsCategory().getLayers()) {
                    if (targetLayer.equals(sourceLayer) || !ColorGroup.equals(targetColorDialog.getColorGroup(targetLayer), sourceColorGroup) || !targetColorDialog.isSyncColorGroup(targetLayer)) continue;
                    targetColorDialog.setColorConvertParameter(targetLayer, param);
                }
            }
            for (PartsCategory targetPartsCategory : this.partsSelectionMrg.getAllCategories()) {
                List<PartsIdentifier> selectedPartss = this.partsSelectionMrg.getSelectedPartsIdentifiers(targetPartsCategory);
                for (PartsIdentifier partsIdentifier : selectedPartss) {
                    PartsColorInfo partsColorInfo = this.partsColorMrg.getPartsColorInfo(partsIdentifier, true);
                    for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
                        ColorInfo colorInfo = entry.getValue();
                        if (!ColorGroup.equals(sourceColorGroup, colorInfo.getColorGroup()) || !colorInfo.isSyncColorGroup()) continue;
                        colorInfo.setColorParameter(param);
                    }
                }
            }
        }
    }
}

